/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.homescreen;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.homescreen.ConversationCard;
import io.intercom.android.sdk.homescreen.ConversationCardLoadingViewHolder;
import io.intercom.android.sdk.homescreen.ErrorViewHolder;
import io.intercom.android.sdk.homescreen.HomeClickListener;
import io.intercom.android.sdk.homescreen.MessengerAppCardViewHolder;
import io.intercom.android.sdk.homescreen.NewConversationCardViewHolder;
import io.intercom.android.sdk.homescreen.RecentConversationCardViewHolder;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.HomeCard;
import io.intercom.android.sdk.models.HomeErrorRow;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.com.bumptech.glide.RequestManager;
import io.intercom.com.google.gson.Gson;
import io.intercom.com.squareup.otto.Bus;
import java.util.List;

public class HomeCardAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private final List<Object> cardList;
    private final Store<State> store;
    private final Provider<AppConfig> appConfigProvider;
    private final Bus bus;
    private final Gson gson;
    private final MetricTracker metricTracker;
    private final TimeFormatter timeFormatter;
    private final RequestManager requestManager;
    private final UserIdentity userIdentity;
    private final HomeClickListener clickListener;
    private final Activity activity;

    public HomeCardAdapter(List<Object> cardList, Store<State> store, Provider<AppConfig> appConfigProvider, Bus bus, Gson gson, MetricTracker metricTracker, TimeFormatter timeFormatter, RequestManager requestManager, HomeClickListener clickListener, UserIdentity userIdentity, Activity activity) {
        this.cardList = cardList;
        this.store = store;
        this.appConfigProvider = appConfigProvider;
        this.bus = bus;
        this.gson = gson;
        this.metricTracker = metricTracker;
        this.timeFormatter = timeFormatter;
        this.requestManager = requestManager;
        this.userIdentity = userIdentity;
        this.clickListener = clickListener;
        this.activity = activity;
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        if (viewType == 0) {
            View view = inflater.inflate(R.layout.intercom_new_conversation_card, parent, false);
            return new NewConversationCardViewHolder(view, this.appConfigProvider, this.clickListener);
        }
        if (viewType == 1) {
            View view = inflater.inflate(R.layout.intercom_recent_conversation_card, parent, false);
            return new RecentConversationCardViewHolder(view, this.timeFormatter, this.appConfigProvider, this.requestManager, this.clickListener);
        }
        if (viewType == 2) {
            View view = inflater.inflate(R.layout.intercom_messenger_app_card, parent, false);
            return new MessengerAppCardViewHolder(view, this.bus, this.appConfigProvider, this.gson, this.metricTracker, this.activity);
        }
        if (viewType == 4) {
            View view = inflater.inflate(R.layout.intercom_home_error_row, parent, false);
            return new ErrorViewHolder(view, this.appConfigProvider, this.clickListener);
        }
        View view = inflater.inflate(R.layout.intercom_row_card_loading, parent, false);
        return new ConversationCardLoadingViewHolder(view, this.appConfigProvider);
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        TeamPresence teamPresence = this.store.select(Selectors.TEAM_PRESENCE);
        Object card = this.cardList.get(position);
        if (card instanceof ConversationCard) {
            ConversationCard conversationCard = (ConversationCard)card;
            if (holder instanceof NewConversationCardViewHolder) {
                ((NewConversationCardViewHolder)holder).bindTeamPresence(teamPresence, this.requestManager, conversationCard);
            } else if (holder instanceof RecentConversationCardViewHolder) {
                ((RecentConversationCardViewHolder)holder).bindConversationCard(conversationCard, this.userIdentity, this.appConfigProvider.get(), teamPresence);
            }
        } else if (card instanceof HomeCard) {
            HomeCard messengerAppCard = (HomeCard)card;
            ((MessengerAppCardViewHolder)holder).bindCard(messengerAppCard.fallbackUrl());
        }
    }

    public int getItemCount() {
        return this.cardList.size();
    }

    public int getItemViewType(int position) {
        Object item = this.cardList.get(position);
        if (item instanceof ConversationCard) {
            ConversationCard conversationCard = (ConversationCard)this.cardList.get(position);
            if (conversationCard.isLoading()) {
                return 3;
            }
            return conversationCard.recentConversations().isEmpty() ? 0 : 1;
        }
        if (item instanceof HomeErrorRow) {
            return 4;
        }
        return 2;
    }
}

