/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.Nullable;
import android.support.design.widget.AppBarLayout;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.imageloader.WallpaperLoader;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.ImageUtils;
import io.intercom.android.sdk.utilities.WindowUtils;
import io.intercom.com.bumptech.glide.RequestManager;
import io.intercom.com.bumptech.glide.TransitionOptions;
import io.intercom.com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import io.intercom.com.bumptech.glide.request.RequestOptions;
import java.io.IOException;

public class HomeToolbar
extends Toolbar {
    private final TextView greeting;
    private final TextView intro;
    private final ImageView logo;
    private final ImageView backgroundImage;

    public HomeToolbar(Context context) {
        this(context, null);
    }

    public HomeToolbar(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        View toolbar = HomeToolbar.inflate((Context)context, (int)R.layout.intercom_home_toolbar, (ViewGroup)this);
        this.greeting = (TextView)toolbar.findViewById(R.id.intercom_toolbar_greeting);
        this.intro = (TextView)toolbar.findViewById(R.id.intercom_toolbar_intro);
        this.logo = (ImageView)toolbar.findViewById(R.id.intercom_toolbar_logo);
        this.backgroundImage = (ImageView)toolbar.findViewById(R.id.wallpaper_image);
    }

    public void updateToolbarColors(AppConfig appConfig) {
        boolean secondaryColorRenderDarkText = appConfig.secondaryColorRenderDarkText();
        ColorUtils.setTextColorWhiteOrBlack(this.intro, secondaryColorRenderDarkText);
        ColorUtils.setTextColorWhiteOrBlack(this.greeting, secondaryColorRenderDarkText);
    }

    public void loadWallpaper(WallpaperLoader wallpaperLoader) {
        wallpaperLoader.loadWallpaperInto(this.backgroundImage);
    }

    public void closeWallpaperLoader(WallpaperLoader wallpaperLoader) {
        try {
            wallpaperLoader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void updateContent(AppConfig appConfig, RequestManager requestManager) {
        View toolbarContent = this.findViewById(R.id.toolbar_content_container);
        toolbarContent.setVisibility(appConfig.isReceivedFromServer() ? 0 : 8);
        String greetingText = appConfig.getTeamGreeting();
        String introText = appConfig.getTeamIntro();
        String url = appConfig.getMessengerLogoUrl();
        if (TextUtils.isEmpty((CharSequence)greetingText)) {
            this.greeting.setVisibility(8);
        } else {
            this.greeting.setVisibility(0);
            this.greeting.setText((CharSequence)greetingText);
        }
        if (TextUtils.isEmpty((CharSequence)introText)) {
            this.intro.setVisibility(8);
        } else {
            this.intro.setVisibility(0);
            this.intro.setText((CharSequence)introText);
        }
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.logo.setVisibility(8);
        } else {
            this.logo.setVisibility(0);
            RequestOptions options = new RequestOptions().diskCacheStrategy(ImageUtils.getDiskCacheStrategy(url));
            requestManager.load(url).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).apply(options).into(this.logo);
        }
        int contentHeight = appConfig.isReceivedFromServer() ? this.getContentHeight(toolbarContent) : this.getDefaultToolbarHeight(toolbarContent.getResources());
        this.setLayoutParams((ViewGroup.LayoutParams)new AppBarLayout.LayoutParams(-1, contentHeight));
        this.requestLayout();
    }

    public int getContentHeight(View toolbarContent) {
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)ScreenUtils.getScreenDimensions((Context)this.getContext()).x, (int)0x40000000);
        toolbarContent.measure(widthSpec, 0);
        return toolbarContent.getMeasuredHeight();
    }

    public int getDefaultToolbarHeight(Resources resources) {
        return resources.getDimensionPixelSize(R.dimen.intercom_toolbar_height) + WindowUtils.getStatusBarHeight(resources);
    }

    public void animateIn(View toolbarContent) {
        toolbarContent.startAnimation(AnimationUtils.loadAnimation((Context)toolbarContent.getContext(), (int)R.anim.intercom_home_header_slide_in));
    }
}

