/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.support.annotation.Nullable;
import com.google.auto.value.AutoValue;
import io.intercom.android.sdk.commons.utilities.CollectionUtils;
import io.intercom.android.sdk.models.AutoValue_TeamPresence;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.utilities.NullSafety;
import java.util.ArrayList;
import java.util.List;

@AutoValue
public abstract class TeamPresence {
    public static TeamPresence create(List<Participant> activeAdmins, String expectedResponseDelay, String officeHours) {
        return new AutoValue_TeamPresence(activeAdmins, expectedResponseDelay, officeHours);
    }

    public abstract List<Participant> getActiveAdmins();

    public abstract String getExpectedResponseDelay();

    public abstract String getOfficeHours();

    public boolean isEmpty() {
        return this.getActiveAdmins().isEmpty() && this.getExpectedResponseDelay().isEmpty();
    }

    public static final class Builder {
        @Nullable
        List<Participant.Builder> active_admins;
        @Nullable
        String expected_response_delay;
        @Nullable
        String office_hours;

        public TeamPresence build() {
            ArrayList<Participant> activeAdmins = new ArrayList<Participant>(CollectionUtils.capacityFor(this.active_admins));
            if (this.active_admins != null) {
                for (Participant.Builder participantBuilder : this.active_admins) {
                    if (participantBuilder == null) continue;
                    activeAdmins.add(participantBuilder.build());
                }
            }
            return TeamPresence.create(activeAdmins, NullSafety.valueOrEmpty(this.expected_response_delay), NullSafety.valueOrEmpty(this.office_hours));
        }
    }
}

