/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.commons.utilities.DeviceUtils;
import io.intercom.android.sdk.commons.utilities.TimeProvider;
import io.intercom.android.sdk.identity.AppIdentity;

public class ShutdownState {
    private static final String PREFS_SHUTDOWN_FINGERPRINT = "ShutdownFingerprint";
    private static final String PREFS_SHUTDOWN_EXPIRY = "ShutdownExpiry";
    private static final String PREFS_SHUTDOWN_REASON = "ShutdownReason";
    private final SharedPreferences prefs;
    private final Context context;
    private final AppIdentity appIdentity;
    private final TimeProvider timeProvider;
    @VisibleForTesting
    long shutdownExpiry;
    private String shutdownReason;
    @VisibleForTesting
    String shutdownFingerprint;

    public ShutdownState(Context context, AppIdentity appIdentity, TimeProvider timeProvider) {
        this.context = context;
        this.appIdentity = appIdentity;
        this.prefs = context.getSharedPreferences("INTERCOM_SHUTDOWN_PREFS", 0);
        this.timeProvider = timeProvider;
        this.shutdownExpiry = this.prefs.getLong(PREFS_SHUTDOWN_EXPIRY, timeProvider.currentTimeMillis());
        this.shutdownReason = this.prefs.getString(PREFS_SHUTDOWN_REASON, "");
        this.shutdownFingerprint = this.prefs.getString(PREFS_SHUTDOWN_FINGERPRINT, ShutdownState.generateAppFingerprint(context, appIdentity));
    }

    public boolean canSendNetworkRequests() {
        boolean hasExpired = this.shutdownExpiry <= this.timeProvider.currentTimeMillis();
        boolean fingerprintsMatch = this.shutdownFingerprint.equals(ShutdownState.generateAppFingerprint(this.context, this.appIdentity));
        return hasExpired || !fingerprintsMatch;
    }

    public void updateShutdownState(long shutdownPeriodMs, String shutdownReason) {
        this.shutdownExpiry = this.timeProvider.currentTimeMillis() + shutdownPeriodMs;
        this.shutdownReason = shutdownReason;
        this.shutdownFingerprint = ShutdownState.generateAppFingerprint(this.context, this.appIdentity);
        this.persistCachedAttributes();
    }

    public String getShutdownReason() {
        return this.shutdownReason;
    }

    private void persistCachedAttributes() {
        this.prefs.edit().putString(PREFS_SHUTDOWN_FINGERPRINT, this.shutdownFingerprint).putString(PREFS_SHUTDOWN_REASON, this.shutdownReason).putLong(PREFS_SHUTDOWN_EXPIRY, this.shutdownExpiry).apply();
    }

    private static String generateAppFingerprint(Context context, AppIdentity appIdentity) {
        return context.getPackageName() + "-" + DeviceUtils.getAppVersion((Context)context) + "-" + appIdentity.appId() + "-" + "5.0.1";
    }
}

