/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.provider;

import android.support.annotation.Nullable;
import io.intercom.com.bumptech.glide.load.ResourceEncoder;
import java.util.ArrayList;
import java.util.List;

public class ResourceEncoderRegistry {
    final List<Entry<?>> encoders = new ArrayList();

    public synchronized <Z> void add(Class<Z> resourceClass, ResourceEncoder<Z> encoder) {
        this.encoders.add(new Entry<Z>(resourceClass, encoder));
    }

    @Nullable
    public synchronized <Z> ResourceEncoder<Z> get(Class<Z> resourceClass) {
        int size = this.encoders.size();
        for (int i = 0; i < size; ++i) {
            Entry<Z> entry = this.encoders.get(i);
            if (!entry.handles(resourceClass)) continue;
            return entry.encoder;
        }
        return null;
    }

    private static final class Entry<T> {
        private final Class<T> resourceClass;
        final ResourceEncoder<T> encoder;

        Entry(Class<T> resourceClass, ResourceEncoder<T> encoder) {
            this.resourceClass = resourceClass;
            this.encoder = encoder;
        }

        boolean handles(Class<?> resourceClass) {
            return this.resourceClass.isAssignableFrom(resourceClass);
        }
    }
}

