/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.profile;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Space;
import android.widget.TextView;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.commons.utilities.TimeProvider;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Location;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.SocialAccount;
import io.intercom.android.sdk.profile.ProfilePresenter;
import io.intercom.android.sdk.profile.ProfileToolbarBehavior;
import io.intercom.android.sdk.profile.TeammateProfileToolbarBehavior;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.GroupConversationTextFormatter;
import io.intercom.android.sdk.utilities.ImageUtils;
import io.intercom.android.sdk.utilities.IntentUtils;
import io.intercom.android.sdk.utilities.LocationFormatter;
import io.intercom.android.sdk.views.ActiveStatePresenter;
import io.intercom.com.bumptech.glide.RequestManager;
import io.intercom.com.bumptech.glide.TransitionOptions;
import io.intercom.com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import io.intercom.com.bumptech.glide.request.RequestOptions;
import java.util.Date;
import java.util.List;

class TeammateProfilePresenter {
    private static final int FADE_DURATION_MS = 150;
    private final Space topSpacer;
    private final Space bottomSpacer;
    private final TextView titleView;
    private final TextView titleViewNameOnly;
    private final TextView subtitleView;
    private final TextView roleView;
    final TextView locationView;
    private final TextView bioView;
    private final ImageView avatarView1;
    private final ImageView avatarView2;
    private final ImageView avatarView3;
    private final View activeStateView;
    private final ImageView backgroundImageView;
    private final ProfileToolbarBehavior toolbarBehavior;
    private final LinearLayout socialLayout;
    private final ViewGroup rootLayout;
    private final LinearLayout groupConversationBanner;
    private final LinearLayout avatarHolder;
    private final Provider<AppConfig> appConfigProvider;
    private final ImageButton twitterButton;
    private final ImageButton linkedInButton;
    private final ProfilePresenter profilePresenter;
    private final RequestManager requestManager;
    Location lastAdminLocation;
    private final ActiveStatePresenter activeStatePresenter;
    private final Drawable avatarStroke;
    private final int borderSize;
    private final Runnable timeUpdate = new Runnable(){

        @Override
        public void run() {
            TeammateProfilePresenter.this.locationView.removeCallbacks((Runnable)this);
            Context context = TeammateProfilePresenter.this.locationView.getContext();
            CharSequence locationString = LocationFormatter.getLocationString(context, TeammateProfilePresenter.this.lastAdminLocation, new Date());
            TeammateProfilePresenter.this.setTextAndVisibility(TeammateProfilePresenter.this.locationView, locationString);
            LocationFormatter.postOnNextMinute((View)TeammateProfilePresenter.this.locationView, this, TimeProvider.SYSTEM);
        }
    };

    TeammateProfilePresenter(CoordinatorLayout rootView, @ColorInt int baseColor, ProfilePresenter profilePresenter, Provider<AppConfig> appConfigProvider, RequestManager requestManager) {
        this.profilePresenter = profilePresenter;
        this.appConfigProvider = appConfigProvider;
        this.requestManager = requestManager;
        this.rootLayout = (ViewGroup)rootView.findViewById(R.id.intercom_teammate_profile_container_view);
        this.rootLayout.setBackgroundColor(baseColor);
        this.topSpacer = (Space)this.rootLayout.findViewById(R.id.intercom_avatar_spacer);
        this.bottomSpacer = (Space)this.rootLayout.findViewById(R.id.intercom_bottom_spacer);
        this.titleView = (TextView)this.rootLayout.findViewById(R.id.intercom_collapsing_title);
        this.titleViewNameOnly = (TextView)this.rootLayout.findViewById(R.id.intercom_collapsing_title_name_only);
        this.subtitleView = (TextView)this.rootLayout.findViewById(R.id.intercom_collapsing_subtitle);
        this.roleView = (TextView)this.rootLayout.findViewById(R.id.intercom_collapsing_role);
        this.locationView = (TextView)this.rootLayout.findViewById(R.id.intercom_collapsing_location);
        this.bioView = (TextView)this.rootLayout.findViewById(R.id.intercom_collapsing_bio);
        this.avatarView1 = (ImageView)this.rootLayout.findViewById(R.id.intercom_collapsing_teammate_avatar1);
        this.avatarView2 = (ImageView)this.rootLayout.findViewById(R.id.intercom_collapsing_teammate_avatar2);
        this.avatarView3 = (ImageView)this.rootLayout.findViewById(R.id.intercom_collapsing_teammate_avatar3);
        this.activeStateView = this.rootLayout.findViewById(R.id.intercom_collapsing_teammate_active_state);
        this.twitterButton = (ImageButton)this.rootLayout.findViewById(R.id.twitter_button);
        this.linkedInButton = (ImageButton)this.rootLayout.findViewById(R.id.linkedin_button);
        this.backgroundImageView = (ImageView)rootView.findViewById(R.id.collapsing_background_image);
        this.socialLayout = (LinearLayout)rootView.findViewById(R.id.social_button_layout);
        this.groupConversationBanner = (LinearLayout)rootView.findViewById(R.id.intercom_group_conversations_banner);
        this.avatarHolder = (LinearLayout)rootView.findViewById(R.id.intercom_group_avatar_holder);
        this.toolbarBehavior = new TeammateProfileToolbarBehavior(this.rootLayout);
        this.activeStatePresenter = new ActiveStatePresenter();
        this.borderSize = ScreenUtils.dpToPx((float)2.0f, (Context)rootView.getContext());
        this.avatarStroke = ContextCompat.getDrawable((Context)rootView.getContext(), (int)R.drawable.intercom_solid_circle);
        this.avatarStroke.setColorFilter(appConfigProvider.get().getBaseColor(), PorterDuff.Mode.MULTIPLY);
        BackgroundUtils.setBackground((View)this.avatarView1, this.avatarStroke);
        BackgroundUtils.setBackground((View)this.avatarView2, this.avatarStroke);
        BackgroundUtils.setBackground((View)this.avatarView3, this.avatarStroke);
        this.avatarView1.setPadding(this.borderSize, this.borderSize, this.borderSize, this.borderSize);
        this.avatarView2.setPadding(this.borderSize, this.borderSize, this.borderSize, this.borderSize);
        this.avatarView3.setPadding(this.borderSize, this.borderSize, this.borderSize, this.borderSize);
    }

    ViewGroup getRootLayout() {
        return this.rootLayout;
    }

    ProfileToolbarBehavior getToolbarBehavior() {
        return this.toolbarBehavior;
    }

    private void setSocialAccounts(final SocialAccount twitter, final SocialAccount linkedIn, final Context context) {
        if (twitter == SocialAccount.NULL) {
            this.twitterButton.setVisibility(8);
        } else {
            this.twitterButton.setVisibility(0);
            this.twitterButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)twitter.getProfileUrl()));
                    IntentUtils.safelyOpenIntent(context, intent);
                }
            });
        }
        if (linkedIn == SocialAccount.NULL) {
            this.linkedInButton.setVisibility(8);
        } else {
            this.linkedInButton.setVisibility(0);
            this.linkedInButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)linkedIn.getProfileUrl()));
                    IntentUtils.safelyOpenIntent(context, intent);
                }
            });
        }
        if (this.linkedInButton.getVisibility() == 8 && this.twitterButton.getVisibility() == 8) {
            this.socialLayout.setVisibility(8);
        } else {
            this.socialLayout.setVisibility(0);
        }
    }

    private void setToolbarBackground(Avatar avatar, int height) {
        String imageUrl = avatar.getImageUrl();
        if (!TextUtils.isEmpty((CharSequence)imageUrl)) {
            this.requestManager.load((Object)imageUrl).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).apply(new RequestOptions().diskCacheStrategy(ImageUtils.getDiskCacheStrategy(imageUrl)).override(this.rootLayout.getMeasuredWidth(), height)).into(this.backgroundImageView);
        }
    }

    void setPresence(LastParticipatingAdmin lastParticipant, List<Participant> groupParticipants, CharSequence lastActiveTime, int maxWidth, AppBarLayout appBarLayout, ProfilePresenter.ProfileState profileState, View teamLayout, View titleLayoutCoordinator) {
        int height;
        appBarLayout.removeOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)this.toolbarBehavior);
        if (this.rootLayout.getAlpha() < 1.0f) {
            if (this.profilePresenter.isDidShowUnknown()) {
                this.rootLayout.setAlpha(1.0f);
                teamLayout.setAlpha(0.0f);
                appBarLayout.setExpanded(profileState == ProfilePresenter.ProfileState.EXPANDED, true);
                this.profilePresenter.setDidShowUnknown(false);
            } else {
                this.rootLayout.animate().alpha(1.0f).setDuration(150L).start();
                teamLayout.animate().alpha(0.0f).setDuration(150L).start();
            }
        }
        Context context = this.rootLayout.getContext();
        this.titleView.setText(GroupConversationTextFormatter.groupConversationTitle(lastParticipant.getFirstName(), groupParticipants.size(), context));
        this.titleViewNameOnly.setText((CharSequence)lastParticipant.getFirstName());
        this.setTeammateSubtitle(lastActiveTime);
        int numberOfParticipants = groupParticipants.size();
        AvatarUtils.loadAvatarIntoView(lastParticipant.getAvatar(), this.avatarView1, this.appConfigProvider.get(), this.requestManager);
        if (numberOfParticipants > 0) {
            AvatarUtils.loadAvatarIntoView(groupParticipants.get(numberOfParticipants - 1).getAvatar(), this.avatarView2, this.appConfigProvider.get(), this.requestManager);
        }
        if (numberOfParticipants > 1) {
            AvatarUtils.loadAvatarIntoView(groupParticipants.get(numberOfParticipants - 2).getAvatar(), this.avatarView3, this.appConfigProvider.get(), this.requestManager);
        }
        this.activeStateView.setVisibility(0);
        this.activeStatePresenter.presentStateDot(lastParticipant.isActive(), this.activeStateView, this.appConfigProvider.get());
        this.setTextAndVisibility(this.roleView, lastParticipant.getJobTitle());
        this.lastAdminLocation = lastParticipant.getLocation();
        this.timeUpdate.run();
        this.setTextAndVisibility(this.bioView, lastParticipant.getIntro());
        this.setSocialAccounts(lastParticipant.getTwitter(), lastParticipant.getLinkedIn(), context);
        if (maxWidth == 0) {
            maxWidth = ScreenUtils.getScreenDimensions((Context)context).x;
        }
        this.setGroupConversationParticipants(groupParticipants, maxWidth);
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)maxWidth, (int)0x40000000);
        this.rootLayout.measure(widthSpec, 0);
        titleLayoutCoordinator.getLayoutParams().height = height = this.rootLayout.getMeasuredHeight();
        titleLayoutCoordinator.requestLayout();
        this.backgroundImageView.getLayoutParams().height = height;
        Resources resources = context.getResources();
        this.rootLayout.getLayoutParams().height = resources.getDimensionPixelSize(R.dimen.intercom_toolbar_height);
        this.rootLayout.requestLayout();
        this.profilePresenter.applyOffsetChangedListener(this.toolbarBehavior);
        this.setToolbarBackground(lastParticipant.getAvatar(), height);
    }

    private void setGroupConversationParticipants(List<Participant> groupParticipants, int width) {
        if (groupParticipants.size() > 0) {
            this.groupConversationBanner.setVisibility(0);
        } else {
            this.groupConversationBanner.setVisibility(8);
        }
        this.avatarHolder.removeAllViews();
        Context context = this.avatarHolder.getContext();
        int avatarSpacingDp = ScreenUtils.dpToPx((float)8.0f, (Context)context);
        int padding = context.getResources().getDimensionPixelSize(R.dimen.intercom_group_conversations_banner_padding);
        int avatarDiameter = context.getResources().getDimensionPixelSize(R.dimen.intercom_teammate_avatar_size);
        int numberOfAvatarsToShow = (width - padding * 2) / (avatarDiameter + avatarSpacingDp);
        if (numberOfAvatarsToShow > groupParticipants.size()) {
            numberOfAvatarsToShow = groupParticipants.size();
        }
        for (int i = 0; i < numberOfAvatarsToShow; ++i) {
            if (i == numberOfAvatarsToShow - 1 && numberOfAvatarsToShow < groupParticipants.size()) {
                TextView others = new TextView(context);
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(avatarDiameter, avatarDiameter);
                others.setLayoutParams((ViewGroup.LayoutParams)params);
                others.setTextColor(-1);
                others.setGravity(17);
                int difference = groupParticipants.size() - numberOfAvatarsToShow + 1;
                String count = "+" + difference;
                others.setText((CharSequence)count);
                this.avatarHolder.addView((View)others);
                continue;
            }
            Participant participant = groupParticipants.get(i);
            if (participant == Participant.NULL) continue;
            ImageView avatarView = new ImageView(context);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(avatarDiameter, avatarDiameter);
            params.setMargins(0, 0, avatarSpacingDp, 0);
            avatarView.setLayoutParams((ViewGroup.LayoutParams)params);
            AvatarUtils.loadAvatarIntoView(participant.getAvatar(), avatarView, this.appConfigProvider.get(), this.requestManager);
            this.avatarHolder.addView((View)avatarView);
        }
    }

    void setTextAndVisibility(TextView textView, CharSequence text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            textView.setVisibility(8);
        } else {
            textView.setVisibility(0);
            textView.setText(text);
            this.topSpacer.setVisibility(0);
        }
    }

    void setTeammateSubtitle(@Nullable CharSequence subtitle) {
        this.subtitleView.setText(subtitle);
    }

    void stopUpdatingTime() {
        this.locationView.removeCallbacks(this.timeUpdate);
    }
}

