/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.actions;

import android.app.Activity;
import android.net.Uri;
import io.intercom.android.sdk.Intercom;
import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.models.BaseResponse;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.ConversationsResponse;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.models.UsersResponse;
import io.intercom.android.sdk.state.ReplyPart;

public class Actions {
    private static final Object NONE = "No Value";

    public static Action<BaseResponse> baseResponseReceived(BaseResponse response) {
        return new Action<BaseResponse>(Action.Type.BASE_RESPONSE_RECEIVED, response);
    }

    public static Action<?> softReset() {
        return Actions.noValueAction(Action.Type.SOFT_RESET);
    }

    public static Action<?> hardReset() {
        return Actions.noValueAction(Action.Type.HARD_RESET);
    }

    public static Action<Conversation> newConversationSuccess(Conversation conversation) {
        return new Action<Conversation>(Action.Type.NEW_CONVERSATION_SUCCESS, conversation);
    }

    public static Action<?> inboxOpened() {
        return Actions.noValueAction(Action.Type.INBOX_OPENED);
    }

    public static Action<?> composerOpened() {
        return Actions.noValueAction(Action.Type.NEW_CONVERSATION_SCREEN_OPENED);
    }

    public static Action<?> composerInputChanged() {
        return Actions.noValueAction(Action.Type.COMPOSER_INPUT_CHANGED);
    }

    public static Action<?> composerSendButtonPressed() {
        return Actions.noValueAction(Action.Type.COMPOSER_SEND_BUTTON_PRESSED);
    }

    public static Action<String> conversationOpened(String conversationId) {
        return new Action<String>(Action.Type.CONVERSATION_OPENED, conversationId);
    }

    public static Action<?> conversationClosed() {
        return Actions.noValueAction(Action.Type.CONVERSATION_CLOSED);
    }

    public static Action<String> conversationMarkedAsRead(String conversationId) {
        return new Action<String>(Action.Type.CONVERSATION_MARKED_AS_READ, conversationId);
    }

    public static Action<Conversation> conversationMarkedAsDismissed(Conversation conversation) {
        return new Action<Conversation>(Action.Type.CONVERSATION_MARKED_AS_DISMISSED, conversation);
    }

    public static Action<UsersResponse> unreadConversationsSuccess(UsersResponse response) {
        return new Action<UsersResponse>(Action.Type.UNREAD_CONVERSATIONS_SUCCESS, response);
    }

    public static Action<?> fetchInboxRequest() {
        return Actions.noValueAction(Action.Type.FETCH_INBOX_REQUEST);
    }

    public static Action<Long> fetchInboxBeforeDateRequest(long createdAt) {
        return new Action<Long>(Action.Type.FETCH_INBOX_BEFORE_DATE_REQUEST, createdAt);
    }

    public static Action<?> fetchInboxFailed() {
        return Actions.noValueAction(Action.Type.FETCH_INBOX_FAILED);
    }

    public static Action<ConversationsResponse> fetchInboxSuccess(ConversationsResponse response) {
        return new Action<ConversationsResponse>(Action.Type.FETCH_INBOX_SUCCESS, response);
    }

    public static Action<Conversation> fetchConversationSuccess(Conversation conversation) {
        return new Action<Conversation>(Action.Type.FETCH_CONVERSATION_SUCCESS, conversation);
    }

    public static Action<TeamPresence> teamPresenceUpdated(TeamPresence teamPresence) {
        return new Action<TeamPresence>(Action.Type.TEAM_PRESENCE_UPDATED, teamPresence);
    }

    public static Action<ReplyPart> conversationReplySuccess(ReplyPart replyPart) {
        return new Action<ReplyPart>(Action.Type.CONVERSATION_REPLY_SUCCESS, replyPart);
    }

    public static Action<Intercom.Visibility> setInAppNotificationVisibility(Intercom.Visibility visibility) {
        return new Action<Intercom.Visibility>(Action.Type.SET_IN_APP_NOTIFICATION_VISIBILITY, visibility);
    }

    public static Action<Intercom.Visibility> setLauncherVisibility(Intercom.Visibility visibility) {
        return new Action<Intercom.Visibility>(Action.Type.SET_LAUNCHER_VISIBILITY, visibility);
    }

    public static Action<String> newCommentEventReceived(String conversationId) {
        return new Action<String>(Action.Type.NEW_COMMENT_EVENT_RECEIVED, conversationId);
    }

    public static Action<Integer> setBottomPadding(int bottomPadding) {
        return new Action<Integer>(Action.Type.SET_BOTTOM_PADDING, bottomPadding);
    }

    public static Action<String> composerTypedIn(String conversationId) {
        return new Action<String>(Action.Type.COMPOSER_TYPED_IN, conversationId);
    }

    public static Action<String> composerCleared(String conversationId) {
        return new Action<String>(Action.Type.COMPOSER_CLEARED, conversationId);
    }

    public static Action<Long> appEnteredForeground(long timestamp) {
        return new Action<Long>(Action.Type.APP_ENTERED_FOREGROUND, timestamp);
    }

    public static Action<Activity> activityReadyForViewAttachment(Activity activity) {
        return new Action<Activity>(Action.Type.ACTIVITY_READY_FOR_VIEW_ATTACHMENT, activity);
    }

    public static Action<Activity> activityPaused(Activity activity) {
        return new Action<Activity>(Action.Type.ACTIVITY_PAUSED, activity);
    }

    public static Action<Activity> activityStopped(Activity activity) {
        return new Action<Activity>(Action.Type.ACTIVITY_STOPPED, activity);
    }

    public static Action<Uri> screenshotTaken(Uri uri) {
        return new Action<Uri>(Action.Type.SCREENSHOT_TAKEN, uri);
    }

    public static Action<?> screenshotDeleted() {
        return Actions.noValueAction(Action.Type.SCREENSHOT_DELETED);
    }

    public static Action<?> screenshotLightboxOpened() {
        return Actions.noValueAction(Action.Type.SCREENSHOT_LIGHTBOX_OPENED);
    }

    public static Action<Long> appEnteredBackground(long timestamp) {
        return new Action<Long>(Action.Type.APP_ENTERED_BACKGROUND, timestamp);
    }

    public static Action<?> sessionStarted() {
        return Actions.noValueAction(Action.Type.SESSION_STARTED);
    }

    private static Action<?> noValueAction(Action.Type type) {
        return new Action<Object>(type, NONE);
    }
}

