/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.content.Intent;
import android.graphics.PorterDuff;
import android.net.Uri;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.VideoProvider;
import io.intercom.android.sdk.blocks.blockInterfaces.VideoBlock;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.IntentUtils;
import io.intercom.com.bumptech.glide.RequestManager;
import io.intercom.com.bumptech.glide.load.resource.drawable.GlideDrawable;
import io.intercom.com.bumptech.glide.request.RequestListener;
import io.intercom.com.bumptech.glide.request.target.Target;
import io.intercom.okhttp3.Call;
import io.intercom.okhttp3.Callback;
import io.intercom.okhttp3.Response;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class Video
implements VideoBlock {
    private static final int PLAY_BUTTON_DIAMETER_DP = 48;
    private final StyleType style;
    private final Api api;
    private final Provider<AppConfig> appConfigProvider;
    private final Twig twig = LumberMill.getLogger();
    private final RequestManager requestManager;

    Video(StyleType style2, Api api, Provider<AppConfig> appConfigProvider, RequestManager requestManager) {
        this.style = style2;
        this.api = api;
        this.appConfigProvider = appConfigProvider;
        this.requestManager = requestManager;
    }

    public View addVideo(String videoUrl, VideoProvider provider, String id2, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        Context context = parent.getContext();
        RelativeLayout rootView = this.getBaseLayout(context);
        ImageView videoImageView = this.getVideoImageView(context);
        ImageView playButton = this.getPlayButtonView(context);
        rootView.addView((View)videoImageView);
        rootView.addView((View)playButton);
        int color2 = this.appConfigProvider.get().getBaseColor();
        if (this.style == StyleType.POST) {
            color2 = ColorUtils.lightenColor(color2);
        }
        playButton.setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
        this.fetchThumbnail(provider, id2, videoImageView, playButton);
        BlockUtils.setLayoutMarginsAndGravity((View)rootView, 3, isLastObject);
        return rootView;
    }

    @VisibleForTesting
    void fetchThumbnail(VideoProvider provider, final String id2, final ImageView videoImageView, final ImageView playButton) {
        switch (provider) {
            case WISTIA: {
                this.api.getVideo("http://fast.wistia.com/oembed?url=http://home.wistia.com/medias/" + id2, new Callback(){

                    public void onFailure(Call call, IOException e) {
                        Video.this.setFailedImage(videoImageView);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onResponse(Call call, Response response) throws IOException {
                        if (response.isSuccessful()) {
                            final String videoUrl = "http://fast.wistia.net/embed/iframe/" + id2;
                            JSONObject video = new JSONObject();
                            try {
                                video = new JSONObject(response.body().string());
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                            catch (IOException e) {
                                Video.this.twig.internal("ErrorObject", "Couldn't read response body: " + e.getMessage());
                            }
                            finally {
                                response.body().close();
                            }
                            String thumbnailUrl = video.optString("thumbnail_url");
                            int end = thumbnailUrl.indexOf("?image_crop_resized");
                            if (end > 0) {
                                thumbnailUrl = thumbnailUrl.substring(0, end);
                            }
                            final String finalThumbnailUrl = thumbnailUrl;
                            videoImageView.post(new Runnable(){

                                @Override
                                public void run() {
                                    Video.this.createThumbnail(videoImageView, videoUrl, finalThumbnailUrl, playButton);
                                }
                            });
                        } else {
                            Video.this.setFailedImage(videoImageView);
                        }
                    }
                });
                break;
            }
            case YOUTUBE: {
                this.createThumbnail(videoImageView, "http://www.youtube.com/watch?v=" + id2, "http://img.youtube.com/vi/" + id2 + "/default.jpg", playButton);
                break;
            }
            case VIMEO: {
                String videoUrl = "http://vimeo.com/api/v2/video/" + id2 + ".json";
                this.api.getVideo(videoUrl, new Callback(){

                    public void onFailure(Call call, IOException e) {
                        Video.this.setFailedImage(videoImageView);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onResponse(Call call, Response response) throws IOException {
                        if (response.isSuccessful()) {
                            JSONObject video = new JSONObject();
                            try {
                                JSONArray jArray = new JSONArray(response.body().string());
                                video = jArray.optJSONObject(0);
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                            catch (IOException e) {
                                Video.this.twig.internal("Couldn't read response body: " + e.getMessage());
                            }
                            finally {
                                response.body().close();
                            }
                            final String thumbnailUrl = video.optString("thumbnail_large");
                            videoImageView.post(new Runnable(){

                                @Override
                                public void run() {
                                    Video.this.createThumbnail(videoImageView, "http://player.vimeo.com/video/" + id2, thumbnailUrl, playButton);
                                }
                            });
                        }
                    }
                });
                break;
            }
        }
    }

    void createThumbnail(final ImageView imageView, final String videoUrl, String thumbnailUrl, final ImageView playButton) {
        final Context context = imageView.getContext();
        this.requestManager.load(thumbnailUrl).placeholder(R.drawable.intercom_video_thumbnail_fallback).error(R.drawable.intercom_video_thumbnail_fallback).listener((RequestListener)new RequestListener<String, GlideDrawable>(){

            public boolean onException(Exception e, String model, Target<GlideDrawable> target, boolean isFirstResource) {
                playButton.setVisibility(8);
                return false;
            }

            public boolean onResourceReady(GlideDrawable resource, String model, Target<GlideDrawable> target, boolean isFromMemoryCache, boolean isFirstResource) {
                int colour = ContextCompat.getColor((Context)context, (int)R.color.intercom_semi_transparent);
                imageView.setColorFilter(colour, PorterDuff.Mode.DARKEN);
                playButton.setVisibility(0);
                return false;
            }
        }).into(imageView);
        if (this.style != StyleType.CHAT_FULL) {
            imageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    Uri uri = Uri.parse((String)videoUrl);
                    Intent intent = new Intent("android.intent.action.VIEW", uri);
                    intent.setFlags(0x10000000);
                    IntentUtils.safelyOpenIntent(context, intent);
                }
            });
        }
    }

    void setFailedImage(final ImageView view) {
        view.post(new Runnable(){

            @Override
            public void run() {
                BackgroundUtils.setBackground((View)view, ContextCompat.getDrawable((Context)view.getContext(), (int)R.drawable.intercom_video_thumbnail_fallback));
            }
        });
    }

    private RelativeLayout getBaseLayout(Context context) {
        RelativeLayout base = new RelativeLayout(context);
        BlockUtils.createLayoutParams((View)base, -2, -2);
        BlockUtils.setDefaultMarginBottom((View)base);
        return base;
    }

    private ImageView getPlayButtonView(Context context) {
        int diameterPx = ScreenUtils.dpToPx((float)48.0f, (Context)context);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(diameterPx, diameterPx);
        params.addRule(13);
        ImageView playButton = new ImageView(context);
        playButton.setLayoutParams((ViewGroup.LayoutParams)params);
        playButton.setScaleType(ImageView.ScaleType.CENTER);
        playButton.setImageResource(R.drawable.intercom_play_arrow);
        playButton.setBackgroundResource(R.drawable.intercom_solid_circle);
        playButton.setVisibility(8);
        return playButton;
    }

    private ImageView getVideoImageView(Context context) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        ImageView videoImage = new ImageView(context);
        videoImage.setLayoutParams((ViewGroup.LayoutParams)params);
        videoImage.setAdjustViewBounds(true);
        videoImage.setScaleType(ImageView.ScaleType.FIT_START);
        return videoImage;
    }
}

