/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.okhttp3.internal.platform;

import android.util.Log;
import io.intercom.okhttp3.Protocol;
import io.intercom.okhttp3.internal.Util;
import io.intercom.okhttp3.internal.platform.OptionalMethod;
import io.intercom.okhttp3.internal.platform.Platform;
import io.intercom.okhttp3.internal.tls.CertificateChainCleaner;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

class AndroidPlatform
extends Platform {
    private static final int MAX_LOG_LENGTH = 4000;
    private final Class<?> sslParametersClass;
    private final OptionalMethod<Socket> setUseSessionTickets;
    private final OptionalMethod<Socket> setHostname;
    private final OptionalMethod<Socket> getAlpnSelectedProtocol;
    private final OptionalMethod<Socket> setAlpnProtocols;
    private final CloseGuard closeGuard = CloseGuard.get();

    AndroidPlatform(Class<?> sslParametersClass, OptionalMethod<Socket> setUseSessionTickets, OptionalMethod<Socket> setHostname, OptionalMethod<Socket> getAlpnSelectedProtocol, OptionalMethod<Socket> setAlpnProtocols) {
        this.sslParametersClass = sslParametersClass;
        this.setUseSessionTickets = setUseSessionTickets;
        this.setHostname = setHostname;
        this.getAlpnSelectedProtocol = getAlpnSelectedProtocol;
        this.setAlpnProtocols = setAlpnProtocols;
    }

    @Override
    public void connectSocket(Socket socket, InetSocketAddress address, int connectTimeout) throws IOException {
        try {
            socket.connect(address, connectTimeout);
        }
        catch (AssertionError e) {
            if (Util.isAndroidGetsocknameError(e)) {
                throw new IOException((Throwable)((Object)e));
            }
            throw e;
        }
        catch (SecurityException e) {
            IOException ioException = new IOException("Exception in connect");
            ioException.initCause(e);
            throw ioException;
        }
    }

    @Override
    public X509TrustManager trustManager(SSLSocketFactory sslSocketFactory) {
        X509TrustManager x509TrustManager;
        Object context = AndroidPlatform.readFieldOrNull(sslSocketFactory, this.sslParametersClass, "sslParameters");
        if (context == null) {
            try {
                Class<?> gmsSslParametersClass = Class.forName("com.google.android.gms.org.conscrypt.SSLParametersImpl", false, sslSocketFactory.getClass().getClassLoader());
                context = AndroidPlatform.readFieldOrNull(sslSocketFactory, gmsSslParametersClass, "sslParameters");
            }
            catch (ClassNotFoundException e) {
                return super.trustManager(sslSocketFactory);
            }
        }
        if ((x509TrustManager = AndroidPlatform.readFieldOrNull(context, X509TrustManager.class, "x509TrustManager")) != null) {
            return x509TrustManager;
        }
        return AndroidPlatform.readFieldOrNull(context, X509TrustManager.class, "trustManager");
    }

    @Override
    public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
        if (hostname != null) {
            this.setUseSessionTickets.invokeOptionalWithoutCheckedException(sslSocket, true);
            this.setHostname.invokeOptionalWithoutCheckedException(sslSocket, hostname);
        }
        if (this.setAlpnProtocols != null && this.setAlpnProtocols.isSupported(sslSocket)) {
            Object[] parameters = new Object[]{AndroidPlatform.concatLengthPrefixed(protocols)};
            this.setAlpnProtocols.invokeWithoutCheckedException(sslSocket, parameters);
        }
    }

    @Override
    public String getSelectedProtocol(SSLSocket socket) {
        if (this.getAlpnSelectedProtocol == null) {
            return null;
        }
        if (!this.getAlpnSelectedProtocol.isSupported(socket)) {
            return null;
        }
        byte[] alpnResult = (byte[])this.getAlpnSelectedProtocol.invokeWithoutCheckedException(socket, new Object[0]);
        return alpnResult != null ? new String(alpnResult, Util.UTF_8) : null;
    }

    @Override
    public void log(int level, String message, Throwable t) {
        int logLevel;
        int n = logLevel = level == 5 ? 5 : 3;
        if (t != null) {
            message = message + '\n' + Log.getStackTraceString((Throwable)t);
        }
        int length = message.length();
        for (int i = 0; i < length; ++i) {
            int end;
            int newline = message.indexOf(10, i);
            newline = newline != -1 ? newline : length;
            do {
                end = Math.min(newline, i + 4000);
                Log.println((int)logLevel, (String)"OkHttp", (String)message.substring(i, end));
            } while ((i = end) < newline);
        }
    }

    @Override
    public Object getStackTraceForCloseable(String closer) {
        return this.closeGuard.createAndOpen(closer);
    }

    @Override
    public void logCloseableLeak(String message, Object stackTrace) {
        boolean reported = this.closeGuard.warnIfOpen(stackTrace);
        if (!reported) {
            this.log(5, message, null);
        }
    }

    @Override
    public boolean isCleartextTrafficPermitted(String hostname) {
        try {
            Class<?> networkPolicyClass = Class.forName("android.security.NetworkSecurityPolicy");
            Method getInstanceMethod = networkPolicyClass.getMethod("getInstance", new Class[0]);
            Object networkSecurityPolicy = getInstanceMethod.invoke(null, new Object[0]);
            Method isCleartextTrafficPermittedMethod = networkPolicyClass.getMethod("isCleartextTrafficPermitted", String.class);
            return (Boolean)isCleartextTrafficPermittedMethod.invoke(networkSecurityPolicy, hostname);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return super.isCleartextTrafficPermitted(hostname);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new AssertionError();
        }
    }

    @Override
    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager trustManager) {
        try {
            Class<?> extensionsClass = Class.forName("android.net.http.X509TrustManagerExtensions");
            Constructor<?> constructor = extensionsClass.getConstructor(X509TrustManager.class);
            Object extensions = constructor.newInstance(trustManager);
            Method checkServerTrusted = extensionsClass.getMethod("checkServerTrusted", X509Certificate[].class, String.class, String.class);
            return new AndroidCertificateChainCleaner(extensions, checkServerTrusted);
        }
        catch (Exception e) {
            return super.buildCertificateChainCleaner(trustManager);
        }
    }

    public static Platform buildIfSupported() {
        try {
            Class<?> sslParametersClass;
            try {
                sslParametersClass = Class.forName("com.android.org.conscrypt.SSLParametersImpl");
            }
            catch (ClassNotFoundException e) {
                sslParametersClass = Class.forName("org.apache.harmony.xnet.provider.jsse.SSLParametersImpl");
            }
            OptionalMethod<Socket> setUseSessionTickets = new OptionalMethod<Socket>(null, "setUseSessionTickets", Boolean.TYPE);
            OptionalMethod<Socket> setHostname = new OptionalMethod<Socket>(null, "setHostname", String.class);
            OptionalMethod getAlpnSelectedProtocol = null;
            OptionalMethod setAlpnProtocols = null;
            try {
                Class.forName("android.net.Network");
                getAlpnSelectedProtocol = new OptionalMethod(byte[].class, "getAlpnSelectedProtocol", new Class[0]);
                setAlpnProtocols = new OptionalMethod(null, "setAlpnProtocols", byte[].class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return new AndroidPlatform(sslParametersClass, setUseSessionTickets, setHostname, getAlpnSelectedProtocol, setAlpnProtocols);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static final class CloseGuard {
        private final Method getMethod;
        private final Method openMethod;
        private final Method warnIfOpenMethod;

        CloseGuard(Method getMethod, Method openMethod, Method warnIfOpenMethod) {
            this.getMethod = getMethod;
            this.openMethod = openMethod;
            this.warnIfOpenMethod = warnIfOpenMethod;
        }

        Object createAndOpen(String closer) {
            if (this.getMethod != null) {
                try {
                    Object closeGuardInstance = this.getMethod.invoke(null, new Object[0]);
                    this.openMethod.invoke(closeGuardInstance, closer);
                    return closeGuardInstance;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        boolean warnIfOpen(Object closeGuardInstance) {
            boolean reported = false;
            if (closeGuardInstance != null) {
                try {
                    this.warnIfOpenMethod.invoke(closeGuardInstance, new Object[0]);
                    reported = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return reported;
        }

        static CloseGuard get() {
            Method warnIfOpenMethod;
            Method openMethod;
            Method getMethod;
            try {
                Class<?> closeGuardClass = Class.forName("dalvik.system.CloseGuard");
                getMethod = closeGuardClass.getMethod("get", new Class[0]);
                openMethod = closeGuardClass.getMethod("open", String.class);
                warnIfOpenMethod = closeGuardClass.getMethod("warnIfOpen", new Class[0]);
            }
            catch (Exception ignored) {
                getMethod = null;
                openMethod = null;
                warnIfOpenMethod = null;
            }
            return new CloseGuard(getMethod, openMethod, warnIfOpenMethod);
        }
    }

    static final class AndroidCertificateChainCleaner
    extends CertificateChainCleaner {
        private final Object x509TrustManagerExtensions;
        private final Method checkServerTrusted;

        AndroidCertificateChainCleaner(Object x509TrustManagerExtensions, Method checkServerTrusted) {
            this.x509TrustManagerExtensions = x509TrustManagerExtensions;
            this.checkServerTrusted = checkServerTrusted;
        }

        @Override
        public List<Certificate> clean(List<Certificate> chain, String hostname) throws SSLPeerUnverifiedException {
            try {
                X509Certificate[] certificates = chain.toArray(new X509Certificate[chain.size()]);
                return (List)this.checkServerTrusted.invoke(this.x509TrustManagerExtensions, certificates, "RSA", hostname);
            }
            catch (InvocationTargetException e) {
                SSLPeerUnverifiedException exception = new SSLPeerUnverifiedException(e.getMessage());
                exception.initCause(e);
                throw exception;
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        public boolean equals(Object other) {
            return other instanceof AndroidCertificateChainCleaner;
        }

        public int hashCode() {
            return 0;
        }
    }
}

