/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation.composer.galleryinput;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityManagerCompat;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import com.intercom.composer.ImageLoader;
import com.intercom.input.gallery.GalleryImage;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.ActivityUtils;
import io.intercom.android.sdk.utilities.ImageUtils;
import io.intercom.com.bumptech.glide.DrawableTypeRequest;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.load.engine.DiskCacheStrategy;
import io.intercom.com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import io.intercom.com.bumptech.glide.load.resource.bitmap.GlideBitmapDrawable;
import io.intercom.com.bumptech.glide.load.resource.drawable.GlideDrawable;
import io.intercom.com.bumptech.glide.request.RequestListener;
import io.intercom.com.bumptech.glide.request.target.Target;

class GalleryImageLoader
implements ImageLoader {
    private static final float GIF_SIZE_MULTIPLIER = 0.5f;
    private final DiskCacheStrategy diskCacheStrategy;
    private final int gifDisplayMode;
    @Nullable
    private final BitmapTransformation transformation;

    static GalleryImageLoader create(DiskCacheStrategy diskCacheStrategy, @Nullable BitmapTransformation transformation, Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        int gifDisplayMode = GalleryImageLoader.canSafelyAnimateGifs(activityManager) ? 0 : 1;
        return new GalleryImageLoader(diskCacheStrategy, gifDisplayMode, transformation);
    }

    GalleryImageLoader(DiskCacheStrategy diskCacheStrategy, int gifDisplayMode, @Nullable BitmapTransformation transformation) {
        this.diskCacheStrategy = diskCacheStrategy;
        this.gifDisplayMode = gifDisplayMode;
        this.transformation = transformation;
    }

    public void loadImageIntoView(GalleryImage image, ImageView view) {
        String imagePath = TextUtils.isEmpty((CharSequence)image.getPreviewPath()) ? image.getPath() : image.getPreviewPath();
        Context context = view.getContext();
        if (ActivityUtils.isNotActive(context)) {
            return;
        }
        DrawableTypeRequest request = Glide.with((Context)context).load(imagePath);
        if (this.gifDisplayMode == 0) {
            request.asBitmap();
        } else if (ImageUtils.isGif(imagePath)) {
            request.sizeMultiplier(0.5f);
        }
        if (this.transformation != null) {
            request.transform(new BitmapTransformation[]{this.transformation});
        }
        request.diskCacheStrategy(this.diskCacheStrategy).listener((RequestListener)new RequestListener<String, GlideDrawable>(){

            public boolean onException(Exception e, String url, Target<GlideDrawable> target, boolean b) {
                Twig twig = LumberMill.getLogger();
                String messageStart = "Failed to load image for URL: " + url + " - ";
                if (e == null) {
                    twig.e(messageStart + "no error message, data probably failed to decode", new Object[0]);
                } else {
                    twig.e(messageStart + e.getMessage(), new Object[0]);
                }
                return false;
            }

            public boolean onResourceReady(GlideDrawable glideDrawable, String s, Target<GlideDrawable> target, boolean b, boolean b1) {
                return false;
            }
        }).placeholder((Drawable)new ColorDrawable(ContextCompat.getColor((Context)context, (int)R.color.intercom_search_bg_grey))).into(view);
    }

    public void clear(ImageView imageView) {
        Glide.clear((View)imageView);
    }

    @Nullable
    public Bitmap getBitmapFromView(ImageView imageView) {
        Drawable drawable2 = imageView.getDrawable();
        if (drawable2 instanceof TransitionDrawable) {
            TransitionDrawable transitionDrawable = (TransitionDrawable)drawable2;
            for (int i = transitionDrawable.getNumberOfLayers() - 1; i >= 0; --i) {
                Bitmap realBitmap = this.getBitmapFromDrawable(transitionDrawable.getDrawable(i));
                if (realBitmap == null) continue;
                return realBitmap;
            }
            return null;
        }
        return this.getBitmapFromDrawable(drawable2);
    }

    @Nullable
    private Bitmap getBitmapFromDrawable(Drawable drawable2) {
        if (drawable2 instanceof GlideBitmapDrawable) {
            return ((GlideBitmapDrawable)drawable2).getBitmap();
        }
        return null;
    }

    private static boolean canSafelyAnimateGifs(ActivityManager activityManager) {
        return Build.VERSION.SDK_INT < 19 || ActivityManagerCompat.isLowRamDevice((ActivityManager)activityManager);
    }
}

