/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.DeviceUtils;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.push.IntercomPushBroadcastReceiver;
import io.intercom.android.sdk.push.PushAvatarUtils;
import io.intercom.android.sdk.push.PushPayload;
import io.intercom.android.sdk.transforms.RoundTransform;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.load.Transformation;
import java.util.List;

class SystemNotificationFactory {
    private static final int LARGE_ICON_SIZE_DP = 48;
    private static final String CONVERSATION_URI = "conversation_id=%s";
    private static final String INTERCOM_SDK_GCM = "intercom_sdk_gcm";
    private static final Twig twig = LumberMill.getLogger();

    SystemNotificationFactory() {
    }

    Notification createSingleNotification(PushPayload payload, Context context, AppConfig appConfig) {
        Uri destination = Uri.parse((String)String.format("intercom_sdk/conversation_id=%s", payload.getConversationId()));
        return SystemNotificationFactory.createBuilder(context, destination, null, -1).setContentTitle(payload.getTitle(context)).setContentText((CharSequence)payload.getMessage()).setPriority(payload.getPriority()).setLargeIcon(this.generateAvatar(payload, context, appConfig)).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)payload.getMessage())).build();
    }

    Notification createGroupedNotification(List<PushPayload> payloads, Context context) {
        Uri destination = Uri.parse((String)"intercom_sdk/multiple_notifications");
        CharSequence subtitle = payloads.size() == 1 ? context.getString(R.string.intercom_one_new_message) : Phrase.from(context, R.string.intercom_new_messages).put("n", payloads.size()).format();
        NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
        inboxStyle.setBigContentTitle((CharSequence)context.getString(R.string.intercom_new_notifications));
        for (PushPayload payload : payloads) {
            SpannableString spannable = new SpannableString((CharSequence)(payload.getName() + ": " + payload.getMessage()));
            spannable.setSpan((Object)new StyleSpan(1), 0, payload.getName().length(), 33);
            inboxStyle.addLine((CharSequence)spannable);
        }
        return SystemNotificationFactory.createBuilder(context, destination, null, -1).setContentTitle((CharSequence)context.getString(R.string.intercom_new_notifications)).setContentText(subtitle).setPriority(payloads.get(payloads.size() - 1).getPriority()).setStyle((NotificationCompat.Style)inboxStyle).build();
    }

    Notification createPushOnlyNotification(PushPayload payload, Context context) {
        String conversationId = payload.getPushOnlyConversationId();
        return SystemNotificationFactory.createBuilder(context, Uri.parse((String)payload.getUri()), conversationId, conversationId.hashCode()).setContentTitle(payload.getTitle(context)).setContentText((CharSequence)payload.getMessage()).setPriority(payload.getPriority()).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)payload.getMessage())).build();
    }

    private static NotificationCompat.Builder createBuilder(Context context, Uri destination, @Nullable String pushOnlyConversationId, int requestCode) {
        ComponentName receiverComponent = new ComponentName(context, IntercomPushBroadcastReceiver.class);
        Intent openIntent = new Intent("io.intercom.android.sdk.INTERCOM_PUSH_OPENED").setComponent(receiverComponent);
        Intent dismissIntent = new Intent("io.intercom.android.sdk.INTERCOM_PUSH_DISMISSED").setComponent(receiverComponent);
        String packageName = context.getPackageName();
        Intent hostAppIntent = context.getPackageManager().getLaunchIntentForPackage(packageName);
        if (hostAppIntent == null) {
            hostAppIntent = new Intent();
            twig.e("Couldn't get launch Intent for package '" + packageName + "' - tapping on notification will do nothing", new Object[0]);
        } else {
            hostAppIntent.addCategory("android.intent.category.LAUNCHER");
            hostAppIntent.setData(destination);
            hostAppIntent.putExtra("intercom_push_key", INTERCOM_SDK_GCM);
            if (pushOnlyConversationId != null) {
                hostAppIntent.putExtra("push_only_convo_id", pushOnlyConversationId);
            }
        }
        openIntent.putExtra("host_app_intent", (Parcelable)hostAppIntent);
        dismissIntent.putExtra("host_app_intent", (Parcelable)hostAppIntent);
        PendingIntent pendingOpenIntent = PendingIntent.getBroadcast((Context)context, (int)requestCode, (Intent)openIntent, (int)0x8000000);
        PendingIntent pendingDismissIntent = PendingIntent.getBroadcast((Context)context, (int)requestCode, (Intent)dismissIntent, (int)0x8000000);
        int vibrateFlag = DeviceUtils.hasPermission((Context)context, (String)"android.permission.VIBRATE") ? 2 : 0;
        return new NotificationCompat.Builder(context).setSmallIcon(R.drawable.intercom_push_icon).setCategory("msg").setAutoCancel(true).setColor(Injector.get().getAppConfigProvider().get().getBaseColor()).setLights(Injector.get().getAppConfigProvider().get().getBaseColor(), 500, 2000).setContentIntent(pendingOpenIntent).setDeleteIntent(pendingDismissIntent).setDefaults(1 | vibrateFlag);
    }

    private Bitmap generateAvatar(PushPayload payload, Context context, AppConfig appConfig) {
        if (TextUtils.isEmpty((CharSequence)payload.getImageUrl()) && !TextUtils.isEmpty((CharSequence)payload.getName())) {
            return PushAvatarUtils.getNotificationInitialsBitmap(context, payload.getName(), appConfig);
        }
        BitmapDrawable defaultDrawable = new BitmapDrawable(context.getResources(), PushAvatarUtils.getNotificationDefaultBitmap(context, appConfig));
        try {
            int iconSize = ScreenUtils.dpToPx((float)48.0f, (Context)context);
            return (Bitmap)Glide.with((Context)context.getApplicationContext()).load(payload.getImageUrl()).asBitmap().error((Drawable)defaultDrawable).transform(new Transformation[]{new RoundTransform(context)}).into(iconSize, iconSize).get();
        }
        catch (Exception e) {
            twig.d("Failed to retrieve the notification image", new Object[0]);
            return defaultDrawable.getBitmap();
        }
    }
}

