/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.nexus;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import io.intercom.android.sdk.nexus.NexusEventType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

public class NexusEvent {
    static final String TOPIC_PREFIX_CONVERSATION = "conversation/";
    static final String EVENT_GUID = "eventGuid";
    static final String EVENT_DATA = "eventData";
    static final String EVENT_NAME = "eventName";
    static final String ADMIN_ID = "adminId";
    static final String ADMIN_NAME = "adminName";
    static final String ADMIN_AVATAR = "adminAvatar";
    static final String ADMIN_TIMESTAMP = "adminTimestamp";
    static final String NX_TO_USER = "nx.ToUser";
    static final String NX_FROM_USER = "nx.FromUser";
    static final String CONVERSATION_ID = "conversationId";
    static final String ASSIGNEE_ID = "assigneeId";
    static final String NX_TOPICS = "nx.Topics";
    @NonNull
    private final NexusEventType eventType;
    @NonNull
    private final List<String> topics;
    @Nullable
    private final String guid;
    @Nullable
    private final String adminId;
    @Nullable
    private final String adminName;
    @Nullable
    private final String userId;
    @Nullable
    private final String conversationId;
    @Nullable
    private final String assigneeId;
    @Nullable
    private final String adminAvatarUrl;
    private final long adminTimestamp;

    public NexusEvent(Builder builder) {
        this.guid = UUID.randomUUID().toString();
        this.topics = new ArrayList<String>();
        if (builder.topics != null) {
            for (String topic : builder.topics) {
                if (TextUtils.isEmpty((CharSequence)topic)) continue;
                this.topics.add(topic);
            }
        }
        this.eventType = builder.eventName;
        this.conversationId = builder.conversationId;
        this.assigneeId = builder.assigneeId;
        this.adminName = builder.adminName;
        this.adminId = builder.adminId;
        this.adminAvatarUrl = builder.adminAvatarUrl;
        this.adminTimestamp = builder.adminTimestamp;
        this.userId = builder.userId;
    }

    public NexusEvent(JSONObject jsonObject) {
        JSONObject eventData;
        this.eventType = NexusEventType.safeValueOf(jsonObject.optString(EVENT_NAME));
        this.guid = jsonObject.optString(EVENT_GUID);
        this.topics = new ArrayList<String>();
        JSONArray topicsArray = jsonObject.optJSONArray(NX_TOPICS);
        if (topicsArray != null) {
            for (int i = 0; i < topicsArray.length(); ++i) {
                String topic = topicsArray.optString(i);
                if (TextUtils.isEmpty((CharSequence)topic)) continue;
                this.topics.add(topic);
            }
        }
        this.conversationId = (eventData = jsonObject.optJSONObject(EVENT_DATA)) != null ? eventData.optString(CONVERSATION_ID, "") : jsonObject.optString(EVENT_DATA);
        if (eventData != null) {
            this.adminId = eventData.optString(ADMIN_ID);
            this.adminName = eventData.optString(ADMIN_NAME);
            this.adminAvatarUrl = eventData.optString(ADMIN_AVATAR);
            this.adminTimestamp = eventData.optLong(ADMIN_TIMESTAMP, -1L);
            this.assigneeId = eventData.optString(ASSIGNEE_ID);
        } else {
            this.adminId = null;
            this.adminName = null;
            this.adminAvatarUrl = null;
            this.adminTimestamp = -1L;
            this.assigneeId = null;
        }
        this.userId = jsonObject.has(NX_TO_USER) ? jsonObject.optString(NX_TO_USER) : jsonObject.optString(NX_FROM_USER);
    }

    public String toStringEncodedJsonObject() {
        return this.eventType.toStringEncodedJsonObject(this);
    }

    @NonNull
    public NexusEventType getEventType() {
        return this.eventType;
    }

    @NonNull
    public List<String> getTopics() {
        return this.topics;
    }

    @NonNull
    public String getGuid() {
        return this.guid != null ? this.guid : "";
    }

    @NonNull
    public String getUserId() {
        return this.userId != null ? this.userId : "";
    }

    @NonNull
    public String getConversationId() {
        return this.conversationId != null ? this.conversationId : "";
    }

    @NonNull
    public String getAssigneeId() {
        return this.assigneeId != null ? this.assigneeId : "";
    }

    @NonNull
    public String getAdminId() {
        return this.adminId != null ? this.adminId : "";
    }

    @NonNull
    public String getAdminName() {
        return this.adminName != null ? this.adminName : "";
    }

    @NonNull
    public String getAdminAvatarUrl() {
        return this.adminAvatarUrl != null ? this.adminAvatarUrl : "";
    }

    public long getAdminTimestamp() {
        return this.adminTimestamp;
    }

    public static NexusEvent getAdminIsTypingEvent(String conversationId, String adminId, String adminName, String adminAvatarUrl, String userId) {
        return new Builder(NexusEventType.AdminIsTyping).withAdminId(adminId).withConversationId(conversationId).withAdminName(adminName).withAdminAvatarUrl(adminAvatarUrl).withUserId(userId).withTopics(NexusEvent.conversationTopics(conversationId)).build();
    }

    public static NexusEvent getAdminIsTypingNoteEvent(String conversationId, String adminId, String adminName, String adminAvatarUrl, String userId) {
        return new Builder(NexusEventType.AdminIsTypingANote).withAdminId(adminId).withConversationId(conversationId).withTopics(NexusEvent.conversationTopics(conversationId)).withAdminName(adminName).withAdminAvatarUrl(adminAvatarUrl).withUserId(userId).build();
    }

    public static NexusEvent getUserIsTypingEvent(String conversationId, String userId) {
        return new Builder(NexusEventType.UserIsTyping).withConversationId(conversationId).withTopics(NexusEvent.conversationTopics(conversationId)).withUserId(userId).build();
    }

    public static NexusEvent getConversationSeenEvent(String conversationId, String userId) {
        return new Builder(NexusEventType.ConversationSeen).withConversationId(conversationId).withTopics(NexusEvent.conversationTopics(conversationId)).withUserId(userId).build();
    }

    public static NexusEvent getConversationSeenAdminEvent(String conversationId, String userId) {
        return new Builder(NexusEventType.UserContentSeenByAdmin).withConversationId(conversationId).withTopics(NexusEvent.conversationTopics(conversationId)).withUserId(userId).build();
    }

    public static NexusEvent getNewCommentEvent(String conversationId, String userId) {
        return new Builder(NexusEventType.NewComment).withConversationId(conversationId).withTopics(NexusEvent.conversationTopics(conversationId)).withUserId(userId).build();
    }

    public static NexusEvent getNewNoteEvent(String conversationId, String adminId) {
        return new Builder(NexusEventType.NewNote).withAdminId(adminId).withConversationId(conversationId).build();
    }

    public static NexusEvent getCreateConversationEvent(String conversationId, String userId) {
        return new Builder(NexusEventType.CreateConversation).withConversationId(conversationId).withUserId(userId).build();
    }

    public static NexusEvent getConversationAssignedEvent(String conversationId, String adminId, String assigneeId) {
        return new Builder(NexusEventType.ConversationAssigned).withAdminId(adminId).withConversationId(conversationId).withAssigneeId(assigneeId).build();
    }

    public static NexusEvent getConversationClosedEvent(String conversationId, String adminId) {
        return new Builder(NexusEventType.ConversationClosed).withAdminId(adminId).withConversationId(conversationId).build();
    }

    public static NexusEvent getConversationReopenedEvent(String conversationId, String adminId) {
        return new Builder(NexusEventType.ConversationReopened).withAdminId(adminId).withConversationId(conversationId).build();
    }

    public static NexusEvent getUserPresenceEvent() {
        return new Builder(NexusEventType.UserPresence).build();
    }

    public static NexusEvent getSubscribeEvent(List<String> topics) {
        return new Builder(NexusEventType.Subscribe).withTopics(topics).build();
    }

    public static NexusEvent getUnsubscribeEvent(List<String> topics) {
        return new Builder(NexusEventType.Unsubscribe).withTopics(topics).build();
    }

    private static List<String> conversationTopics(String conversationId) {
        return Collections.singletonList(TOPIC_PREFIX_CONVERSATION + conversationId);
    }

    static class Builder {
        @NonNull
        NexusEventType eventName;
        @Nullable
        List<String> topics;
        @Nullable
        String adminId;
        @Nullable
        String adminName;
        @Nullable
        String userId;
        @Nullable
        String conversationId;
        @Nullable
        String assigneeId;
        @Nullable
        String adminAvatarUrl;
        long adminTimestamp = -1L;

        Builder(@NonNull NexusEventType name) {
            this.eventName = name;
        }

        public Builder withTopics(List<String> topics) {
            this.topics = topics;
            return this;
        }

        public Builder withAdminId(String adminId) {
            this.adminId = adminId;
            return this;
        }

        public Builder withAdminName(String adminName) {
            this.adminName = adminName;
            return this;
        }

        public Builder withAdminAvatarUrl(String adminAvatarUrl) {
            this.adminAvatarUrl = adminAvatarUrl;
            return this;
        }

        public Builder withAdminTimeStamp(long adminTimeStamp) {
            this.adminTimestamp = adminTimeStamp;
            return this;
        }

        public Builder withUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder withConversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public Builder withAssigneeId(String assigneeId) {
            this.assigneeId = assigneeId;
            return this;
        }

        public NexusEvent build() {
            return new NexusEvent(this);
        }
    }
}

