/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.identity;

import android.content.Context;
import android.content.SharedPreferences;

public class AppIdentity {
    private static final String PREFS_API_KEY = "ApiKey";
    private static final String PREFS_APP_ID = "AppId";
    private final String apiKey;
    private final String appId;

    public static AppIdentity loadFromDevice(Context context) {
        SharedPreferences prefs = context.getSharedPreferences("INTERCOM_SDK_PREFS", 0);
        String apiKey = prefs.getString(PREFS_API_KEY, "");
        String appId = prefs.getString(PREFS_APP_ID, "");
        return new AppIdentity(apiKey, appId);
    }

    public AppIdentity(String apiKey, String appId) {
        this.apiKey = apiKey;
        this.appId = appId;
    }

    public void persist(Context context) {
        context.getSharedPreferences("INTERCOM_SDK_PREFS", 0).edit().putString(PREFS_API_KEY, this.apiKey).putString(PREFS_APP_ID, this.appId).apply();
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getAppId() {
        return this.appId;
    }
}

