/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.content.Context;
import android.content.res.Resources;
import android.media.SoundPool;
import android.support.annotation.RawRes;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;

public class SoundPlayer {
    private static final Twig TWIG = LumberMill.getLogger();
    @VisibleForTesting
    static final int NOT_FOUND_ID = -1;
    private final SoundPool soundPool;
    private final AppConfig.Provider appConfigProvider;
    final int messageReceivedId;
    final int replyFailedId;
    final int replySentId;
    final int replyDeliveredId;
    boolean messageReceivedLoaded;
    boolean replyFailedLoaded;
    boolean replyDeliveredLoaded;
    boolean replySentLoaded;

    public SoundPlayer(Context context, AppConfig.Provider appConfigProvider) {
        this(context, appConfigProvider, new SoundPool(1, 5, 0));
    }

    @VisibleForTesting
    SoundPlayer(Context context, AppConfig.Provider appConfigProvider, SoundPool soundPool) {
        this.appConfigProvider = appConfigProvider;
        this.soundPool = soundPool;
        this.soundPool.setOnLoadCompleteListener(new SoundPool.OnLoadCompleteListener(){

            public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
                if (status == 0) {
                    if (sampleId == SoundPlayer.this.messageReceivedId) {
                        SoundPlayer.this.messageReceivedLoaded = true;
                    } else if (sampleId == SoundPlayer.this.replyFailedId) {
                        SoundPlayer.this.replyFailedLoaded = true;
                    } else if (sampleId == SoundPlayer.this.replySentId) {
                        SoundPlayer.this.replySentLoaded = true;
                    } else if (sampleId == SoundPlayer.this.replyDeliveredId) {
                        SoundPlayer.this.replyDeliveredLoaded = true;
                    }
                }
            }
        });
        this.messageReceivedId = this.loadSound(context, R.raw.intercom_birdy_done_1);
        this.replyFailedId = this.loadSound(context, R.raw.intercom_wood_done_1);
        this.replySentId = this.loadSound(context, R.raw.intercom_wood_done_2);
        this.replyDeliveredId = this.loadSound(context, R.raw.intercom_wood_done_3);
    }

    private int loadSound(Context context, @RawRes int soundId) {
        try {
            return this.soundPool.load(context, soundId, 1);
        }
        catch (Resources.NotFoundException e) {
            TWIG.e((Throwable)e, "Could not play sound", new Object[0]);
            return -1;
        }
    }

    public void playReplyFailedSound() {
        this.playIfLoaded(this.replyFailedLoaded, this.replyFailedId);
    }

    public void playReplySentSound() {
        this.playIfLoaded(this.replySentLoaded, this.replySentId);
    }

    public void playReplyDeliveredSound() {
        this.playIfLoaded(this.replyDeliveredLoaded, this.replyDeliveredId);
    }

    public void playMessageReceivedSound() {
        this.playIfLoaded(this.messageReceivedLoaded, this.messageReceivedId);
    }

    @VisibleForTesting
    void playIfLoaded(boolean loaded, int soundId) {
        if (loaded && soundId != -1 && this.appConfigProvider.getAppConfig().isAudioEnabled()) {
            this.soundPool.play(soundId, 1.0f, 1.0f, 1, 0, 1.0f);
        }
    }
}

