/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.input.gallery.adapter;

import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.intercom.composer.ImageLoader;
import com.intercom.input.gallery.GalleryImage;
import com.intercom.input.gallery.adapter.ImageViewHolder;
import com.intercom.input.gallery.adapter.OnImageClickListener;
import io.intercom.android.sdk.R;
import java.util.List;

public class GalleryRecyclerViewAdapter
extends RecyclerView.Adapter<ImageViewHolder> {
    private final LayoutInflater layoutInflater;
    private final boolean expanded;
    private final List<GalleryImage> galleryImages;
    private final OnImageClickListener onImageClickListener;
    private final ImageLoader imageLoader;

    public GalleryRecyclerViewAdapter(LayoutInflater layoutInflater, List<GalleryImage> galleryImages, boolean expanded, OnImageClickListener onImageClickListener, ImageLoader imageLoader) {
        this.layoutInflater = layoutInflater;
        this.galleryImages = galleryImages;
        this.expanded = expanded;
        this.onImageClickListener = onImageClickListener;
        this.imageLoader = imageLoader;
    }

    public ImageViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        int resId = this.expanded ? R.layout.intercom_composer_expanded_image_list_item : R.layout.intercom_composer_image_list_item;
        View itemView = this.layoutInflater.inflate(resId, parent, false);
        return new ImageViewHolder(itemView, this.onImageClickListener);
    }

    public void onBindViewHolder(ImageViewHolder imageViewHolder, int position) {
        this.imageLoader.loadImageIntoView(this.galleryImages.get(position), imageViewHolder.getImageView());
    }

    public int getItemCount() {
        return this.galleryImages.size();
    }

    public void onViewRecycled(ImageViewHolder holder) {
        super.onViewRecycled((RecyclerView.ViewHolder)holder);
        this.imageLoader.clear(holder.getImageView());
    }

    public GalleryImage getItem(int position) {
        return this.galleryImages.get(position);
    }
}

