/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.input.gallery;

import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.os.Build;
import android.provider.MediaStore;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.FragmentActivity;
import com.intercom.input.gallery.GalleryImage;
import com.intercom.input.gallery.GalleryInputDataSource;
import com.intercom.input.gallery.GalleryInputFragment;
import com.intercom.input.gallery.GalleryInputScreen;
import com.intercom.input.gallery.PermissionHelper;
import java.util.ArrayList;
import java.util.List;

public class LocalImagesDataSource
implements GalleryInputDataSource {
    private static final int READ_EXTERNAL_STORAGE_REQUEST = 1;
    private static final int ITEM_COUNT_LIMIT = 50;
    private GalleryInputDataSource.Listener listener;
    private PermissionHelper permissionHelper;
    private Context context;
    private GalleryInputScreen galleryInputScreen;
    private boolean loading;

    public static GalleryInputDataSource create(GalleryInputFragment fragment) {
        FragmentActivity activity = fragment.getActivity();
        PermissionHelper permissionHelper = PermissionHelper.create((Activity)activity);
        return new LocalImagesDataSource((Context)activity, permissionHelper, fragment);
    }

    LocalImagesDataSource(Context context, PermissionHelper permissionHelper, GalleryInputScreen galleryInputScreen) {
        this.context = context;
        this.galleryInputScreen = galleryInputScreen;
        this.permissionHelper = permissionHelper;
    }

    @Override
    public int getPermissionStatus() {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.permissionHelper.getPermissionStatus("android.permission.READ_EXTERNAL_STORAGE");
        }
        return 0;
    }

    @Override
    public void requestPermission() {
        this.permissionHelper.setAskedForPermissionPref(true);
        if (Build.VERSION.SDK_INT >= 23) {
            this.galleryInputScreen.requestPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 1);
        }
    }

    @Override
    public void setListener(GalleryInputDataSource.Listener listener) {
        this.listener = listener;
    }

    @Override
    public int getCount() {
        if (this.getPermissionStatus() != 0) {
            return 0;
        }
        Cursor cursor = this.context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, null, null, null, null);
        int count = 0;
        if (cursor != null) {
            count = cursor.getCount();
            cursor.close();
        }
        return count;
    }

    @Override
    public void getImages(int offset, @Nullable String query) {
        String[] stringArray;
        this.loading = true;
        if (Build.VERSION.SDK_INT >= 16) {
            String[] stringArray2 = new String[6];
            stringArray2[0] = "_data";
            stringArray2[1] = "date_added";
            stringArray2[2] = "mime_type";
            stringArray2[3] = "title";
            stringArray2[4] = "height";
            stringArray = stringArray2;
            stringArray2[5] = "width";
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "_data";
            stringArray3[1] = "date_added";
            stringArray3[2] = "mime_type";
            stringArray = stringArray3;
            stringArray3[3] = "title";
        }
        String[] projection = stringArray;
        Cursor cursor = this.context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, projection, null, null, "date_added DESC LIMIT 50 OFFSET " + offset);
        this.loading = false;
        if (cursor == null) {
            this.listener.onError();
        } else {
            this.listener.onSuccess(this.galleryImagesFromCursor(cursor));
        }
    }

    @VisibleForTesting
    List<GalleryImage> galleryImagesFromCursor(Cursor cursor) {
        ArrayList<GalleryImage> galleryImages = new ArrayList<GalleryImage>(cursor.getCount());
        if (cursor.moveToFirst()) {
            do {
                String filePath = cursor.getString(cursor.getColumnIndexOrThrow("_data"));
                String mimeType = cursor.getString(cursor.getColumnIndexOrThrow("mime_type"));
                String fileName = cursor.getString(cursor.getColumnIndexOrThrow("title"));
                if (filePath == null || fileName == null || mimeType == null) continue;
                Point dimensions = this.getImageHeightAndWidth(cursor, filePath);
                GalleryImage galleryImage = new GalleryImage.Builder().withFileName(fileName).withPath(filePath).withMimeType(mimeType).withImageWidth(dimensions.x).withImageHeight(dimensions.y).build();
                galleryImages.add(galleryImage);
            } while (cursor.moveToNext());
        }
        cursor.close();
        return galleryImages;
    }

    private Point getImageHeightAndWidth(Cursor cursor, String filePath) {
        int imageWidth;
        int imageHeight;
        if (Build.VERSION.SDK_INT >= 16) {
            imageHeight = cursor.getInt(cursor.getColumnIndexOrThrow("height"));
            imageWidth = cursor.getInt(cursor.getColumnIndexOrThrow("width"));
        } else {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
            imageWidth = options.outWidth;
            imageHeight = options.outHeight;
        }
        return new Point(imageWidth, imageHeight);
    }

    @Override
    public boolean isLoading() {
        return this.loading;
    }
}

