/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.input.gallery;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.AppCompatActivity;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import com.intercom.composer.WindowUtil;
import com.intercom.input.gallery.ClassUtils;
import com.intercom.input.gallery.GalleryImage;
import com.intercom.input.gallery.GalleryInputFragment;
import com.intercom.input.gallery.GalleryOutputListener;
import io.intercom.android.sdk.R;

public class GalleryInputFullScreenActivity
extends AppCompatActivity
implements GalleryOutputListener {
    public static final String GALLERY_IMAGE = "gallery_image";
    private static final String KEY_FRAGMENT_CLASS = "fragment_class";
    private static final String KEY_FRAGMENT_ARGS = "fragment_args";
    private Class<? extends GalleryInputFragment> fragmentClass;
    private Bundle fragmentArgs;

    public static Intent createIntent(Context context, Class<? extends GalleryInputFragment> fragmentClass, Bundle fragmentArgs) {
        return new Intent(context, GalleryInputFullScreenActivity.class).putExtra(KEY_FRAGMENT_CLASS, fragmentClass).putExtra(KEY_FRAGMENT_ARGS, fragmentArgs);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercom_composer_activity_input_full_screen);
        WindowUtil.setFullscreenWindow(this.getWindow(), R.color.intercom_composer_status_bar);
        Intent intent = this.getIntent();
        this.fragmentClass = ClassUtils.cast(intent.getSerializableExtra(KEY_FRAGMENT_CLASS));
        this.fragmentArgs = intent.getBundleExtra(KEY_FRAGMENT_ARGS);
    }

    protected void onPostCreate(@Nullable Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        String fragmentTag = GalleryInputFragment.class.getName();
        Fragment fragment = fragmentManager.findFragmentByTag(fragmentTag);
        if (fragment == null) {
            GalleryInputFragment galleryFragment = ClassUtils.instantiate(this.fragmentClass);
            Bundle args = this.fragmentArgs == null ? new Bundle() : new Bundle(this.fragmentArgs);
            args.putAll(GalleryInputFragment.createArguments(true));
            galleryFragment.setArguments(args);
            galleryFragment.setGalleryListener(this);
            fragmentManager.beginTransaction().replace(R.id.expanded_fragment, (Fragment)galleryFragment, fragmentTag).commit();
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        super.onBackPressed();
        View view = this.getCurrentFocus();
        if (view != null) {
            InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
        this.overridePendingTransition(R.anim.intercom_composer_stay, R.anim.intercom_composer_slide_down);
    }

    @Override
    public void onGalleryOutputReceived(GalleryImage galleryImage) {
        Intent intent = new Intent();
        intent.putExtra(GALLERY_IMAGE, (Parcelable)galleryImage);
        this.setResult(-1, intent);
        this.onBackPressed();
    }
}

