/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.facebook.rebound;

public class BouncyConversion {
    private final double mBouncyTension;
    private final double mBouncyFriction;
    private final double mSpeed;
    private final double mBounciness;

    public BouncyConversion(double speed, double bounciness) {
        this.mSpeed = speed;
        this.mBounciness = bounciness;
        double b = this.normalize(bounciness / 1.7, 0.0, 20.0);
        b = this.project_normal(b, 0.0, 0.8);
        double s = this.normalize(speed / 1.7, 0.0, 20.0);
        this.mBouncyTension = this.project_normal(s, 0.5, 200.0);
        this.mBouncyFriction = this.quadratic_out_interpolation(b, this.b3_nobounce(this.mBouncyTension), 0.01);
    }

    public double getSpeed() {
        return this.mSpeed;
    }

    public double getBounciness() {
        return this.mBounciness;
    }

    public double getBouncyTension() {
        return this.mBouncyTension;
    }

    public double getBouncyFriction() {
        return this.mBouncyFriction;
    }

    private double normalize(double value, double startValue, double endValue) {
        return (value - startValue) / (endValue - startValue);
    }

    private double project_normal(double n, double start, double end) {
        return start + n * (end - start);
    }

    private double linear_interpolation(double t, double start, double end) {
        return t * end + (1.0 - t) * start;
    }

    private double quadratic_out_interpolation(double t, double start, double end) {
        return this.linear_interpolation(2.0 * t - t * t, start, end);
    }

    private double b3_friction1(double x) {
        return 7.0E-4 * Math.pow(x, 3.0) - 0.031 * Math.pow(x, 2.0) + 0.64 * x + 1.28;
    }

    private double b3_friction2(double x) {
        return 4.4E-5 * Math.pow(x, 3.0) - 0.006 * Math.pow(x, 2.0) + 0.36 * x + 2.0;
    }

    private double b3_friction3(double x) {
        return 4.5E-7 * Math.pow(x, 3.0) - 3.32E-4 * Math.pow(x, 2.0) + 0.1078 * x + 5.84;
    }

    private double b3_nobounce(double tension) {
        double friction = 0.0;
        if (tension <= 18.0) {
            friction = this.b3_friction1(tension);
        } else if (tension > 18.0 && tension <= 44.0) {
            friction = this.b3_friction2(tension);
        } else if (tension > 44.0) {
            friction = this.b3_friction3(tension);
        } else assert (false);
        return friction;
    }
}

