/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.metrics;

import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.MetricObject;
import io.intercom.android.sdk.utilities.TimeProvider;

public class NewMetricFactory {
    static final String ACTION_RECEIVED = "received";
    static final String OBJECT_BADGE = "badge";
    static final String OBJECT_MESSAGE = "message";
    static final String PLACE_IN_APP = "in_app";
    static final String PLACE_PUSH = "push";
    static final String CONTEXT_FROM_LAUNCHER = "from_launcher";
    static final String CONTEXT_FROM_PUSH = "from_push";
    static final String METADATA_BADGE_VALUE = "badge_value";
    static final String METADATA_PUSH_TYPE = "push_type";
    static final String METADATA_CONVERSATION_ID = "conversation_id";
    static final String VALUE_MESSAGE = "message";
    static final String VALUE_NOTIFICATION = "notification";
    private final UserIdentity userIdentity;

    public NewMetricFactory(UserIdentity userIdentity) {
        this.userIdentity = userIdentity;
    }

    public MetricObject receivedPushNotification(String conversationId) {
        return this.constructMetricObject(ACTION_RECEIVED, "message", PLACE_PUSH, CONTEXT_FROM_PUSH).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, VALUE_NOTIFICATION);
    }

    public MetricObject receivedPushOnlyNotification(String conversationId) {
        return this.constructMetricObject(ACTION_RECEIVED, "message", PLACE_PUSH, CONTEXT_FROM_PUSH).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, "message");
    }

    public MetricObject receivedNotificationFromBadgeWhenMessengerClosed(String badgeValue) {
        return this.constructMetricObject(ACTION_RECEIVED, OBJECT_BADGE, PLACE_IN_APP, CONTEXT_FROM_LAUNCHER).addMetaData(METADATA_BADGE_VALUE, badgeValue);
    }

    private MetricObject constructMetricObject(String action, String object, String place, String context) {
        return new MetricObject(this.userIdentity.getIntercomId(), action, object, place, context, TimeProvider.SYSTEM);
    }
}

