/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.preview;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.preview.Overlay;
import io.intercom.android.sdk.preview.PreviewCallbacks;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.utilities.SimpleAnimatorListener;
import io.intercom.com.facebook.rebound.BaseSpringSystem;
import io.intercom.com.facebook.rebound.SimpleSpringListener;
import io.intercom.com.facebook.rebound.Spring;
import io.intercom.com.facebook.rebound.SpringListener;

class StackableSnippet
extends Overlay
implements View.OnTouchListener {
    private final Handler handler;

    public StackableSnippet(Context localisedContext, Conversation conversation, int position, BaseSpringSystem springSystem, Handler handler, int screenHeight, PreviewCallbacks previewCallbacks) {
        super(localisedContext, conversation, position, springSystem, screenHeight, previewCallbacks);
        this.handler = handler;
    }

    @Override
    public void moveBackward(ViewGroup rootView, SimpleAnimatorListener animationListener) {
        ++this.position;
        this.animateToPosition(rootView.getContext());
    }

    @Override
    public void display(ViewGroup root, LayoutInflater inflater, boolean withFullAnimation) {
        this.setupView(root, inflater);
        this.setViewData();
        if (withFullAnimation) {
            this.animateOnScreen(root.getContext());
        } else {
            this.overlayRoot.setVisibility(0);
        }
    }

    @Override
    public void update(Conversation conversation, Runnable updateEndAction) {
        this.conversation = conversation;
        View textContainer = this.overlayRoot.findViewById(R.id.notification_root);
        View text = this.overlayRoot.findViewById(R.id.preview_summary);
        this.performReplyPulse(textContainer, text, updateEndAction);
    }

    @Override
    protected void updateViewDataDuringReplyPulse() {
        this.setViewData();
    }

    private void setupView(ViewGroup root, LayoutInflater inflater) {
        if (this.overlayRoot == null) {
            this.overlayRoot = (LinearLayout)inflater.inflate(R.layout.intercom_preview_notification, root, false);
        }
        if (!this.isAttached()) {
            root.addView((View)this.overlayRoot, 0);
        }
    }

    private void setViewData() {
        Context context = this.overlayRoot.getContext();
        TextView adminName = (TextView)this.overlayRoot.findViewById(R.id.preview_name);
        FontUtils.setRobotoMediumTypeface(adminName);
        adminName.setTextColor(Injector.get().getAppIdentity().getAppConfig().getBaseColor());
        adminName.setText(this.getHeaderText());
        ((TextView)this.overlayRoot.findViewById(R.id.preview_summary)).setText((CharSequence)this.conversation.getLastPart().getSummary());
        ImageView avatarImageView = (ImageView)this.overlayRoot.findViewById(R.id.preview_avatar);
        AvatarUtils.createAvatar(this.conversation.getLastAdmin().getAvatar(), avatarImageView, context);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.overlayRoot.getLayoutParams();
        layoutParams.bottomMargin = ScreenUtils.convertDpToPixel((float)(32 + 8 * this.position), (Context)context);
        if (Build.VERSION.SDK_INT >= 21) {
            this.overlayRoot.setElevation((float)(18 - 3 * this.position));
        }
        this.overlayRoot.setScaleX(1.0f - (float)this.position * 0.05f);
        if (this.position == 0) {
            this.beginListeningForTouchEvents();
        }
    }

    private void animateOnScreen(Context context) {
        int rootHeight = ScreenUtils.convertDpToPixel((float)88.0f, (Context)context);
        int margin = ScreenUtils.convertDpToPixel((float)(32 + 8 * this.position), (Context)context);
        final int dy = this.screenHeight - (rootHeight + margin);
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                StackableSnippet.this.spring.removeAllListeners();
                StackableSnippet.this.spring.setCurrentValue((double)StackableSnippet.this.screenHeight);
                StackableSnippet.this.spring.setEndValue((double)dy);
                StackableSnippet.this.spring.addListener((SpringListener)new SimpleSpringListener(){

                    public void onSpringActivate(Spring spring) {
                        StackableSnippet.this.overlayRoot.setVisibility(0);
                    }

                    public void onSpringUpdate(Spring spring) {
                        StackableSnippet.this.overlayRoot.setY((float)spring.getCurrentValue());
                    }
                });
            }
        }, (long)(this.position * 70));
    }

    @Override
    protected void onPreviewPressed(View view) {
        view.animate().scaleX(0.95f).scaleY(0.95f).setDuration(50L).start();
    }

    @Override
    protected void onPreviewReleased(View view) {
        view.animate().scaleX(1.0f).scaleY(1.0f).setDuration(50L).start();
    }
}

