/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.push.PushBroadcast;
import io.intercom.android.sdk.utilities.IntentUtils;
import java.util.List;

class PushReceiverDelegate {
    private static final String CONSUMED_BY_INTERCOM = "consumed_by_intercom";

    PushReceiverDelegate() {
    }

    void handleIntent(Context context, Intent intent, Api api, MetricsStore metricsStore, UserIdentity userIdentity) {
        if (userIdentity.identityExists()) {
            Intent hostAppIntent = (Intent)intent.getParcelableExtra("host_app_intent");
            PushBroadcast openedPush = this.createPushFromIntent(hostAppIntent);
            if (openedPush.isEmpty()) {
                IntercomLogger.internal("Could not open push. No Uri found");
            } else {
                Uri pushData = openedPush.getPushData();
                String pushOnlyId = openedPush.getPushOnlyId();
                if (openedPush.hasPushOnlyId()) {
                    this.handlePushMessage(context, api, metricsStore, pushData, pushOnlyId);
                } else {
                    this.handlePushNotification(context, hostAppIntent, this.extractNotificationId(pushData));
                }
            }
        }
    }

    private void handlePushMessage(Context context, Api api, MetricsStore metricsStore, Uri pushData, String pushOnlyId) {
        api.markConversationAsRead(pushOnlyId);
        Intent notificationIntent = new Intent("android.intent.action.VIEW", pushData);
        notificationIntent.addFlags(0x10000000);
        metricsStore.track(MetricFactory.openedPushOnlyNotification(pushOnlyId));
        IntentUtils.safelyOpenIntent(context, notificationIntent);
    }

    private void handlePushNotification(Context context, Intent hostAppIntent, String pushData) {
        context.getSharedPreferences("INTERCOM_SDK_PUSH_PREFS", 0).edit().putString("intercom_push_notification_path", pushData).apply();
        IntentUtils.safelyOpenIntent(context, hostAppIntent);
    }

    private PushBroadcast createPushFromIntent(Intent intent) {
        PushBroadcast storedPush = new PushBroadcast();
        if (intent == null) {
            IntercomLogger.internal("Host app intent was null.");
            return storedPush;
        }
        if (this.notLaunchedFromHistory(intent) && this.notConsumedByIntercom(intent) && this.isIntercomIntent(intent.getExtras())) {
            storedPush = new PushBroadcast(intent);
            intent.putExtra(CONSUMED_BY_INTERCOM, true);
        }
        return storedPush;
    }

    private String extractNotificationId(Uri pushData) {
        List pathParts = pushData.getPathSegments();
        if (pathParts.isEmpty()) {
            return "";
        }
        String firstPart = (String)pathParts.get(1);
        if (firstPart.equals("multiple_notifications")) {
            return "multiple_notifications";
        }
        return firstPart.substring(firstPart.lastIndexOf(61) + 1);
    }

    void dismissIntent(Intent intent, MetricsStore metricsStore, UserIdentity userIdentity) {
        if (userIdentity.identityExists()) {
            Intent hostAppIntent = (Intent)intent.getParcelableExtra("host_app_intent");
            PushBroadcast dismissedPush = new PushBroadcast(hostAppIntent);
            if (dismissedPush.isEmpty()) {
                IntercomLogger.internal("Could not track push dismiss. No Uri found");
            } else {
                boolean isPushOnly = dismissedPush.hasPushOnlyId();
                String conversationId = dismissedPush.hasPushOnlyId() ? dismissedPush.getPushOnlyId() : this.extractNotificationId(dismissedPush.getPushData());
                metricsStore.track(MetricFactory.dismissedPushNotification(conversationId, isPushOnly));
            }
        }
    }

    private boolean notConsumedByIntercom(Intent intent) {
        return !intent.getBooleanExtra(CONSUMED_BY_INTERCOM, false);
    }

    private boolean isIntercomIntent(Bundle intentExtras) {
        return intentExtras != null && intentExtras.containsKey("intercom_push_key");
    }

    private boolean notLaunchedFromHistory(Intent intent) {
        return (intent.getFlags() & 0x100000) == 0;
    }
}

