/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.nexus;

import android.support.annotation.Nullable;
import io.intercom.android.sdk.nexus.NexusEvent;
import io.intercom.android.sdk.nexus.NexusListener;
import io.intercom.android.sdk.nexus.NexusTopicProvider;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.okhttp3.OkHttpClient;
import io.intercom.okhttp3.Request;
import io.intercom.okhttp3.RequestBody;
import io.intercom.okhttp3.Response;
import io.intercom.okhttp3.ResponseBody;
import io.intercom.okhttp3.ws.WebSocket;
import io.intercom.okhttp3.ws.WebSocketCall;
import io.intercom.okhttp3.ws.WebSocketListener;
import io.intercom.okio.Buffer;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

class NexusSocket
implements WebSocketListener {
    private static final int OK_CLIENT_DISCONNECT = 4000;
    private static final int N_TIMEOUT_DISCONNECT = 4001;
    private static final int MAX_RECONNECT_TIME = 256;
    private static final String HEADER = "?X-Nexus-Version=android.4.1.1";
    private final NexusListener eventNotifier;
    private final NexusTopicProvider topicProvider;
    private final ScheduledExecutorService backgroundTaskExecutor;
    private final OkHttpClient client;
    private final Twig twig;
    private final String nexusUrl;
    private final long connectionTimeoutSeconds;
    private final boolean shouldSendPresence;
    private WebSocket socket = new ClosedSocket();
    @Nullable
    private ScheduledFuture timeoutFuture;
    private Runnable timeoutRunnable = new Runnable(){

        @Override
        public void run() {
            NexusSocket.this.timedOut();
        }
    };
    private long lastReconnectAt = 0L;
    private int reconnectAttempts = 0;

    NexusSocket(String nexusUrl, int connectionTimeoutSeconds, boolean shouldSendPresence, Twig twig, ScheduledExecutorService backgroundTaskExecutor, OkHttpClient client, NexusListener eventNotifier, NexusTopicProvider topicProvider) {
        this.nexusUrl = nexusUrl;
        this.connectionTimeoutSeconds = connectionTimeoutSeconds;
        this.shouldSendPresence = shouldSendPresence;
        this.twig = twig;
        this.eventNotifier = eventNotifier;
        this.topicProvider = topicProvider;
        this.client = client;
        this.backgroundTaskExecutor = backgroundTaskExecutor;
        this.connect(nexusUrl);
    }

    private void connect(String url) {
        this.twig.d("connecting to a socket...", new Object[0]);
        this.socket = new ConnectingSocket();
        final Request request = new Request.Builder().url(url + HEADER).build();
        this.backgroundTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                WebSocketCall.create(NexusSocket.this.client, request).enqueue(NexusSocket.this);
            }
        });
        this.timeoutFuture = this.backgroundTaskExecutor.schedule(this.timeoutRunnable, this.connectionTimeoutSeconds, TimeUnit.SECONDS);
    }

    void fire(final String data) {
        if (!data.isEmpty()) {
            this.backgroundTaskExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        NexusSocket.this.twig.internal("firing: " + data);
                        NexusSocket.this.socket.sendMessage(RequestBody.create(WebSocket.TEXT, data));
                    }
                    catch (IOException | IllegalStateException e) {
                        NexusSocket.this.twig.internal("fire: " + data + " " + e);
                    }
                }
            });
        }
    }

    void disconnect() {
        this.disconnect(4000);
    }

    boolean isConnected() {
        return !(this.socket instanceof ClosedSocket);
    }

    private void disconnect(final int code) {
        this.backgroundTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    NexusSocket.this.socket.close(code, "Goodbye, world!");
                }
                catch (IOException e) {
                    NexusSocket.this.twig.internal("disconnect: failed " + e.getMessage());
                }
                catch (IllegalStateException ex) {
                    NexusSocket.this.twig.internal("disconnect: socket already closed " + ex);
                }
            }
        });
    }

    private void timedOut() {
        if (this.socket == null) {
            this.connect(this.nexusUrl);
        } else {
            this.disconnect(4001);
        }
        this.eventNotifier.onConnectFailed();
    }

    private void resetTimeout() {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(true);
        }
        this.timeoutFuture = this.backgroundTaskExecutor.schedule(this.timeoutRunnable, this.connectionTimeoutSeconds, TimeUnit.SECONDS);
    }

    private void scheduleReconnect() {
        this.modifyReconnectAttempts();
        long delay = NexusSocket.calculateReconnectTimerInSeconds(this.reconnectAttempts);
        this.twig.internal("Scheduling reconnect in: " + delay + " for attempt: " + this.reconnectAttempts);
        this.backgroundTaskExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                NexusSocket.this.connect(NexusSocket.this.nexusUrl);
            }
        }, delay, TimeUnit.SECONDS);
    }

    private void modifyReconnectAttempts() {
        long maxReconnectTimeIncludingJitter;
        long millisSinceLastAttempt = System.currentTimeMillis() - this.lastReconnectAt;
        if (millisSinceLastAttempt > (maxReconnectTimeIncludingJitter = TimeUnit.SECONDS.toMillis(256L) * 2L)) {
            this.twig.d("resetting reconnection attempts", new Object[0]);
            this.reconnectAttempts = 1;
        } else {
            this.twig.d("incrementing reconnection attempts", new Object[0]);
            ++this.reconnectAttempts;
        }
        this.lastReconnectAt = System.currentTimeMillis();
    }

    @Override
    public void onOpen(WebSocket webSocket, Response response) {
        this.twig.internal("onOpen: " + response.message());
        this.socket = webSocket;
        this.resetTimeout();
        List<String> topics = this.topicProvider.getTopics();
        if (!topics.isEmpty()) {
            this.fire(NexusEvent.getSubscribeEvent(topics).toStringEncodedJsonObject());
        }
        if (this.shouldSendPresence) {
            this.fire(NexusEvent.getUserPresenceEvent().toStringEncodedJsonObject());
        }
        this.eventNotifier.onConnect();
    }

    @Override
    public void onMessage(ResponseBody message) throws IOException {
        this.resetTimeout();
        if (message.contentType() == WebSocket.TEXT) {
            this.parseJsonString(message.string());
        }
        message.close();
    }

    private void parseJsonString(String content) {
        if (content.isEmpty() || content.equals(" ") || content.endsWith("|")) {
            return;
        }
        try {
            JSONObject json = new JSONObject(content);
            String eventName = json.optString("eventName");
            if (eventName.isEmpty() || eventName.equals("ACK")) {
                this.twig.internal("onMessage ACK: " + content);
            } else {
                this.twig.internal("onMessage TEXT: " + content);
                this.eventNotifier.notifyEvent(new NexusEvent(json));
            }
        }
        catch (JSONException e) {
            this.twig.internal("onMessage: json parse exception for message: '" + content + " " + (Object)((Object)e));
        }
    }

    @Override
    public void onPong(Buffer payload) {
        payload.close();
    }

    @Override
    public void onClose(int code, String reason) {
        switch (code) {
            case 4000: {
                this.shutdown();
                break;
            }
            default: {
                this.scheduleReconnect();
            }
        }
        this.twig.internal("onClose code: " + code + " reason: " + reason);
    }

    @Override
    public void onFailure(IOException e, Response response) {
        if (NexusSocket.shouldReconnectFromFailure(e.getMessage())) {
            this.scheduleReconnect();
        } else {
            this.shutdown();
        }
        this.twig.internal("onFailure: " + e.getMessage());
        this.eventNotifier.onConnectFailed();
    }

    private void shutdown() {
        this.socket = new ClosedSocket();
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(true);
        }
    }

    static long calculateReconnectTimerInSeconds(int reconnectAttempts) {
        int minimumBackoffSeconds = (int)Math.min(Math.pow(2.0, reconnectAttempts), 256.0);
        int jitter = new Random().nextInt(minimumBackoffSeconds + 1);
        return minimumBackoffSeconds + jitter;
    }

    static boolean shouldReconnectFromFailure(String exception) {
        String okhttpOpeningError = "Expected HTTP 101 response but was";
        if (exception != null) {
            if (exception.equals("closed")) {
                return false;
            }
            if (exception.startsWith(okhttpOpeningError)) {
                return exception.substring(okhttpOpeningError.length()).startsWith(" '5");
            }
        }
        return true;
    }

    private class ClosedSocket
    extends DummySocket {
        private ClosedSocket() {
        }
    }

    private class ConnectingSocket
    extends DummySocket {
        private ConnectingSocket() {
        }
    }

    private static class DummySocket
    implements WebSocket {
        private DummySocket() {
        }

        @Override
        public void sendMessage(RequestBody message) throws IOException {
        }

        @Override
        public void sendPing(Buffer payload) throws IOException {
        }

        @Override
        public void close(int code, String reason) throws IOException {
        }
    }
}

