/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.middleware;

import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.api.UserUpdateBatcher;
import io.intercom.android.sdk.api.UserUpdateRequest;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;

public class UserUpdateBatcherMiddleware
implements Store.Middleware<State> {
    private final AppConfig.Provider appConfigProvider;
    private final UserUpdateBatcher.Provider userUpdateBatcherProvider;

    public UserUpdateBatcherMiddleware(UserUpdateBatcher.Provider userUpdateBatcherProvider, AppConfig.Provider appConfigProvider) {
        this.appConfigProvider = appConfigProvider;
        this.userUpdateBatcherProvider = userUpdateBatcherProvider;
    }

    @Override
    public void dispatch(Store<State> store, Action<?> action, Store.NextDispatcher next) {
        next.dispatch(action);
        switch (action.type()) {
            case APP_ENTERED_FOREGROUND: {
                long currentTime = (Long)action.value();
                long timeSinceBackgrounded = currentTime - store.state().hostAppState().backgroundedTimestamp();
                if (timeSinceBackgrounded <= this.appConfigProvider.getAppConfig().getNewSessionThresholdMs()) break;
                this.userUpdateBatcherProvider.getUserUpdateBatcher().updateUser(new UserUpdateRequest(true, store.select(Selectors.APP_IS_BACKGROUNDED)));
                break;
            }
        }
    }
}

