/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.identity;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import io.intercom.android.sdk.logger.TwigFactory;
import io.intercom.android.sdk.twig.Twig;
import java.util.HashMap;
import java.util.Map;

public class Registration {
    private final Twig twig = TwigFactory.getLogger();
    private String email = "";
    private String userId = "";
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private Validity validity = Validity.NOT_SET;

    public static Registration create() {
        return new Registration();
    }

    public Registration withEmail(@NonNull String email) {
        boolean validEmail;
        boolean bl = validEmail = !TextUtils.isEmpty((CharSequence)email);
        if (validEmail) {
            this.email = email;
        } else {
            this.twig.e("Email cannot be null or empty", new Object[0]);
        }
        this.updateState(validEmail);
        return this;
    }

    public Registration withUserId(@NonNull String userId) {
        boolean validUserId;
        boolean bl = validUserId = !TextUtils.isEmpty((CharSequence)userId);
        if (validUserId) {
            this.userId = userId;
        } else {
            this.twig.e("UserId cannot be null or empty", new Object[0]);
        }
        this.updateState(validUserId);
        return this;
    }

    public Registration withUserAttributes(@NonNull Map<String, Object> attributes) {
        if (attributes == null) {
            this.validity = Validity.INVALID;
            this.twig.e("Registration.withUserAttributes method failed: the attributes Map provided is null", new Object[0]);
        } else if (attributes.isEmpty()) {
            this.validity = Validity.INVALID;
            this.twig.e("Registration.withUserAttributes method failed: the attributes Map provided is empty", new Object[0]);
        } else {
            this.attributes = new HashMap<String, Object>(attributes);
        }
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public String getUserId() {
        return this.userId;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    boolean isValidRegistration() {
        return Validity.VALID.equals((Object)this.validity);
    }

    private void updateState(boolean newState) {
        if (this.validity == Validity.NOT_SET || this.validity == Validity.VALID) {
            this.validity = newState ? Validity.VALID : Validity.INVALID;
        }
    }

    private static enum Validity {
        NOT_SET,
        INVALID,
        VALID;

    }
}

