/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.store;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.support.annotation.Nullable;
import io.intercom.android.sdk.Intercom;
import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.state.OverlayState;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.utilities.ActivityUtils;

class OverlayStateReducer
implements Store.Reducer<OverlayState> {
    @SuppressLint(value={"StaticFieldLeak"})
    static final OverlayState INITIAL_STATE = new OverlayState(Intercom.Visibility.VISIBLE, Intercom.Visibility.GONE, null);

    OverlayStateReducer() {
    }

    @Override
    public OverlayState reduce(Action<?> action, OverlayState current) {
        switch (action.type()) {
            case SET_IN_APP_NOTIFICATION_VISIBILITY: {
                return new OverlayState((Intercom.Visibility)((Object)action.value()), current.launcherVisibility(), current.resumedHostActivity());
            }
            case SET_LAUNCHER_VISIBILITY: {
                return new OverlayState(current.notificationVisibility(), (Intercom.Visibility)((Object)action.value()), current.resumedHostActivity());
            }
            case ACTIVITY_RESUMED: {
                Activity newActivity = (Activity)action.value();
                Activity newHostActivity = ActivityUtils.isHostActivity(newActivity) ? newActivity : null;
                return OverlayStateReducer.newStateIfNewHostActivity(current, newHostActivity);
            }
            case ACTIVITY_PAUSED: {
                return OverlayStateReducer.newStateIfNewHostActivity(current, null);
            }
        }
        return current;
    }

    private static OverlayState newStateIfNewHostActivity(OverlayState current, @Nullable Activity activity) {
        if (current.resumedHostActivity() == activity) {
            return current;
        }
        return new OverlayState(current.notificationVisibility(), current.launcherVisibility(), activity);
    }
}

