package io.intercom.android.sdk.push;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;

public class IntercomPushBroadcastReceiver extends BroadcastReceiver {
    static final String INTERCOM_PUSH_OPENED = "io.intercom.android.sdk.INTERCOM_PUSH_OPENED";
    static final String INTERCOM_PUSH_DISMISSED = "io.intercom.android.sdk.INTERCOM_PUSH_DISMISSED";

    private final PushReceiverDelegate pushReceiverDelegate = new PushReceiverDelegate();

    @Override public void onReceive(Context context, Intent intent) {
        Injector.init((Application) context.getApplicationContext());
        UserIdentity userIdentity = Injector.get().getUserIdentity();
        MetricFactory metricFactory = new MetricFactory(userIdentity);
        MetricsStore metricStore = Injector.get().getMetricsStore();

        switch (intent.getAction()) {
            case INTERCOM_PUSH_DISMISSED:
                pushReceiverDelegate.trackDismiss(intent, userIdentity, metricStore, metricFactory);
                break;
            default:
            case INTERCOM_PUSH_OPENED:
                Api api = Injector.get().getApi();
                pushReceiverDelegate.handlePushTap(context, intent, api, userIdentity, metricStore, metricFactory);
                break;
        }
    }

}
