/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.overlay;

import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.overlay.Overlay;
import io.intercom.android.sdk.overlay.PreviewCallbacks;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.FontUtils;

class StackableSnippet
extends Overlay
implements View.OnTouchListener {
    private final Handler handler;

    public StackableSnippet(Context localisedContext, Conversation conversation, int position, Handler handler, int screenHeight, PreviewCallbacks previewCallbacks) {
        super(localisedContext, conversation, position, screenHeight, previewCallbacks);
        this.handler = handler;
    }

    @Override
    public void moveBackward(ViewGroup rootView, AnimatorListenerAdapter animationListener) {
        ++this.position;
        this.animateToPosition(rootView.getContext());
    }

    @Override
    public void display(ViewGroup root, LayoutInflater inflater, boolean withFullAnimation) {
        this.setupView(root, inflater);
        this.setViewData();
        if (withFullAnimation) {
            this.animateOnScreen();
        } else {
            this.overlayRoot.setVisibility(0);
        }
    }

    @Override
    public void update(Conversation conversation, Runnable updateEndAction) {
        this.conversation = conversation;
        View textContainer = this.overlayRoot.findViewById(R.id.notification_root);
        View text = this.overlayRoot.findViewById(R.id.preview_summary);
        this.performReplyPulse(textContainer, text, updateEndAction);
    }

    @Override
    protected void updateViewDataDuringReplyPulse() {
        this.setViewData();
    }

    private void setupView(ViewGroup root, LayoutInflater inflater) {
        if (this.overlayRoot == null) {
            this.overlayRoot = (LinearLayout)inflater.inflate(R.layout.intercom_preview_notification, root, false);
        }
        if (!this.isAttached()) {
            root.addView((View)this.overlayRoot, 0);
        }
    }

    private void setViewData() {
        Context context = this.overlayRoot.getContext();
        TextView adminName = (TextView)this.overlayRoot.findViewById(R.id.preview_name);
        FontUtils.setRobotoMediumTypeface(adminName);
        adminName.setTextColor(Injector.get().getAppIdentity().getAppConfig().getBaseColor());
        adminName.setText(this.getHeaderText());
        ((TextView)this.overlayRoot.findViewById(R.id.preview_summary)).setText((CharSequence)this.conversation.getLastPart().getSummary());
        ImageView avatarImageView = (ImageView)this.overlayRoot.findViewById(R.id.preview_avatar);
        AvatarUtils.loadAvatarIntoView(this.conversation.getLastAdmin().getAvatar(), avatarImageView);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.overlayRoot.getLayoutParams();
        layoutParams.bottomMargin = ScreenUtils.dpToPx((float)(32 + 8 * this.position), (Context)context);
        if (Build.VERSION.SDK_INT >= 21) {
            this.overlayRoot.setElevation((float)(18 - 3 * this.position));
        }
        this.overlayRoot.setScaleX(1.0f - (float)this.position * 0.05f);
        if (this.position == 0) {
            this.beginListeningForTouchEvents();
        }
    }

    private void animateOnScreen() {
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                StackableSnippet.this.overlayRoot.setVisibility(0);
                StackableSnippet.this.overlayRoot.setY((float)StackableSnippet.this.screenHeight);
                StackableSnippet.this.overlayRoot.animate().setInterpolator((TimeInterpolator)new OvershootInterpolator(0.6f)).translationY(0.0f).setDuration(300L).start();
            }
        }, (long)(this.position * 70));
    }

    @Override
    protected void onPreviewPressed(View view) {
        view.animate().scaleX(0.95f).scaleY(0.95f).setDuration(50L).start();
    }

    @Override
    protected void onPreviewReleased(View view) {
        view.animate().scaleX(1.0f).scaleY(1.0f).setDuration(50L).start();
    }
}

