/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.content.Context;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.CallbackHolder;
import io.intercom.android.sdk.api.HeaderInterceptor;
import io.intercom.android.sdk.api.IdentityInterceptor;
import io.intercom.android.sdk.api.OreoApi;
import io.intercom.android.sdk.api.RateLimiter;
import io.intercom.android.sdk.api.RetryInterceptor;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.nexus.NexusClient;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selection;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.com.squareup.otto.Bus;
import io.intercom.okhttp3.Cache;
import io.intercom.okhttp3.CertificatePinner;
import io.intercom.okhttp3.Interceptor;
import io.intercom.okhttp3.OkHttpClient;
import io.intercom.retrofit2.Converter;
import io.intercom.retrofit2.Retrofit;
import io.intercom.retrofit2.converter.gson.GsonConverterFactory;
import java.io.File;
import java.util.concurrent.TimeUnit;

public class ApiFactory {
    private static final String CACHE_NAME = "Intercom_SDK/HttpCache";
    private static final String PROTOCOL = "https://";
    private static final String PARTIAL_HOSTNAME = ".mobile-sdk-api.intercom.io";
    private static final String ENDPOINT = "/oreo/";
    private static final int CACHE_SIZE = 0xA00000;
    private static final int MAX_DNS_SEGMENT_SIZE = 63;

    public static Api create(Context context, AppIdentity appIdentity, UserIdentity userIdentity, Bus bus, NexusClient nexusClient, Store<State> store, String hostname) {
        OkHttpClient httpClient = ApiFactory.createConfigurableHttpClient(context, appIdentity, userIdentity).build();
        return ApiFactory.createWithNetworkClient(context, appIdentity, userIdentity, bus, httpClient, nexusClient, store, hostname);
    }

    public static Api createWithNetworkClient(Context context, AppIdentity appIdentity, UserIdentity userIdentity, Bus bus, OkHttpClient client, NexusClient nexusClient, Store<State> store, String hostname) {
        OreoApi oreoApi = ApiFactory.createRetrofitClient(client, hostname);
        CallbackHolder callbackHolder = new CallbackHolder(bus, nexusClient, store, userIdentity, appIdentity);
        RateLimiter rateLimiter = new RateLimiter(appIdentity.getAppConfig());
        Selection<Boolean> isBackgrounded = Selection.create(store, Selectors.IS_BACKGROUNDED);
        return new Api(context, appIdentity, userIdentity, bus, client, oreoApi, callbackHolder, nexusClient, rateLimiter, isBackgrounded);
    }

    public static OkHttpClient.Builder createConfigurableHttpClient(Context context, AppIdentity appIdentity, UserIdentity userIdentity) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().readTimeout(2L, TimeUnit.MINUTES).connectTimeout(2L, TimeUnit.MINUTES).writeTimeout(2L, TimeUnit.MINUTES).addInterceptor((Interceptor)new IdentityInterceptor(appIdentity, userIdentity)).addInterceptor((Interceptor)new RetryInterceptor(new RetryInterceptor.Sleeper())).addNetworkInterceptor((Interceptor)HeaderInterceptor.create(context, appIdentity));
        File cacheDirectory = new File(context.getCacheDir().getAbsolutePath(), CACHE_NAME);
        builder.cache(new Cache(cacheDirectory, 0xA00000L));
        String hostname = ApiFactory.getFullHostname(appIdentity.getAppId());
        CertificatePinner certificatePinner = new CertificatePinner.Builder().add(hostname, new String[]{"sha1/BiCgk94N+oILO/VULX+wYS6gWKU="}).build();
        builder.certificatePinner(certificatePinner);
        return builder;
    }

    private static OreoApi createRetrofitClient(OkHttpClient apiHttpClient, String hostname) {
        return (OreoApi)new Retrofit.Builder().baseUrl(hostname).client(apiHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build().create(OreoApi.class);
    }

    public static String getHostname(AppIdentity appIdentity) {
        return ApiFactory.convertHostnameToUrl(ApiFactory.getFullHostname(appIdentity.getAppId()));
    }

    static String convertHostnameToUrl(String hostname) {
        return PROTOCOL + hostname + ENDPOINT;
    }

    static String getFullHostname(String appId) {
        return ApiFactory.createUniqueIdentifier(appId) + PARTIAL_HOSTNAME;
    }

    static String createUniqueIdentifier(String appId) {
        String identifier = appId.replaceAll("[^A-Za-z0-9\\-$]", "") + "-android";
        if (identifier.length() > 63) {
            int endIndex = 63;
            if (identifier.charAt(62) == '-') {
                --endIndex;
            }
            identifier = identifier.substring(0, endIndex);
        }
        return identifier;
    }
}

