/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.app.Fragment;
import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.StringRes;
import android.text.SpannableStringBuilder;
import android.view.View;
import android.widget.TextView;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class Phrase {
    private final CharSequence pattern;
    private final Set<String> keys = new HashSet<String>();
    private final Map<String, CharSequence> keysToValues = new HashMap<String, CharSequence>();
    private CharSequence formatted;
    private Token head;
    private char curChar;
    private int curCharIndex;
    private static final int EOF = 0;

    public static Phrase from(Fragment f, @StringRes int patternResourceId) {
        return Phrase.from(f.getResources(), patternResourceId);
    }

    public static Phrase from(View v, @StringRes int patternResourceId) {
        return Phrase.from(v.getResources(), patternResourceId);
    }

    public static Phrase from(Context c, @StringRes int patternResourceId) {
        return Phrase.from(c.getResources(), patternResourceId);
    }

    public static Phrase from(Resources r, @StringRes int patternResourceId) {
        return Phrase.from(r.getText(patternResourceId));
    }

    public static Phrase from(CharSequence pattern) {
        return new Phrase(pattern);
    }

    public Phrase put(String key, CharSequence value) {
        if (!this.keys.contains(key)) {
            throw new IllegalArgumentException("Key '" + key + "' not found in '" + this.pattern + "'");
        }
        if (value == null) {
            throw new IllegalArgumentException("Null value for '" + key + "'");
        }
        this.keysToValues.put(key, value);
        this.formatted = null;
        return this;
    }

    public Phrase put(String key, int value) {
        return this.put(key, Integer.toString(value));
    }

    public Phrase putOptional(String key, CharSequence value) {
        return this.keys.contains(key) ? this.put(key, value) : this;
    }

    public Phrase putOptional(String key, int value) {
        return this.keys.contains(key) ? this.put(key, value) : this;
    }

    public CharSequence format() {
        if (this.formatted == null) {
            if (!this.keysToValues.keySet().containsAll(this.keys)) {
                HashSet<String> missingKeys = new HashSet<String>(this.keys);
                missingKeys.removeAll(this.keysToValues.keySet());
                throw new IllegalArgumentException("Missing keys: " + missingKeys);
            }
            SpannableStringBuilder sb = new SpannableStringBuilder(this.pattern);
            Token t = this.head;
            while (t != null) {
                t.expand(sb, this.keysToValues);
                t = t.next;
            }
            this.formatted = sb;
        }
        return this.formatted;
    }

    public void into(TextView textView) {
        if (textView == null) {
            throw new IllegalArgumentException("TextView must not be null.");
        }
        textView.setText(this.format());
    }

    public String toString() {
        return this.pattern.toString();
    }

    private Phrase(CharSequence pattern) {
        Token next;
        this.curChar = pattern.length() > 0 ? pattern.charAt(0) : (char)'\u0000';
        this.pattern = pattern;
        Token prev = null;
        while ((next = this.token(prev)) != null) {
            if (this.head == null) {
                this.head = next;
            }
            prev = next;
        }
    }

    private Token token(Token prev) {
        if (this.curChar == '\u0000') {
            return null;
        }
        if (this.curChar == '{') {
            char nextChar = this.lookahead();
            if (nextChar == '{') {
                return this.leftCurlyBracket(prev);
            }
            if (nextChar >= 'a' && nextChar <= 'z') {
                return this.key(prev);
            }
            throw new IllegalArgumentException("Unexpected character '" + nextChar + "'; expected key.");
        }
        return this.text(prev);
    }

    private KeyToken key(Token prev) {
        StringBuilder sb = new StringBuilder();
        this.consume();
        while (this.curChar >= 'a' && this.curChar <= 'z' || this.curChar == '_') {
            sb.append(this.curChar);
            this.consume();
        }
        if (this.curChar != '}') {
            throw new IllegalArgumentException("Missing closing brace: }");
        }
        this.consume();
        if (sb.length() == 0) {
            throw new IllegalArgumentException("Empty key: {}");
        }
        String key = sb.toString();
        this.keys.add(key);
        return new KeyToken(prev, key);
    }

    private TextToken text(Token prev) {
        int startIndex = this.curCharIndex;
        while (this.curChar != '{' && this.curChar != '\u0000') {
            this.consume();
        }
        return new TextToken(prev, this.curCharIndex - startIndex);
    }

    private LeftCurlyBracketToken leftCurlyBracket(Token prev) {
        this.consume();
        this.consume();
        return new LeftCurlyBracketToken(prev);
    }

    private char lookahead() {
        return this.curCharIndex < this.pattern.length() - 1 ? this.pattern.charAt(this.curCharIndex + 1) : (char)'\u0000';
    }

    private void consume() {
        ++this.curCharIndex;
        this.curChar = this.curCharIndex == this.pattern.length() ? (char)'\u0000' : this.pattern.charAt(this.curCharIndex);
    }

    private static class KeyToken
    extends Token {
        private final String key;
        private CharSequence value;

        KeyToken(Token prev, String key) {
            super(prev);
            this.key = key;
        }

        @Override
        void expand(SpannableStringBuilder target, Map<String, CharSequence> data) {
            this.value = data.get(this.key);
            int replaceFrom = this.getFormattedStart();
            int replaceTo = replaceFrom + this.key.length() + 2;
            target.replace(replaceFrom, replaceTo, this.value);
        }

        @Override
        int getFormattedLength() {
            return this.value.length();
        }
    }

    private static class LeftCurlyBracketToken
    extends Token {
        LeftCurlyBracketToken(Token prev) {
            super(prev);
        }

        @Override
        void expand(SpannableStringBuilder target, Map<String, CharSequence> data) {
            int start = this.getFormattedStart();
            target.replace(start, start + 2, (CharSequence)"{");
        }

        @Override
        int getFormattedLength() {
            return 1;
        }
    }

    private static class TextToken
    extends Token {
        private final int textLength;

        TextToken(Token prev, int textLength) {
            super(prev);
            this.textLength = textLength;
        }

        @Override
        void expand(SpannableStringBuilder target, Map<String, CharSequence> data) {
        }

        @Override
        int getFormattedLength() {
            return this.textLength;
        }
    }

    private static abstract class Token {
        private final Token prev;
        private Token next;

        protected Token(Token prev) {
            this.prev = prev;
            if (prev != null) {
                prev.next = this;
            }
        }

        abstract void expand(SpannableStringBuilder var1, Map<String, CharSequence> var2);

        abstract int getFormattedLength();

        final int getFormattedStart() {
            if (this.prev == null) {
                return 0;
            }
            return this.prev.getFormattedStart() + this.prev.getFormattedLength();
        }
    }
}

