/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.preview;

import android.content.Context;
import android.text.TextUtils;
import io.intercom.android.sdk.activities.IntercomMessengerActivity;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.ViewState;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.store.UnreadCountTracker;
import java.util.Set;

public class LauncherOpenBehaviour {
    private final AppConfig.Provider appConfigProvider;
    private final UnreadCountTracker unreadCountTracker;
    private final Store<Boolean> hasConversationsStore;
    private final Store<ViewState> lastViewStore;
    private final LauncherType launcherType;
    private final MetricsStore.Provider metricsStoreProvider;

    public LauncherOpenBehaviour(AppConfig.Provider appConfigProvider, UnreadCountTracker unreadCountTracker, Store<Boolean> hasConversationsStore, Store<ViewState> lastViewStore, LauncherType launcherType, MetricsStore.Provider metricsStoreProvider) {
        this.appConfigProvider = appConfigProvider;
        this.unreadCountTracker = unreadCountTracker;
        this.hasConversationsStore = hasConversationsStore;
        this.lastViewStore = lastViewStore;
        this.launcherType = launcherType;
        this.metricsStoreProvider = metricsStoreProvider;
    }

    public void openMessenger(Context context) {
        Set<String> unreadConversationIds = this.unreadCountTracker.getConversationIds();
        if (unreadConversationIds.size() == 1) {
            this.presentConversation(context, unreadConversationIds.iterator().next());
        } else if (unreadConversationIds.size() > 1) {
            this.presentInbox(context);
        } else {
            this.openLastOrDefaultState(context);
        }
    }

    private void openLastOrDefaultState(Context context) {
        ViewState state = this.lastViewStore.getState();
        ViewState.Screen screen = state.screen();
        if (screen == null) {
            if (this.hasEmptyInbox() && this.appConfigProvider.getAppConfig().isInboundMessages()) {
                this.presentComposer(context);
            } else {
                this.presentInbox(context);
            }
        } else {
            switch (screen) {
                case CONVERSATION: {
                    String lastViewedConversationId = state.conversationId();
                    if (TextUtils.isEmpty((CharSequence)lastViewedConversationId)) {
                        this.presentInbox(context);
                        break;
                    }
                    this.presentConversation(context, lastViewedConversationId);
                    break;
                }
                default: {
                    this.presentInbox(context);
                    break;
                }
                case COMPOSER: {
                    this.presentComposer(context);
                }
            }
        }
    }

    private boolean hasEmptyInbox() {
        return Boolean.FALSE.equals(this.hasConversationsStore.getState()) && this.unreadCountTracker.getConversationIds().isEmpty();
    }

    private void presentConversation(Context context, String conversationId) {
        this.metricsStoreProvider.getMetricsStore().track(MetricFactory.openedMessengerConversation(conversationId, this.launcherType));
        LastParticipatingAdmin unknownAdmin = LastParticipatingAdmin.NULL;
        context.startActivity(IntercomMessengerActivity.openConversation(context, conversationId, unknownAdmin));
    }

    private void presentComposer(Context context) {
        this.metricsStoreProvider.getMetricsStore().track(MetricFactory.openedMessengerNewConversation(this.launcherType));
        context.startActivity(IntercomMessengerActivity.openComposer(context, ""));
    }

    private void presentInbox(Context context) {
        this.metricsStoreProvider.getMetricsStore().track(MetricFactory.openedMessengerConversationList(this.launcherType));
        context.startActivity(IntercomMessengerActivity.openInbox(context));
    }

    public static enum LauncherType {
        DEFAULT,
        CUSTOM;

    }
}

