/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.inbox;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.TeamPresenceProvider;
import io.intercom.android.sdk.inbox.ConversationClickListener;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.utilities.NameUtils;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.android.sdk.utilities.TimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class InboxRowViewHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener {
    private final Context context;
    private final ImageView avatar;
    private final TextView name;
    private final TextView timeStamp;
    private final TextView summary;
    private final ImageView conversationIndicator;
    private final FrameLayout teamPresenceLayout;
    private final List<ImageView> teamPresenceAvatars;
    @NonNull
    private final ConversationClickListener conversationClickListener;
    private final TeamPresenceProvider teamPresenceProvider;
    private TimeFormatter timeFormatter;

    public InboxRowViewHolder(View itemView, @NonNull TeamPresenceProvider teamPresenceProvider, @NonNull ConversationClickListener conversationClickListener, @NonNull TimeFormatter timeFormatter) {
        super(itemView);
        this.conversationClickListener = conversationClickListener;
        this.teamPresenceProvider = teamPresenceProvider;
        itemView.setOnClickListener((View.OnClickListener)this);
        this.context = itemView.getContext();
        this.avatar = (ImageView)itemView.findViewById(R.id.intercom_user_avatar);
        this.name = (TextView)itemView.findViewById(R.id.intercom_user_name);
        this.timeStamp = (TextView)itemView.findViewById(R.id.intercom_time_stamp);
        this.summary = (TextView)itemView.findViewById(R.id.intercom_message_summary);
        this.conversationIndicator = (ImageView)itemView.findViewById(R.id.intercom_conversation_indicator);
        this.teamPresenceLayout = (FrameLayout)itemView.findViewById(R.id.intercom_triple_chathead);
        this.teamPresenceAvatars = Arrays.asList((ImageView)itemView.findViewById(R.id.intercom_chathead_1), (ImageView)itemView.findViewById(R.id.intercom_chathead_2), (ImageView)itemView.findViewById(R.id.intercom_chathead_3));
        this.timeFormatter = timeFormatter;
    }

    public void bindData(Conversation conversation) {
        Part lastPart = conversation.getLastPart();
        if (lastPart.getParticipant().isUserWithId(Injector.get().getUserIdentity().getIntercomId())) {
            this.summary.setText((CharSequence)(this.context.getString(R.string.intercom_inbox_you) + ": " + lastPart.getSummary()));
        } else {
            this.summary.setText((CharSequence)lastPart.getSummary());
        }
        this.timeStamp.setText(this.timeFormatter.getFormattedTime(lastPart.getCreatedAt()));
        this.setRowParticipantDetails(conversation, this.context);
        if (!conversation.getRead().booleanValue()) {
            FontUtils.setTypeface(this.context, this.name, "intercom_roboto_medium.ttf");
            this.summary.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.intercom_grey_800));
            Drawable unreadDot = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.intercom_unread_dot);
            int baseColor = Injector.get().getAppIdentity().getAppConfig().getBaseColor();
            ((GradientDrawable)unreadDot).setColor(baseColor);
            this.timeStamp.setCompoundDrawablesWithIntrinsicBounds(unreadDot, null, null, null);
            this.timeStamp.setTextColor(baseColor);
        } else {
            this.name.setTypeface(Typeface.SANS_SERIF);
            this.summary.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.intercom_grey_600));
            this.timeStamp.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
            this.timeStamp.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.intercom_grey_500));
        }
        if (conversation.isUserParticipated()) {
            this.conversationIndicator.setVisibility(0);
        } else {
            this.conversationIndicator.setVisibility(4);
        }
    }

    private void setRowParticipantDetails(Conversation conversation, Context context) {
        Participant admin = conversation.getLastAdmin();
        if (admin.hasDisplayName()) {
            this.setParticipantAvatar(admin);
            this.setAdminName(conversation, admin);
        } else if (this.teamPresenceProvider.hasTeamPresence()) {
            this.setTeamPresenceAvatar(this.teamPresenceProvider.getTeamPresence());
            this.setTeamPresenceName(context);
        } else {
            this.setParticipantAvatar(admin);
            this.setTeamPresenceName(context);
        }
    }

    private void setTeamPresenceName(Context context) {
        String appName = Injector.get().getAppIdentity().getAppConfig().getName();
        CharSequence nameString = Phrase.from(context, R.string.intercom_team).put("name", appName).format();
        this.name.setText(nameString);
    }

    private void setAdminName(Conversation conversation, Participant admin) {
        ArrayList<Participant> admins = new ArrayList<Participant>();
        for (Participant participant : conversation.getParticipants().values()) {
            if (!participant.isAdmin()) continue;
            admins.add(participant);
        }
        this.name.setText((CharSequence)NameUtils.getFormattedAdmins(this.context, admin, admins.size()));
    }

    private void setParticipantAvatar(Participant participant) {
        this.avatar.setVisibility(0);
        this.teamPresenceLayout.setVisibility(8);
        AvatarUtils.createAvatar(participant.getAvatar(), this.avatar, this.context);
    }

    private void setTeamPresenceAvatar(TeamPresence teamPresence) {
        List<Participant> admins = teamPresence.getActiveAdmins();
        if (admins.size() == 1) {
            this.avatar.setVisibility(0);
            this.teamPresenceLayout.setVisibility(8);
            AvatarUtils.createAvatar(admins.get(0).getAvatar(), this.avatar, this.context);
        } else {
            this.teamPresenceLayout.setVisibility(0);
            this.avatar.setVisibility(8);
            for (int i = 0; i < admins.size() && i < this.teamPresenceAvatars.size(); ++i) {
                ImageView teamAvatarImageView = this.teamPresenceAvatars.get(i);
                teamAvatarImageView.setVisibility(0);
                AvatarUtils.createAvatar(admins.get(i).getAvatar(), teamAvatarImageView, this.context);
            }
            if (admins.size() == 2) {
                ImageView teamAvatarImageViewLeft = this.teamPresenceAvatars.get(0);
                FrameLayout.LayoutParams lpLeft = (FrameLayout.LayoutParams)teamAvatarImageViewLeft.getLayoutParams();
                lpLeft.gravity = 19;
                teamAvatarImageViewLeft.setLayoutParams((ViewGroup.LayoutParams)lpLeft);
                ImageView teamAvatarImageViewRight = this.teamPresenceAvatars.get(1);
                FrameLayout.LayoutParams lpRight = (FrameLayout.LayoutParams)teamAvatarImageViewRight.getLayoutParams();
                lpRight.gravity = 21;
                teamAvatarImageViewRight.setLayoutParams((ViewGroup.LayoutParams)lpRight);
            }
        }
    }

    public void onClick(View v) {
        int index = this.getAdapterPosition();
        if (index != -1) {
            this.conversationClickListener.onConversationClicked(index);
        }
    }
}

