/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.app.Activity;
import android.content.ContentResolver;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.text.TextUtils;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.okio.BufferedSink;
import io.intercom.okio.BufferedSource;
import io.intercom.okio.Okio;
import io.intercom.okio.Sink;
import io.intercom.okio.Source;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;

public class AttachmentUtils {
    public static final String MIME_TYPE_IMAGE = "image";
    public static final String MIME_TYPE_VIDEO = "video";
    public static final String MIME_TYPE_AUDIO = "audio";
    public static final String MIME_TYPE_OTHER = "other";

    public static String getMimeType(String fileName) {
        String mimeType = URLConnection.guessContentTypeFromName(fileName);
        return TextUtils.isEmpty((CharSequence)mimeType) ? MIME_TYPE_OTHER : mimeType;
    }

    public static File getFile(String path) {
        return new File(path);
    }

    public static File getFile(Activity activity, Uri uri) {
        File file;
        InputStream inputStream = AttachmentUtils.getInputStream(activity.getContentResolver(), uri);
        try {
            file = File.createTempFile("prefix", "extension", activity.getCacheDir());
        }
        catch (IOException e) {
            file = new File("");
        }
        try {
            BufferedSource bufferedSource = Okio.buffer((Source)Okio.source((InputStream)inputStream));
            BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)file));
            sink.writeAll((Source)bufferedSource);
            sink.close();
            bufferedSource.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            IntercomLogger.internal("AttachmentUtils", "Couldn't read file: " + e.getMessage());
        }
        return file;
    }

    public static String getPath(File file) {
        String path = "";
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e) {
            IntercomLogger.internal("Couldn't get file path: " + e.getMessage());
        }
        return path;
    }

    public static InputStream getInputStream(ContentResolver contentResolver, Uri uri) {
        InputStream inputStream = null;
        try {
            inputStream = contentResolver.openInputStream(uri);
        }
        catch (IOException e) {
            IntercomLogger.internal("AttachmentUtils", "Couldn't get input stream: " + e.getMessage());
        }
        return inputStream;
    }

    public static void populateBitmapOptions(String path, BitmapFactory.Options options) {
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
    }
}

