/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.photoview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.View;
import android.widget.ImageView;
import io.intercom.android.sdk.photoview.IPhotoView;
import io.intercom.android.sdk.photoview.PhotoViewAttacher;

public class PhotoView
extends ImageView
implements IPhotoView {
    private PhotoViewAttacher attacher;
    private ImageView.ScaleType pendingScaleType;

    public PhotoView(Context context) {
        this(context, null);
    }

    public PhotoView(Context context, AttributeSet attr2) {
        this(context, attr2, 0);
    }

    public PhotoView(Context context, AttributeSet attr2, int defStyle) {
        super(context, attr2, defStyle);
        super.setScaleType(ImageView.ScaleType.MATRIX);
        this.init();
    }

    protected void init() {
        if (null == this.attacher || null == this.attacher.getImageView()) {
            this.attacher = new PhotoViewAttacher(this);
        }
        if (null != this.pendingScaleType) {
            this.setScaleType(this.pendingScaleType);
            this.pendingScaleType = null;
        }
    }

    @Override
    public void setRotationTo(float rotationDegree) {
        this.attacher.setRotationTo(rotationDegree);
    }

    @Override
    public void setRotationBy(float rotationDegree) {
        this.attacher.setRotationBy(rotationDegree);
    }

    @Override
    public boolean canZoom() {
        return this.attacher.canZoom();
    }

    @Override
    public RectF getDisplayRect() {
        return this.attacher.getDisplayRect();
    }

    @Override
    public Matrix getDisplayMatrix() {
        return this.attacher.getDisplayMatrix();
    }

    @Override
    public boolean setDisplayMatrix(Matrix finalRectangle) {
        return this.attacher.setDisplayMatrix(finalRectangle);
    }

    @Override
    public float getMinimumScale() {
        return this.attacher.getMinimumScale();
    }

    @Override
    public float getMediumScale() {
        return this.attacher.getMediumScale();
    }

    @Override
    public float getMaximumScale() {
        return this.attacher.getMaximumScale();
    }

    @Override
    public float getScale() {
        return this.attacher.getScale();
    }

    @Override
    public ImageView.ScaleType getScaleType() {
        return this.attacher.getScaleType();
    }

    @Override
    public void setAllowParentInterceptOnEdge(boolean allow) {
        this.attacher.setAllowParentInterceptOnEdge(allow);
    }

    @Override
    public void setMinimumScale(float minimumScale) {
        this.attacher.setMinimumScale(minimumScale);
    }

    @Override
    public void setMediumScale(float mediumScale) {
        this.attacher.setMediumScale(mediumScale);
    }

    @Override
    public void setMaximumScale(float maximumScale) {
        this.attacher.setMaximumScale(maximumScale);
    }

    @Override
    public void setScaleLevels(float minimumScale, float mediumScale, float maximumScale) {
        this.attacher.setScaleLevels(minimumScale, mediumScale, maximumScale);
    }

    public void setImageDrawable(Drawable drawable2) {
        super.setImageDrawable(drawable2);
        if (null != this.attacher) {
            this.attacher.update();
        }
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        if (null != this.attacher) {
            this.attacher.update();
        }
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        if (null != this.attacher) {
            this.attacher.update();
        }
    }

    @Override
    public void setOnMatrixChangeListener(PhotoViewAttacher.OnMatrixChangedListener listener) {
        this.attacher.setOnMatrixChangeListener(listener);
    }

    @Override
    public void setOnLongClickListener(View.OnLongClickListener l) {
        this.attacher.setOnLongClickListener(l);
    }

    @Override
    public void setScale(float scale) {
        this.attacher.setScale(scale);
    }

    @Override
    public void setScale(float scale, boolean animate) {
        this.attacher.setScale(scale, animate);
    }

    @Override
    public void setScale(float scale, float focalX, float focalY, boolean animate) {
        this.attacher.setScale(scale, focalX, focalY, animate);
    }

    @Override
    public void setScaleType(ImageView.ScaleType scaleType) {
        if (null != this.attacher) {
            this.attacher.setScaleType(scaleType);
        } else {
            this.pendingScaleType = scaleType;
        }
    }

    @Override
    public void setZoomable(boolean zoomable) {
        this.attacher.setZoomable(zoomable);
    }

    @Override
    public Bitmap getVisibleRectangleBitmap() {
        return this.attacher.getVisibleRectangleBitmap();
    }

    @Override
    public void setZoomTransitionDuration(int milliseconds) {
        this.attacher.setZoomTransitionDuration(milliseconds);
    }

    @Override
    public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener newOnDoubleTapListener) {
        this.attacher.setOnDoubleTapListener(newOnDoubleTapListener);
    }

    @Override
    public void setOnScaleChangeListener(PhotoViewAttacher.OnScaleChangeListener onScaleChangeListener) {
        this.attacher.setOnScaleChangeListener(onScaleChangeListener);
    }

    protected void onDetachedFromWindow() {
        this.attacher.cleanup();
        super.onDetachedFromWindow();
    }

    protected void onAttachedToWindow() {
        this.init();
        super.onAttachedToWindow();
    }
}

