/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.BlockAlignment;
import io.intercom.android.sdk.blocks.Image;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.blockInterfaces.ImageBlock;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.photoview.DefaultOnDoubleTapListener;
import io.intercom.android.sdk.photoview.PhotoViewAttacher;
import io.intercom.android.sdk.transforms.RoundedCornersTransform;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ImageUtils;
import io.intercom.android.sdk.views.ResizableImageView;
import io.intercom.com.bumptech.glide.DrawableTypeRequest;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.load.Transformation;
import io.intercom.com.bumptech.glide.load.resource.drawable.GlideDrawable;
import io.intercom.com.bumptech.glide.request.RequestListener;
import io.intercom.com.bumptech.glide.request.target.Target;

public class NetworkImage
extends Image
implements ImageBlock {
    private static final int PROGRESSBAR_DIAMETER_DP = 40;
    private static final float MAXIMUM_SCALE = 8.0f;
    private static final float MEDIUM_SCALE = 3.5f;

    public NetworkImage(Context context, StyleType style) {
        super(context, style);
    }

    private void displayImage(ImageView imageView) {
        PhotoViewAttacher photoViewAttacher = new PhotoViewAttacher(imageView);
        photoViewAttacher.setOnDoubleTapListener(new DefaultOnDoubleTapListener(photoViewAttacher));
        photoViewAttacher.setMaximumScale(8.0f);
        photoViewAttacher.setMediumScale(3.5f);
    }

    public View addImage(String url, String linkUrl, int width, int height, BlockAlignment alignment, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        FrameLayout rootView = new FrameLayout(this.context);
        BlockUtils.createLayoutParams((View)rootView, -2, -2);
        BlockUtils.setDefaultMarginBottom((View)rootView);
        final ResizableImageView imageView = new ResizableImageView(this.context);
        BlockUtils.createLayoutParams((View)imageView, -2, -2);
        imageView.setAdjustViewBounds(true);
        imageView.setScaleType(ImageView.ScaleType.FIT_START);
        this.setBackground(imageView);
        DisplayMetrics displayMetrics = this.context.getResources().getDisplayMetrics();
        int baseColor = Injector.get().getAppIdentity().getAppConfig().getBaseColor();
        int progressbarDiameterPx = (int)TypedValue.applyDimension((int)1, (float)40.0f, (DisplayMetrics)displayMetrics);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(progressbarDiameterPx, progressbarDiameterPx);
        params.gravity = 17;
        final ProgressBar spinner = new ProgressBar(this.context);
        spinner.setLayoutParams((ViewGroup.LayoutParams)params);
        Drawable drawable2 = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.intercom_progress_wheel);
        drawable2.setColorFilter(baseColor, PorterDuff.Mode.SRC_IN);
        spinner.setIndeterminateDrawable(drawable2);
        spinner.setIndeterminate(true);
        rootView.addView((View)imageView);
        rootView.addView((View)spinner);
        if (!TextUtils.isEmpty((CharSequence)url)) {
            DrawableTypeRequest requestCreator = Glide.with((Context)this.context).load(url);
            this.setImageViewBounds(width, height, imageView, requestCreator);
            requestCreator.bitmapTransform(new Transformation[]{new RoundedCornersTransform(this.context, this.context.getResources().getDimensionPixelSize(R.dimen.intercomsdk_image_rounded_corners))}).error(R.drawable.intercom_error).listener((RequestListener)new RequestListener<String, GlideDrawable>(){

                public boolean onException(Exception e, String model, Target<GlideDrawable> target, boolean isFirstResource) {
                    NetworkImage.this.hideLoadingState(spinner, imageView);
                    IntercomLogger.internal("images", "FAILURE");
                    return false;
                }

                public boolean onResourceReady(GlideDrawable resource, String model, Target<GlideDrawable> target, boolean isFromMemoryCache, boolean isFirstResource) {
                    IntercomLogger.internal("images", "SUCCESS");
                    NetworkImage.this.hideLoadingState(spinner, imageView);
                    if (NetworkImage.this.style != StyleType.CHAT_FULL) {
                        imageView.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                InputMethodManager imm = (InputMethodManager)NetworkImage.this.context.getSystemService("input_method");
                                imm.hideSoftInputFromWindow(v.getWindowToken(), 0);
                                NetworkImage.this.displayImage((ImageView)v);
                            }
                        });
                    }
                    return false;
                }
            }).diskCacheStrategy(ImageUtils.getDiskCacheStrategy(url)).into((ImageView)imageView);
        } else {
            this.hideLoadingState(spinner, imageView);
            imageView.setImageResource(R.drawable.intercom_error);
        }
        BlockUtils.setLayoutMarginsAndGravity((View)rootView, alignment.getGravity(), isLastObject);
        return rootView;
    }

    private void hideLoadingState(ProgressBar spinner, ImageView imageView) {
        if (spinner != null) {
            spinner.setVisibility(8);
            imageView.setBackgroundResource(17170445);
        }
    }
}

