/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.views.ResizableImageView;
import io.intercom.com.bumptech.glide.DrawableTypeRequest;

public class Image {
    public static String MIME_TYPE = "image";
    protected final Context context;
    protected final StyleType style;

    public Image(Context context, StyleType style) {
        this.context = context;
        this.style = style;
    }

    protected void setImageViewBounds(int imageWidth, int imageHeight, ResizableImageView imageView, DrawableTypeRequest requestCreator) {
        int totalViewPadding = this.getTotalViewPadding();
        imageView.setTotalViewPadding(totalViewPadding);
        imageView.setDisplayImageDimensions(imageWidth, imageHeight);
        Point dimens = imageView.getImageDimens();
        if (dimens.x > 0 && dimens.y > 0) {
            requestCreator.override(dimens.x, dimens.y);
        }
    }

    protected void setBackground(@NonNull ImageView imageView) {
        imageView.setBackgroundResource(R.drawable.intercom_rounded_image_preview);
    }

    private int getTotalViewPadding() {
        int totalViewPadding;
        Resources resources = this.context.getResources();
        if (this.style == StyleType.USER || this.style == StyleType.ADMIN) {
            float rowIcon = resources.getDimension(R.dimen.intercom_avatar_size);
            float iconSpacer = resources.getDimension(R.dimen.intercom_conversation_row_icon_spacer);
            float rowEndMargin = resources.getDimension(R.dimen.intercom_conversation_row_margin);
            float rowInitialPadding = resources.getDimension(R.dimen.intercom_cell_horizontal_padding);
            totalViewPadding = (int)(rowIcon + iconSpacer + rowEndMargin + rowInitialPadding * 3.0f);
        } else if (this.style == StyleType.POST) {
            float generalPadding = resources.getDimension(R.dimen.intercom_cell_content_padding);
            float postPadding = resources.getDimension(R.dimen.intercom_post_cell_padding);
            totalViewPadding = (int)(generalPadding + postPadding) * 2;
        } else if (this.style == StyleType.NOTE) {
            float generalPadding = resources.getDimension(R.dimen.intercom_cell_content_padding);
            float notePadding = resources.getDimension(R.dimen.intercom_note_cell_padding);
            float noteLayoutMargin = resources.getDimension(R.dimen.intercom_note_layout_margin);
            totalViewPadding = (int)(generalPadding + notePadding + noteLayoutMargin) * 2;
        } else if (this.style == StyleType.CONTAINER_CARD) {
            float containerCardPadding = resources.getDimension(R.dimen.intercom_container_card_cell_padding);
            float rowPadding = resources.getDimension(R.dimen.intercom_cell_horizontal_padding);
            totalViewPadding = (int)(containerCardPadding + rowPadding) * 2;
        } else if (this.style == StyleType.CHAT_FULL) {
            Point p = ScreenUtils.getScreenDimensions((Context)this.context);
            float chatBubbleWidth = resources.getDimension(R.dimen.intercom_chat_overlay_width);
            float chatBubblePadding = resources.getDimension(R.dimen.intercom_chat_overlay_padding_right);
            float textContainerMargin = resources.getDimension(R.dimen.intercom_chat_overlay_text_margin_left);
            float textContainerPaddingLeft = resources.getDimension(R.dimen.intercom_chat_overlay_text_padding_left);
            float textContainerPaddingRight = resources.getDimension(R.dimen.intercom_chat_overlay_text_padding_right);
            float offsets = chatBubblePadding + textContainerMargin + textContainerPaddingLeft + textContainerPaddingRight;
            totalViewPadding = (int)((float)p.x - (chatBubbleWidth - offsets));
        } else {
            totalViewPadding = 0;
        }
        return totalViewPadding;
    }
}

