/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.text.Html;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.blockInterfaces.UnorderedListBlock;
import io.intercom.android.sdk.spans.UnorderedListSpan;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.TrackingLinkMovementMethod;
import java.util.List;

public class UnorderedList
implements UnorderedListBlock {
    private final LayoutInflater inflater;
    private final StyleType style;
    private final Context context;

    public UnorderedList(Context context, StyleType style) {
        this.context = context;
        this.style = style;
        this.inflater = LayoutInflater.from((Context)context);
    }

    public View addUnorderedList(List<String> items, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        TextView textview;
        switch (this.style) {
            case ADMIN: {
                textview = (TextView)this.inflater.inflate(R.layout.intercom_blocks_admin_unorderedlist, parent, false);
                break;
            }
            case NOTE: 
            case CONTAINER_CARD: {
                textview = (TextView)this.inflater.inflate(R.layout.intercom_blocks_note_unorderedlist, parent, false);
                break;
            }
            case POST: {
                textview = (TextView)this.inflater.inflate(R.layout.intercom_blocks_post_unorderedlist, parent, false);
                break;
            }
            default: {
                textview = (TextView)this.inflater.inflate(R.layout.intercom_blocks_user_unorderedlist, parent, false);
            }
        }
        int lineIndent = (int)this.context.getResources().getDimension(R.dimen.intercomsdk_list_indentation);
        CharSequence chars = "";
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            String item = items.get(i);
            if (item.isEmpty()) continue;
            String delimiter = i < size - 1 ? "<br />" : "";
            Spanned source = Html.fromHtml((String)(item + delimiter));
            SpannableString spannableString = new SpannableString((CharSequence)source);
            spannableString.setSpan((Object)new UnorderedListSpan(lineIndent, this.context), 0, source.length(), 0);
            chars = TextUtils.concat((CharSequence[])new CharSequence[]{chars, spannableString});
        }
        textview.setClickable(true);
        textview.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
        textview.setText(chars);
        BlockUtils.setLayoutMarginsAndGravity((View)textview, 3, isLastObject);
        textview.setLinkTextColor(Injector.get().getIdentityStore().getAppConfig().getBaseColor());
        return textview;
    }
}

