/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.content.Intent;
import android.graphics.PorterDuff;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.BlockAlignment;
import io.intercom.android.sdk.blocks.Image;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.blockInterfaces.ImageBlock;
import io.intercom.android.sdk.conversation.lightbox.LightboxActivity;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.transforms.RoundedCornersTransform;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ImageUtils;
import io.intercom.android.sdk.utilities.IntentUtils;
import io.intercom.android.sdk.views.ResizableImageView;
import io.intercom.com.bumptech.glide.DrawableTypeRequest;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.load.Transformation;
import io.intercom.com.bumptech.glide.load.resource.drawable.GlideDrawable;
import io.intercom.com.bumptech.glide.request.RequestListener;
import io.intercom.com.bumptech.glide.request.target.Target;

public class NetworkImage
extends Image
implements ImageBlock {
    public NetworkImage(Context context, StyleType style) {
        super(context, style);
    }

    public View addImage(final String url, final String linkUrl, final int width, final int height, BlockAlignment alignment, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        FrameLayout rootView = (FrameLayout)this.inflater.inflate(R.layout.intercom_blocks_image, parent, false);
        final ResizableImageView imageView = (ResizableImageView)rootView.findViewById(R.id.image_block);
        this.setBackground(imageView);
        final ProgressBar spinner = (ProgressBar)rootView.findViewById(R.id.loading_wheel);
        if (spinner != null) {
            spinner.getIndeterminateDrawable().setColorFilter(Injector.get().getIdentityStore().getAppConfig().getBaseColor(), PorterDuff.Mode.SRC_IN);
        }
        if (!TextUtils.isEmpty((CharSequence)url)) {
            DrawableTypeRequest requestCreator = Glide.with((Context)this.context).load(url);
            this.setImageViewBounds(width, height, imageView, requestCreator);
            requestCreator.bitmapTransform(new Transformation[]{new RoundedCornersTransform(this.context, this.context.getResources().getDimensionPixelSize(R.dimen.intercomsdk_image_rounded_corners))}).error(R.drawable.intercom_error).listener((RequestListener)new RequestListener<String, GlideDrawable>(){

                public boolean onException(Exception e, String model, Target<GlideDrawable> target, boolean isFirstResource) {
                    NetworkImage.this.hideLoadingState(spinner, imageView);
                    IntercomLogger.internal("images", "FAILURE");
                    return false;
                }

                public boolean onResourceReady(GlideDrawable resource, String model, Target<GlideDrawable> target, boolean isFromMemoryCache, boolean isFirstResource) {
                    IntercomLogger.internal("images", "SUCCESS");
                    NetworkImage.this.hideLoadingState(spinner, imageView);
                    imageView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            Intent intent;
                            if (linkUrl.isEmpty()) {
                                intent = LightboxActivity.createIntent(NetworkImage.this.context, width, height, url);
                            } else {
                                Uri uri = Uri.parse((String)linkUrl);
                                intent = new Intent("android.intent.action.VIEW", uri);
                                intent.setFlags(0x10000000);
                            }
                            IntentUtils.safelyOpenIntent(NetworkImage.this.context, intent);
                        }
                    });
                    return false;
                }
            }).diskCacheStrategy(ImageUtils.getDiskCacheStrategy(url)).into((ImageView)imageView);
        } else {
            this.hideLoadingState(spinner, imageView);
            imageView.setImageResource(R.drawable.intercom_error);
        }
        BlockUtils.setLayoutMarginsAndGravity((View)rootView, alignment.getGravity(), isLastObject);
        return rootView;
    }

    private void hideLoadingState(ProgressBar spinner, ImageView imageView) {
        if (spinner != null) {
            spinner.setVisibility(8);
            imageView.setBackgroundResource(17170445);
        }
    }
}

