/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u00a8\u0006\u0007"}, d2={"drawableToBitmap", "Landroid/graphics/Bitmap;", "drawable", "Landroid/graphics/drawable/Drawable;", "defaultWidth", "", "defaultHeight", "intercom-sdk-base_release"})
public final class BitmapUtilsKt {
    @NotNull
    public static final Bitmap drawableToBitmap(@NotNull Drawable drawable2, int defaultWidth, int defaultHeight) {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        if (drawable2 instanceof BitmapDrawable && ((BitmapDrawable)drawable2).getBitmap() != null) {
            Bitmap bitmap2 = ((BitmapDrawable)drawable2).getBitmap();
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"drawable.bitmap");
            return bitmap2;
        }
        if (drawable2.getIntrinsicWidth() <= 0 || drawable2.getIntrinsicHeight() <= 0) {
            Bitmap bitmap3 = Bitmap.createBitmap((int)defaultWidth, (int)defaultHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap = bitmap3;
            Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"Bitmap.createBitmap(\n   \u2026ed of 1x1 pixel\n        )");
        } else {
            Bitmap bitmap4 = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap = bitmap4;
            Intrinsics.checkNotNullExpressionValue((Object)bitmap4, (String)"Bitmap.createBitmap(\n   \u2026onfig.ARGB_8888\n        )");
        }
        Bitmap bitmap5 = bitmap;
        Canvas canvas = new Canvas(bitmap5);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap5;
    }
}

