/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.helpcenter.search;

import android.content.Context;
import android.text.Html;
import android.text.Spanned;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.core.text.HtmlCompat;
import androidx.recyclerview.widget.RecyclerView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.databinding.IntercomArticleSearchResultItemBinding;
import io.intercom.android.sdk.databinding.IntercomViewHelpCenterTeamHelpBinding;
import io.intercom.android.sdk.helpcenter.component.TeammateHelpKt;
import io.intercom.android.sdk.helpcenter.search.ArticleSearchResultRow;
import io.intercom.android.sdk.helpcenter.search.HighlightTagHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\b\u0000\u0018\u0000  2\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0004 !\"#B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\r\u001a\u00020\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u0017\u001a\u00020\u00062\n\u0010\u0018\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\u001c\u0010\u0019\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\u0014\u0010\u001d\u001a\u00020\u00062\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001fR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/intercom/android/sdk/helpcenter/search/SearchResultAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lio/intercom/android/sdk/helpcenter/search/SearchResultAdapter$SearchResultBaseViewHolder;", "onClick", "Lkotlin/Function1;", "", "", "(Lkotlin/jvm/functions/Function1;)V", "getOnClick", "()Lkotlin/jvm/functions/Function1;", "searchResults", "", "Lio/intercom/android/sdk/helpcenter/search/ArticleSearchResultRow;", "clearData", "getItemCount", "", "getItemViewType", "position", "highlightedText", "Landroid/text/Spanned;", "rawText", "context", "Landroid/content/Context;", "onBindViewHolder", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "updateResults", "results", "", "Companion", "SearchResultBaseViewHolder", "SearchResultViewHolder", "TeammateHelpViewHolder", "intercom-sdk-base_release"})
public final class SearchResultAdapter
extends RecyclerView.Adapter<SearchResultBaseViewHolder> {
    private final List<ArticleSearchResultRow> searchResults;
    @NotNull
    private final Function1<String, Unit> onClick;
    public static final int SEARCH_RESULT = 1;
    public static final int TEAMMATE_HELP = 2;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void updateResults(@NotNull List<? extends ArticleSearchResultRow> results) {
        Intrinsics.checkNotNullParameter(results, (String)"results");
        this.searchResults.clear();
        this.searchResults.addAll((Collection<ArticleSearchResultRow>)results);
        this.notifyDataSetChanged();
    }

    public final void clearData() {
        this.searchResults.clear();
        this.notifyDataSetChanged();
    }

    @NotNull
    public SearchResultBaseViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        SearchResultBaseViewHolder searchResultBaseViewHolder;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        switch (viewType) {
            case 2: {
                IntercomViewHelpCenterTeamHelpBinding intercomViewHelpCenterTeamHelpBinding = IntercomViewHelpCenterTeamHelpBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false);
                Intrinsics.checkNotNullExpressionValue((Object)intercomViewHelpCenterTeamHelpBinding, (String)"IntercomViewHelpCenterTe\u2026.context), parent, false)");
                IntercomViewHelpCenterTeamHelpBinding binding = intercomViewHelpCenterTeamHelpBinding;
                View view = binding.helpCenterArticleContactDivider;
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"binding.helpCenterArticleContactDivider");
                view.setVisibility(8);
                searchResultBaseViewHolder = new TeammateHelpViewHolder(binding);
                break;
            }
            default: {
                IntercomArticleSearchResultItemBinding intercomArticleSearchResultItemBinding = IntercomArticleSearchResultItemBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false);
                Intrinsics.checkNotNullExpressionValue((Object)intercomArticleSearchResultItemBinding, (String)"IntercomArticleSearchRes\u2026.context), parent, false)");
                IntercomArticleSearchResultItemBinding binding = intercomArticleSearchResultItemBinding;
                searchResultBaseViewHolder = new SearchResultViewHolder(binding);
            }
        }
        return searchResultBaseViewHolder;
    }

    public int getItemCount() {
        return this.searchResults.size();
    }

    public void onBindViewHolder(@NotNull SearchResultBaseViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        holder.bind(this.searchResults.get(position));
    }

    public int getItemViewType(int position) {
        int n;
        ArticleSearchResultRow articleSearchResultRow = this.searchResults.get(position);
        if (articleSearchResultRow instanceof ArticleSearchResultRow.ArticleResultRow) {
            n = 1;
        } else if (articleSearchResultRow instanceof ArticleSearchResultRow.TeammateHelpRow) {
            n = 2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    private final Spanned highlightedText(String rawText, Context context) {
        int highlightColor = ContextCompat.getColor((Context)context, (int)R.color.intercom_help_center_text);
        HighlightTagHandler tagHandler = new HighlightTagHandler(highlightColor);
        Spanned spanned = HtmlCompat.fromHtml((String)rawText, (int)0, null, (Html.TagHandler)tagHandler);
        Intrinsics.checkNotNullExpressionValue((Object)spanned, (String)"HtmlCompat.fromHtml(rawT\u2026LEGACY, null, tagHandler)");
        return spanned;
    }

    @NotNull
    public final Function1<String, Unit> getOnClick() {
        return this.onClick;
    }

    public SearchResultAdapter(@NotNull Function1<? super String, Unit> onClick) {
        Intrinsics.checkNotNullParameter(onClick, (String)"onClick");
        this.onClick = onClick;
        boolean bl = false;
        this.searchResults = new ArrayList();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00a6\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\t"}, d2={"Lio/intercom/android/sdk/helpcenter/search/SearchResultAdapter$SearchResultBaseViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Lio/intercom/android/sdk/helpcenter/search/SearchResultAdapter;Landroid/view/View;)V", "bind", "", "articleSearchResultRow", "Lio/intercom/android/sdk/helpcenter/search/ArticleSearchResultRow;", "intercom-sdk-base_release"})
    public abstract class SearchResultBaseViewHolder
    extends RecyclerView.ViewHolder {
        public abstract void bind(@NotNull ArticleSearchResultRow var1);

        public SearchResultBaseViewHolder(View itemView) {
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lio/intercom/android/sdk/helpcenter/search/SearchResultAdapter$TeammateHelpViewHolder;", "Lio/intercom/android/sdk/helpcenter/search/SearchResultAdapter$SearchResultBaseViewHolder;", "Lio/intercom/android/sdk/helpcenter/search/SearchResultAdapter;", "binding", "Lio/intercom/android/sdk/databinding/IntercomViewHelpCenterTeamHelpBinding;", "(Lio/intercom/android/sdk/helpcenter/search/SearchResultAdapter;Lio/intercom/android/sdk/databinding/IntercomViewHelpCenterTeamHelpBinding;)V", "getBinding", "()Lio/intercom/android/sdk/databinding/IntercomViewHelpCenterTeamHelpBinding;", "bind", "", "articleSearchResultRow", "Lio/intercom/android/sdk/helpcenter/search/ArticleSearchResultRow;", "intercom-sdk-base_release"})
    public final class TeammateHelpViewHolder
    extends SearchResultBaseViewHolder {
        @NotNull
        private final IntercomViewHelpCenterTeamHelpBinding binding;

        @Override
        public void bind(@NotNull ArticleSearchResultRow articleSearchResultRow) {
            Intrinsics.checkNotNullParameter((Object)articleSearchResultRow, (String)"articleSearchResultRow");
            ArticleSearchResultRow.TeammateHelpRow teammateHelpRow = (ArticleSearchResultRow.TeammateHelpRow)articleSearchResultRow;
            boolean bl = false;
            boolean bl2 = false;
            ArticleSearchResultRow.TeammateHelpRow $this$with = teammateHelpRow;
            boolean bl3 = false;
            TeammateHelpKt.renderTeamPresence(this.binding, $this$with.getTeamPresenceState());
        }

        @NotNull
        public final IntercomViewHelpCenterTeamHelpBinding getBinding() {
            return this.binding;
        }

        public TeammateHelpViewHolder(IntercomViewHelpCenterTeamHelpBinding binding) {
            Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
            ConstraintLayout constraintLayout = binding.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
            super((View)constraintLayout);
            this.binding = binding;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lio/intercom/android/sdk/helpcenter/search/SearchResultAdapter$SearchResultViewHolder;", "Lio/intercom/android/sdk/helpcenter/search/SearchResultAdapter$SearchResultBaseViewHolder;", "Lio/intercom/android/sdk/helpcenter/search/SearchResultAdapter;", "binding", "Lio/intercom/android/sdk/databinding/IntercomArticleSearchResultItemBinding;", "(Lio/intercom/android/sdk/helpcenter/search/SearchResultAdapter;Lio/intercom/android/sdk/databinding/IntercomArticleSearchResultItemBinding;)V", "getBinding", "()Lio/intercom/android/sdk/databinding/IntercomArticleSearchResultItemBinding;", "bind", "", "articleSearchResultRow", "Lio/intercom/android/sdk/helpcenter/search/ArticleSearchResultRow;", "intercom-sdk-base_release"})
    public final class SearchResultViewHolder
    extends SearchResultBaseViewHolder {
        @NotNull
        private final IntercomArticleSearchResultItemBinding binding;

        @Override
        public void bind(@NotNull ArticleSearchResultRow articleSearchResultRow) {
            Intrinsics.checkNotNullParameter((Object)articleSearchResultRow, (String)"articleSearchResultRow");
            ArticleSearchResultRow.ArticleResultRow articleResultRow = (ArticleSearchResultRow.ArticleResultRow)articleSearchResultRow;
            boolean bl = false;
            boolean bl2 = false;
            ArticleSearchResultRow.ArticleResultRow $this$with = articleResultRow;
            boolean bl3 = false;
            String invisibleSymbol = "&zwj;";
            TextView textView = this.binding.title;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.title");
            String string2 = invisibleSymbol + $this$with.getTitleText();
            FrameLayout frameLayout = this.binding.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"binding.root");
            Context context = frameLayout.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"binding.root.context");
            textView.setText((CharSequence)SearchResultAdapter.this.highlightedText(string2, context));
            TextView textView2 = this.binding.summary;
            Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"binding.summary");
            String string3 = invisibleSymbol + $this$with.getSummaryText();
            FrameLayout frameLayout2 = this.binding.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)frameLayout2, (String)"binding.root");
            Context context2 = frameLayout2.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"binding.root.context");
            textView2.setText((CharSequence)SearchResultAdapter.this.highlightedText(string3, context2));
            TextView textView3 = this.binding.summary;
            Intrinsics.checkNotNullExpressionValue((Object)textView3, (String)"binding.summary");
            textView3.setVisibility($this$with.getSummaryVisibility());
            this.binding.getRoot().setOnClickListener(new View.OnClickListener($this$with, this){
                final /* synthetic */ ArticleSearchResultRow.ArticleResultRow $this_with;
                final /* synthetic */ SearchResultViewHolder this$0;
                {
                    this.$this_with = articleResultRow;
                    this.this$0 = searchResultViewHolder;
                }

                public final void onClick(View it) {
                    this.this$0.SearchResultAdapter.this.getOnClick().invoke((Object)this.$this_with.getId());
                }
            });
        }

        @NotNull
        public final IntercomArticleSearchResultItemBinding getBinding() {
            return this.binding;
        }

        public SearchResultViewHolder(IntercomArticleSearchResultItemBinding binding) {
            Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
            FrameLayout frameLayout = binding.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"binding.root");
            super((View)frameLayout);
            this.binding = binding;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/intercom/android/sdk/helpcenter/search/SearchResultAdapter$Companion;", "", "()V", "SEARCH_RESULT", "", "TEAMMATE_HELP", "intercom-sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

