/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.preview;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.media.SoundPool;
import android.os.Handler;
import android.os.Parcelable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.MainActivity;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.preview.IntercomPreviewPosition;
import io.intercom.android.sdk.preview.PreviewAnimation;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.utilities.IntercomUtils;
import io.intercom.android.sdk.utilities.ScreenUtils;
import java.util.List;

@TargetApi(value=11)
public class PreviewDisplayManager {
    private static final float PREVIEW_TOUCHED_SCALE = 0.9f;
    private static final int PREVIEW_ORIGINAL_SCALE = 1;
    private static final int PREVIEW_OPEN_DELAY_MILLIS = 200;
    private IntercomPreviewPosition previewPosition = IntercomPreviewPosition.BOTTOM_LEFT;
    private int notificationPreviewVisible = 0;
    protected Conversation currentlyDisplayedConversation;

    public int getVisibility() {
        return this.notificationPreviewVisible;
    }

    public IntercomPreviewPosition getPreviewPosition() {
        return this.previewPosition;
    }

    public void setVisibility(int visibility) {
        this.notificationPreviewVisible = visibility;
    }

    public void setPreviewPosition(IntercomPreviewPosition previewPosition) {
        this.previewPosition = previewPosition;
    }

    public void conditionallyAddPreview(Activity activity, List<Conversation> conversations, int unreadCount) throws Exception {
        if (this.shouldDisplayPreview(activity, conversations)) {
            this.evaluatePreviewType(activity, conversations.get(0), unreadCount);
        }
    }

    public void conditionallyRemovePreview(Activity activity) throws Exception {
        View root = activity.findViewById(R.id.previewRoot);
        if (root != null) {
            ((ViewGroup)root.getParent()).removeView(root);
        }
    }

    private synchronized void evaluatePreviewType(Activity activity, Conversation conversation, int unreadCount) {
        String messageStyle = conversation.getLastPart().getMessageStyle();
        if ("announcement".equals(messageStyle) || "small-announcement".equals(messageStyle)) {
            this.goToConversation(conversation, unreadCount);
        } else if ("chat".equals(messageStyle)) {
            this.displayNotificationPreview(activity, conversation, unreadCount);
            this.currentlyDisplayedConversation = conversation;
        }
    }

    private void displayNotificationPreview(Activity activity, Conversation conversation, int unreadCount) {
        boolean shouldFadeInPreview = this.shouldFadeInPreview(activity);
        View root = this.initViewIfNecessary(activity);
        this.displayChatHead(root, conversation, unreadCount);
        if (this.shouldPlaySound(conversation)) {
            IntercomLogger.INTERNAL("preview", "playing preview sound");
            this.playSound((Context)activity);
        }
        if (shouldFadeInPreview) {
            IntercomLogger.INTERNAL("preview", "fading in preview");
            PreviewAnimation.fadeInPreview(root.findViewById(R.id.avatar), root.findViewById(R.id.indicator_text), root.findViewById(R.id.avatar_shadow));
        }
        if (this.shouldShowTextPreview(conversation)) {
            IntercomLogger.INTERNAL("preview", "showing text preview");
            this.displayTextPreview(activity, (TextView)root.findViewById(R.id.notification_text), conversation, unreadCount);
        }
    }

    private View initViewIfNecessary(Activity activity) {
        View root = activity.findViewById(R.id.previewRoot);
        if (root == null) {
            root = activity.getLayoutInflater().inflate(R.layout.intercomsdk_preview, null, false);
            if (this.previewPosition.isLeftAligned()) {
                View v = root.findViewById(R.id.notification_text);
                v.setBackgroundResource(R.drawable.intercomsdk_preview_bubble_left);
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)v.getLayoutParams();
                layoutParams.leftMargin = ScreenUtils.convertDpToPixel(8.0f, (Context)activity);
                layoutParams.addRule(1, R.id.avatar_container);
            } else {
                View v = root.findViewById(R.id.notification_text);
                v.setBackgroundResource(R.drawable.intercomsdk_preview_bubble_right);
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)v.getLayoutParams();
                layoutParams.rightMargin = ScreenUtils.convertDpToPixel(8.0f, (Context)activity);
                layoutParams.addRule(0, R.id.avatar_container);
            }
            activity.addContentView(root, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        }
        return root;
    }

    private void displayChatHead(View root, final Conversation conversation, final int unreadCount) {
        View avatarContainer = root.findViewById(R.id.avatar_container);
        ImageView notificationAvatar = (ImageView)root.findViewById(R.id.avatar);
        TextView indicatorText = (TextView)root.findViewById(R.id.indicator_text);
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)avatarContainer.getLayoutParams();
        this.previewPosition.setAlignment(layoutParams);
        AvatarUtils.createAvatar(conversation.getLastAdmin().isAdmin(), conversation.getLastAdmin().getAvatar(), notificationAvatar, root.getContext());
        indicatorText.setText((CharSequence)String.valueOf(unreadCount));
        FontUtils.setTypeface(indicatorText, "intercomsdk_roboto_medium.ttf", root.getContext());
        avatarContainer.setOnTouchListener(new View.OnTouchListener(){
            private int initialX;
            private int initialY;
            private int initialWidth;
            private int initialHeight;

            public boolean onTouch(View view, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        int[] location = new int[2];
                        view.getLocationOnScreen(location);
                        this.initialX = location[0];
                        this.initialY = location[1];
                        this.initialWidth = view.getWidth();
                        this.initialHeight = view.getHeight();
                        view.setScaleX(0.9f);
                        view.setScaleY(0.9f);
                        return true;
                    }
                    case 1: {
                        if (PreviewDisplayManager.isTouchInViewBounds(event.getRawX(), event.getRawY(), this.initialX, this.initialY, this.initialWidth, this.initialHeight)) {
                            view.setScaleX(1.0f);
                            view.setScaleY(1.0f);
                            new Handler().postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    PreviewDisplayManager.this.goToConversation(conversation, unreadCount);
                                }
                            }, 200L);
                        }
                        return true;
                    }
                }
                if (PreviewDisplayManager.isTouchInViewBounds(event.getRawX(), event.getRawY(), this.initialX, this.initialY, this.initialWidth, this.initialHeight)) {
                    view.setScaleX(0.9f);
                    view.setScaleY(0.9f);
                } else {
                    view.setScaleX(1.0f);
                    view.setScaleY(1.0f);
                }
                return true;
            }
        });
        IntercomLogger.INTERNAL("preview", "displayed preview");
    }

    private void displayTextPreview(Activity activity, final TextView notificationTextView, final Conversation conversation, final int unreadCount) {
        String lastAdminText = conversation.getLastAdminPart().getSummary();
        if (!lastAdminText.isEmpty()) {
            notificationTextView.setText((CharSequence)lastAdminText);
        } else {
            notificationTextView.setText(R.string.intercomsdk_image_attached);
        }
        FontUtils.setTypeface(notificationTextView, "intercomsdk_roboto_medium.ttf", (Context)activity);
        notificationTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PreviewDisplayManager.this.goToConversation(conversation, unreadCount);
            }
        });
        notificationTextView.setVisibility(0);
        notificationTextView.getBackground().setColorFilter(Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor()), PorterDuff.Mode.MULTIPLY);
        final float initialTranslationX = notificationTextView.getTranslationX();
        AnimatorSet set = PreviewAnimation.animateTextPreview((View)notificationTextView, this.previewPosition.isLeftAligned());
        set.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                IntercomLogger.INTERNAL("anim", "target visibility before: " + notificationTextView.getVisibility());
                notificationTextView.setVisibility(8);
                IntercomLogger.INTERNAL("anim", "target visibility after: " + notificationTextView.getVisibility());
                IntercomLogger.INTERNAL("anim", "target translationX before: " + notificationTextView.getTranslationX());
                notificationTextView.setTranslationX(initialTranslationX);
                IntercomLogger.INTERNAL("anim", "target translationX after: " + notificationTextView.getTranslationX());
            }
        });
        set.start();
    }

    private void playSound(Context context) {
        SoundPool soundPool = new SoundPool(1, 5, 0);
        soundPool.setOnLoadCompleteListener(new SoundPool.OnLoadCompleteListener(){

            public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
                soundPool.play(sampleId, 1.0f, 1.0f, 1, 0, 1.0f);
            }
        });
        soundPool.load(context, R.raw.intercomsdk_birdy_done_1, 1);
    }

    boolean shouldDisplayPreview(Activity activity, List<Conversation> conversations) {
        boolean result = this.notificationPreviewVisible == 0 && activity != null && conversations != null && !conversations.isEmpty() && (!conversations.get(0).equals(this.currentlyDisplayedConversation) || activity.findViewById(R.id.previewRoot) == null) && !IntercomUtils.isIntercomActivity(activity);
        IntercomLogger.INTERNAL("preview", "should display preview: " + result);
        return result;
    }

    boolean shouldFadeInPreview(Activity activity) {
        return activity.findViewById(R.id.previewRoot) == null;
    }

    private boolean shouldPlaySound(Conversation conversation) {
        return !conversation.equals(this.currentlyDisplayedConversation) && Bridge.getIdentityStore().getAppConfig().isAudioEnabled();
    }

    private boolean shouldShowTextPreview(Conversation conversation) {
        return !conversation.equals(this.currentlyDisplayedConversation);
    }

    static boolean isTouchInViewBounds(float touchX, float touchY, int viewX, int viewY, int viewWidth, int viewHeight) {
        return touchX > (float)viewX && touchX < (float)(viewX + viewWidth) && touchY > (float)viewY && touchY < (float)(viewY + viewHeight);
    }

    private void goToConversation(Conversation conversation, int unreadCount) {
        Context context = Bridge.getContext();
        Intent intent = new Intent(context, MainActivity.class);
        intent.putExtra("OpenConversation", (Parcelable)conversation);
        intent.putExtra("intercomsdk-unreadCount", unreadCount);
        intent.putExtra("intercomsdk-isRead", false);
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }
}

