/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ProgressBar;
import android.widget.TextView;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.attachments.AttachmentActivity;
import io.intercom.android.sdk.attachments.AttachmentData;
import io.intercom.android.sdk.blocks.BlockType;
import io.intercom.android.sdk.blocks.Blocks;
import io.intercom.android.sdk.blocks.Image;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.blocks.models.BlockAttachment;
import io.intercom.android.sdk.commons.utilities.DeviceUtils;
import io.intercom.android.sdk.conversation.BaseConversationFragment;
import io.intercom.android.sdk.conversation.ComposerInputView;
import io.intercom.android.sdk.conversation.ConversationAdapter;
import io.intercom.android.sdk.conversation.SpoolWrapper;
import io.intercom.android.sdk.conversation.UploadProgressListener;
import io.intercom.android.sdk.conversation.events.AdminIsTypingEvent;
import io.intercom.android.sdk.conversation.events.AdminTypingEndedEvent;
import io.intercom.android.sdk.conversation.events.CancelAdminTypingEvent;
import io.intercom.android.sdk.conversation.events.SendingEvent;
import io.intercom.android.sdk.models.Attachments;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Events.ConversationEvent;
import io.intercom.android.sdk.models.Events.Failure.ConversationFailedEvent;
import io.intercom.android.sdk.models.Events.Failure.NewConversationFailedEvent;
import io.intercom.android.sdk.models.Events.Failure.ReplyFailedEvent;
import io.intercom.android.sdk.models.Events.Failure.UploadFailedEvent;
import io.intercom.android.sdk.models.Events.InboxEvent;
import io.intercom.android.sdk.models.Events.NewConversationEvent;
import io.intercom.android.sdk.models.Events.ReplyEvent;
import io.intercom.android.sdk.models.Events.UnreadConversationsEvent;
import io.intercom.android.sdk.models.Events.UploadEvent;
import io.intercom.android.sdk.models.Events.realtime.NewCommentEvent;
import io.intercom.android.sdk.models.LWR;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.nexus.NexusEvent;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.utilities.NameUtils;
import io.intercom.android.sdk.views.AdminIsTypingView;
import io.intercom.android.sdk.views.ConversationListView;
import io.intercom.com.squareup.otto.Subscribe;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

@TargetApi(value=15)
public class ConversationFragment
extends BaseConversationFragment
implements View.OnClickListener,
AdapterView.OnItemClickListener {
    public static final String ARG_UNREAD_COUNT = "intercomsdk-unreadCount";
    public static final String ARG_IS_READ = "intercomsdk-isRead";
    private static final String INTERCOM_INBOUND_URL = "http://www.intercom.io/?utm_source=android-sdk&utm_medium=inbound&utm_campaign=powered-by-intercom";
    private static final String INTERCOM_OUTBOUND_URL = "http://www.intercom.io/?utm_source=android-sdk&utm_medium=outbound&utm_campaign=powered-by-intercom";
    private static final String ARG_CONVERSATION_ID = "conversationId";
    private static final int DELIVERED_TIMER = 10000;
    private static final int ACTIVITY_RESULT_UPLOAD_SELECTED = 1;
    private static final int ACTIVITY_RESULT_UPLOAD_CONFIRMED = 2;
    private static final int REQUEST_READ_EXTERNAL_STORAGE = 1;
    private final Set<String> currentTypers = new HashSet<String>();
    private final List<Part> sendingFailures = new ArrayList<Part>();
    protected View rootView;
    protected ComposerInputView composer;
    private ConversationListView conversationList;
    private TextView conversationTitleText;
    private LinearLayout loadingLayout;
    private Button unreadText;
    private Conversation conversation;
    private TextView pill;
    private ImageButton inboxButton;
    private int unreadCount = 0;
    private SpoolWrapper spool;
    private Future timestampUpdateFuture;

    public static ConversationFragment newInstance(String conversationId, int unreadCount, boolean isRead) {
        ConversationFragment frag = new ConversationFragment();
        Bundle args = new Bundle();
        args.putString(ARG_CONVERSATION_ID, conversationId);
        args.putInt(ARG_UNREAD_COUNT, unreadCount);
        args.putBoolean(ARG_IS_READ, isRead);
        frag.setArguments(args);
        return frag;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null) {
            this.conversationId = args.getString(ARG_CONVERSATION_ID, "");
            this.unreadCount = args.getInt(ARG_UNREAD_COUNT, 0);
            boolean isRead = args.getBoolean(ARG_IS_READ, false);
            if (!isRead) {
                --this.unreadCount;
            }
        }
        this.conversationParts = new ArrayList();
        this.conversation = new Conversation();
        this.spool = new SpoolWrapper((Context)this.getActivity());
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.rootView == null) {
            this.rootView = inflater.inflate(R.layout.intercomsdk_fragment_conversation, container, false);
        } else {
            ViewGroup parent = (ViewGroup)this.rootView.getParent();
            if (parent != null) {
                parent.removeView(this.rootView);
            }
        }
        this.unreadText = (Button)this.rootView.findViewById(R.id.unread_text);
        this.loadingLayout = (LinearLayout)this.rootView.findViewById(R.id.loading_layout);
        this.conversationTitleText = (TextView)this.rootView.findViewById(R.id.conversation_title_text);
        this.pill = (TextView)this.rootView.findViewById(R.id.pill);
        this.pill.setOnClickListener((View.OnClickListener)this);
        this.conversationList = (ConversationListView)this.rootView.findViewById(R.id.conversation_list);
        this.conversationList.setOnBottomReachedListener(new ConversationListView.OnBottomReachedListener(){

            @Override
            public void onBottomReached() {
                ConversationFragment.this.pill.setVisibility(8);
            }
        });
        GradientDrawable background = (GradientDrawable)this.unreadText.getBackground();
        background.setColor(Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor()));
        this.blocks = new Blocks(this.getActivity().getApplicationContext());
        ImageButton closeButton = (ImageButton)this.rootView.findViewById(R.id.close_composer_button);
        this.inboxButton = (ImageButton)this.rootView.findViewById(R.id.inbox_button);
        closeButton.setOnClickListener((View.OnClickListener)this);
        this.inboxButton.setOnClickListener((View.OnClickListener)this);
        this.conversationList.setOnItemClickListener(this);
        FontUtils.setTypeface(this.conversationTitleText, "intercomsdk_roboto_medium.ttf", (Context)this.getActivity());
        this.adapter = new ConversationAdapter((Context)this.getActivity(), R.layout.intercomsdk_row_user_part, this.conversationParts);
        this.conversationList.setAdapter((ListAdapter)this.adapter);
        Bridge.getBus().register((Object)this);
        this.composer = (ComposerInputView)this.rootView.findViewById(R.id.composer_input_view);
        this.setupComposer();
        this.updateUnreadCount(this.unreadCount);
        return this.rootView;
    }

    public void onStart() {
        super.onStart();
        if (!this.conversationId.isEmpty()) {
            Bridge.getPoller().startConversationPolling(this.conversationId);
        }
    }

    public void onStop() {
        super.onStop();
        if (!this.conversationId.isEmpty()) {
            Bridge.getPoller().endConversationPolling();
        }
    }

    public void onDestroyView() {
        Bridge.getBus().unregister((Object)this);
        if (this.timestampUpdateFuture != null) {
            this.timestampUpdateFuture.cancel(true);
        }
        this.composer.cleanup();
        super.onDestroyView();
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.inbox_button) {
            view.setEnabled(false);
            this.inboxTapped();
        } else if (id2 == R.id.close_composer_button) {
            this.closeTapped();
        } else if (id2 == R.id.pill) {
            this.conversationList.smoothScrollToPosition(this.conversationList.getBottom());
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Part part = (Part)this.conversationParts.get(position);
        if ("intercom_powered_by".equals(part.getMessageStyle())) {
            String poweredByUrl = INTERCOM_OUTBOUND_URL;
            Part firstPart = (Part)this.conversationParts.get(0);
            if ("intercom_welcome_message".equals(firstPart.getMessageStyle()) || !firstPart.isAdmin()) {
                poweredByUrl = INTERCOM_INBOUND_URL;
            }
            Uri uri = Uri.parse((String)poweredByUrl);
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            intent.setFlags(0x10000000);
            this.startActivity(intent);
        } else if (part.getMessageState() == Part.MessageState.FAILED) {
            part.setMessageState(Part.MessageState.SENDING);
            part.setFooter(this.getString(R.string.intercomsdk_sending));
            this.conversationParts.remove(this.conversationParts.indexOf(part));
            this.conversationParts.add(this.conversationParts.size(), part);
            this.adapter.notifyDataSetChanged();
            String partText = part.getBlocks().get(0).getText();
            if (TextUtils.isEmpty((CharSequence)this.conversationId)) {
                this.startConversation(partText, part.getId());
            } else {
                this.replyToConversation(partText, part, this.conversationParts.size() - 1);
            }
        } else if (part.getMessageState() == Part.MessageState.UPLOAD_FAILED) {
            part.setMessageState(Part.MessageState.SENDING);
            part.setFooter(this.getString(R.string.intercomsdk_sending));
            this.conversationParts.remove(this.conversationParts.indexOf(part));
            this.conversationParts.add(this.conversationParts.size(), part);
            this.adapter.notifyDataSetChanged();
            this.uploadFile(part.getFileUri(), part.getId());
        }
    }

    @Override
    protected void closeTapped() {
        this.composer.hideKeyboard();
        super.closeTapped();
    }

    private void inboxTapped() {
        this.composer.hideKeyboard();
        this.listener.loadInbox();
    }

    private void sendTapped() {
        String text = this.composer.getTrimmedText();
        if (!text.isEmpty()) {
            Part message = this.createSendingUI(text);
            this.spool.playReplySendingSound();
            if (TextUtils.isEmpty((CharSequence)this.conversationId)) {
                this.startConversation(text, message.getId());
                this.composer.clear();
            } else {
                this.replyToConversation(text, message, this.conversationParts.size() - 1);
                this.composer.clear();
            }
            this.conversationList.smoothScrollToPosition(this.conversationList.getBottom());
        }
    }

    private void attachmentTapped() {
        if (!DeviceUtils.hasPermission((Context)this.getActivity(), (String)"android.permission.READ_EXTERNAL_STORAGE")) {
            if (Build.VERSION.SDK_INT > 22) {
                this.requestPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 1);
            }
        } else {
            this.launchContentSelector();
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == 1) {
            if (grantResults[0] == 0) {
                this.launchContentSelector();
            }
        } else {
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (-1 == resultCode) {
            switch (requestCode) {
                case 1: {
                    Intent intent = new Intent((Context)this.getActivity(), AttachmentActivity.class);
                    intent.setData(data.getData());
                    this.startActivityForResult(intent, 2);
                    break;
                }
                case 2: {
                    this.uploadFile(data.getData(), "");
                }
            }
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    private void launchContentSelector() {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("*/*");
        this.startActivityForResult(intent, 1);
    }

    private void uploadFile(Uri uri, String id2) {
        if (uri != null) {
            new LoadFileTask().execute(new Object[]{uri, id2});
        }
    }

    private Part createAttachmentBlock(String name, String url, String contentType, int width, int height, Uri fileUri) {
        ArrayList<BlockAttachment> attachments = new ArrayList<BlockAttachment>();
        ArrayList<Block> blockParts = new ArrayList<Block>();
        Participant user = this.getParticipant();
        Part message = new Part();
        if (contentType.contains(Image.MIME_TYPE)) {
            Block block = new Block.Builder().withUrl(url).withType(BlockType.LOCALIMAGE.name()).withWidth(width).withHeight(height).build();
            blockParts.add(block);
            message.isImageOnly(true);
        } else {
            attachments.add(new BlockAttachment.Builder().withName(name).withUrl(url).withContentType(contentType).build());
            Block block = new Block.Builder().withAttachments(attachments).withType(BlockType.LOCAL_ATTACHMENT.name()).build();
            blockParts.add(block);
        }
        message.setMessageStyle("chat");
        message.setMessageState(Part.MessageState.SENDING);
        message.setParticipant(user);
        message.setBlocks(blockParts);
        message.setFooter(this.getString(R.string.intercomsdk_sending));
        message.setCreatedAt(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()));
        message.setLayout(this.blocks.createBlocks(blockParts, this.generator.getPreviewHolder()));
        message.setAttachments(new ArrayList<Attachments>());
        message.setId(UUID.randomUUID().toString());
        message.setEntranceAnimation(true);
        message.setShowCreatedAt(true);
        message.setFileUri(fileUri);
        if (this.conversationParts.size() == 1 && ((Part)this.conversationParts.get(0)).getMessageStyle().equals("intercom_powered_by")) {
            this.conversationParts.add(0, message);
        } else {
            this.conversationParts.add(this.conversationParts.size(), message);
        }
        this.sendingFailures.add(message);
        this.adapter.notifyDataSetChanged();
        this.conversationList.smoothScrollToPosition(this.conversationList.getBottom());
        return message;
    }

    private void setupComposer() {
        this.composer.requestInputFocus();
        this.configureInputView(this.conversation);
        if (this.conversationId.isEmpty()) {
            this.addWelcomeMessage();
            if (!this.hasPoweredBy(this.conversationParts) && Bridge.getIdentityStore().getAppConfig().isShowPoweredBy()) {
                this.addPoweredBy(false);
            }
            this.conversationList.setVisibility(0);
            this.conversationTitleText.setText(R.string.intercomsdk_new_conversation_title);
            this.composer.setHint(R.string.intercomsdk_start_new_conversation);
        } else {
            this.composer.setConversationId(this.conversationId);
            Bridge.getApi().getConversation(this.conversationId);
            this.loadingLayout.setVisibility(0);
            ((ProgressBar)this.loadingLayout.findViewById(R.id.progressBar)).getIndeterminateDrawable().setColorFilter(Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor()), PorterDuff.Mode.SRC_IN);
            this.conversationList.setVisibility(0);
            this.composer.setVisibility(8);
            this.rootView.findViewById(R.id.bottom_shadow).setVisibility(8);
            this.adapter.notifyDataSetChanged();
        }
    }

    private void updateUnreadCount(int count) {
        if (count <= 0) {
            this.unreadText.setVisibility(8);
            this.inboxButton.setImageResource(R.drawable.intercomsdk_inbox_button_selector);
        } else {
            this.unreadText.setVisibility(0);
            this.unreadText.setText((CharSequence)String.valueOf(count));
            this.inboxButton.setImageResource(R.drawable.intercomsdk_inbox_button_badge_selector);
        }
    }

    private void startConversation(String text, String partId) {
        Bridge.getApi().startNewConversation(text, this.conversationParts.size() - 1, partId);
    }

    private void startConversationWithAttachment(int uploadId, String partId) {
        Bridge.getApi().startNewAttachmentConversation(uploadId, this.conversationParts.size() - 1, partId);
    }

    private void replyToConversation(String text, Part part, int partPosition) {
        Bridge.getApi().textReply(this.conversationId, text, partPosition, part.getId());
    }

    private void attachmentToConversation(Part part, int partPosition, int uploadId) {
        Bridge.getApi().attachmentReply(this.conversationId, uploadId, partPosition, part.getId());
    }

    @Subscribe
    public void conversationSuccess(ConversationEvent event) {
        int conversationSize = this.conversation.getParts().size();
        List<Part> eventParts = event.getResponse().getParts();
        if (!eventParts.isEmpty() && eventParts.get(0).isAdmin()) {
            eventParts.get(0).setFirstChatPart(true);
        }
        if (event.getResponse().getId().equals(this.conversationId) && eventParts.size() > conversationSize) {
            this.conversation = event.getResponse();
            if (this.isAdded()) {
                this.setupWithConversation();
            }
            if (!this.conversation.getRead().booleanValue()) {
                this.markAsRead();
                Bridge.getNexusClient().fire(NexusEvent.getConversationSeenEvent((String)this.conversationId, (String)Bridge.getIdentityStore().getIntercomId()));
            }
            if (!this.conversationList.isAtBottom()) {
                if (conversationSize != 0) {
                    this.pill.setVisibility(0);
                }
            } else {
                this.conversationList.smoothScrollToPosition(this.conversationList.getBottom());
            }
            if (conversationSize != 0) {
                List<Part> newParts = eventParts.subList(conversationSize, eventParts.size());
                for (Part p : newParts) {
                    if (!p.isAdmin()) continue;
                    this.spool.playAdminReplySound();
                    break;
                }
                Bridge.getBus().post((Object)new CancelAdminTypingEvent());
                this.currentTypers.clear();
            }
            this.adapter.sort(new Comparator<Part>(){

                @Override
                public int compare(Part lhs, Part rhs) {
                    return (int)(lhs.getCreatedAt() - rhs.getCreatedAt());
                }
            });
        }
    }

    @Subscribe
    public void conversationFailure(ConversationFailedEvent event) {
    }

    @Subscribe
    public void newConversationSuccess(NewConversationEvent event) {
        if (!this.conversationParts.isEmpty() && ((Part)this.conversationParts.get(this.conversationParts.size() - 1)).getId().equals(event.getIdentifier())) {
            this.conversation = event.getResponse();
            this.conversationId = this.conversation.getId();
            this.conversationParts.remove(this.conversationParts.size() - 1);
            Part newPart = this.createMessageUI(event.getResponse().getParts().get(0));
            this.conversationParts.add(newPart);
            this.composer.setConversationId(this.conversationId);
            Bridge.getPoller().startConversationPolling(this.conversationId);
            Bridge.getNexusClient().fire(NexusEvent.getCreateConversationEvent((String)this.conversationId, (String)Bridge.getIdentityStore().getIntercomId()));
            if (!this.hasPoweredBy(this.conversationParts) && Bridge.getIdentityStore().getAppConfig().isShowPoweredBy()) {
                this.addPoweredBy(true);
            }
            this.spool.playReplySuccessSound();
            this.adapter.notifyDataSetChanged();
        }
    }

    @Subscribe
    public void newConversationFailure(NewConversationFailedEvent event) {
        this.markAsFailed(event.getPosition(), event.getPartId(), false);
    }

    @Subscribe
    public void replySuccess(ReplyEvent event) {
        if (event.getConversationId().equals(this.conversationId)) {
            Bridge.getNexusClient().fire(NexusEvent.getNewCommentEvent((String)this.conversationId, (String)Bridge.getIdentityStore().getIntercomId()));
            Part response = event.getResponse();
            Participant participant = this.conversation.getParticipant(response.getParticipantId());
            if (participant instanceof Participant.NullParticipant) {
                participant = new Participant.Builder().withId(response.getParticipantId()).build();
                this.conversation.getParticipants().put(response.getParticipantId(), participant);
            }
            response.setParticipant(participant);
            int position = this.positionOfTempPart(event.getPosition(), event.getPartId());
            if (position >= 0) {
                this.sendingFailures.remove(this.conversationParts.remove(position));
            }
            final Part newPart = this.createMessageUI(response);
            newPart.setDisplayDelivered(true);
            this.conversationParts.add(this.conversationParts.size(), newPart);
            this.adapter.notifyDataSetChanged();
            this.spool.playReplySuccessSound();
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    newPart.setDisplayDelivered(false);
                    ConversationFragment.this.adapter.notifyDataSetChanged();
                }
            }, 10000L);
        }
    }

    @Subscribe
    public void replyFailure(ReplyFailedEvent event) {
        this.markAsFailed(event.getPosition(), event.getPartId(), event.isUpload());
        this.spool.playReplyFailSound();
    }

    @Subscribe
    public void uploadSuccess(UploadEvent event) {
        int partPosition = this.positionOfTempPart(event.getTempPartPosition(), event.getTempPartId());
        if (partPosition >= 0) {
            if (TextUtils.isEmpty((CharSequence)this.conversationId)) {
                this.startConversationWithAttachment(event.getUploadId(), event.getTempPartId());
            } else {
                this.attachmentToConversation((Part)this.conversationParts.get(partPosition), partPosition, event.getUploadId());
            }
        }
    }

    @Subscribe
    public void uploadFailure(UploadFailedEvent event) {
        this.markAsFailed(event.getPosition(), event.getPartId(), true);
        this.spool.playReplyFailSound();
    }

    private void markAsFailed(int position, String partId, boolean uploadFailed) {
        int partPosition = this.positionOfTempPart(position, partId);
        if (partPosition >= 0) {
            Part failedPart = (Part)this.conversationParts.get(partPosition);
            failedPart.setMessageState(uploadFailed ? Part.MessageState.UPLOAD_FAILED : Part.MessageState.FAILED);
            failedPart.setFooter(this.getString(R.string.intercomsdk_sending_failure));
            this.adapter.notifyDataSetChanged();
        }
    }

    private int positionOfTempPart(int position, String partId) {
        if (position >= 0 && position < this.conversationParts.size()) {
            Part sendingPart = (Part)this.conversationParts.get(position);
            if (sendingPart.getId().equals(partId)) {
                return position;
            }
            for (int i = this.conversationParts.size() - 1; i >= 0; --i) {
                if (!((Part)this.conversationParts.get(i)).getId().equals(partId)) continue;
                return i;
            }
        }
        return -1;
    }

    private void setupWithConversation() {
        this.composer.setHint(R.string.intercomsdk_write_a_reply);
        this.conversationList.setVisibility(0);
        this.loadingLayout.setVisibility(8);
        this.createConversationUI(this.conversation.getParts());
        this.updateTimeStampScheduler();
    }

    private void addWelcomeMessage() {
        List<Block> welcomeBlocks = Bridge.getIdentityStore().getAppConfig().getWelcomeMessage();
        if (!welcomeBlocks.isEmpty()) {
            LinearLayout layout2 = this.blocks.createBlocks(welcomeBlocks, this.generator.getWelcomeHolder());
            ImageView infoImage = (ImageView)LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.intercomsdk_welcome_message_icon, (ViewGroup)layout2, false);
            layout2.addView((View)infoImage, 0);
            ImageView divider = (ImageView)LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.intercomsdk_rowdivider, (ViewGroup)layout2, false);
            layout2.addView((View)divider);
            Participant user = new Participant.Builder().build();
            Part part = new Part();
            part.setMessageStyle("intercom_welcome_message");
            part.setParticipant(user);
            part.setBlocks(welcomeBlocks);
            part.setLayout(layout2);
            part.setAttachments(new ArrayList<Attachments>());
            part.setId(UUID.randomUUID().toString());
            this.conversationParts.add(0, part);
            this.adapter.notifyDataSetChanged();
        }
    }

    protected void configureInputView(Conversation conversation) {
        if (!conversation.getParts().isEmpty() && conversation.getParts().size() == 1 && !(conversation.getParts().get(0).getLightweightReply() instanceof LWR.NullLWR)) {
            this.composer.setVisibility(8);
            this.rootView.findViewById(R.id.bottom_shadow).setVisibility(8);
        } else {
            this.composer.setVisibility(0);
            this.composer.requestInputFocus();
            this.rootView.findViewById(R.id.bottom_shadow).setVisibility(0);
        }
    }

    private void createConversationUI(List<Part> parts) {
        ArrayList<Participant> admins = new ArrayList<Participant>();
        this.conversationParts.clear();
        for (Part part : parts) {
            if (part.getLayout() == null) {
                part = this.createMessageUI(part);
            }
            this.conversationParts.add(this.conversationParts.size(), part);
            if (!"admin".equals(part.getParticipant().getType()) || part.getParticipantId().equals(Bridge.getIdentityStore().getIntercomId())) continue;
            admins.add(part.getParticipant());
        }
        if (!parts.isEmpty() && "user".equals(parts.get(0).getParticipant().getType()) && !parts.get(0).getMessageStyle().equals("intercom_welcome_message")) {
            this.addWelcomeMessage();
        }
        if (!this.hasPoweredBy(parts) && Bridge.getIdentityStore().getAppConfig().isShowPoweredBy()) {
            this.addPoweredBy(false);
        }
        this.conversationParts.addAll(this.sendingFailures);
        if (parts.get(parts.size() - 1).isFirstChatPart()) {
            this.conversationList.setSelection(0);
        } else {
            this.conversationList.setSelection(this.conversationParts.size() - 1);
        }
        this.configureInputView(this.conversation);
        this.adapter.notifyDataSetChanged();
        this.conversationList.setVisibility(0);
        this.updateTitle(admins);
    }

    private Part createSendingUI(String text) {
        ArrayList<Block> blockParts = new ArrayList<Block>();
        Block block = new Block.Builder().withText(text).withType(BlockType.PARAGRAPH.name()).build();
        blockParts.add(block);
        Participant user = this.getParticipant();
        Part message = new Part();
        message.setMessageStyle("chat");
        message.setMessageState(Part.MessageState.SENDING);
        message.setParticipant(user);
        message.setBlocks(blockParts);
        message.setFooter(this.getString(R.string.intercomsdk_sending));
        message.setCreatedAt(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()));
        message.setLayout(this.blocks.createBlocks(blockParts, this.generator.getPreviewHolder()));
        message.setAttachments(new ArrayList<Attachments>());
        message.setId(UUID.randomUUID().toString());
        message.setEntranceAnimation(true);
        message.setShowCreatedAt(true);
        if (this.conversationParts.size() == 1 && ((Part)this.conversationParts.get(0)).getMessageStyle().equals("intercom_powered_by")) {
            this.conversationParts.add(0, message);
        } else {
            this.conversationParts.add(this.conversationParts.size(), message);
        }
        this.sendingFailures.add(message);
        this.adapter.notifyDataSetChanged();
        return message;
    }

    private void updateTitle(List<Participant> admins) {
        LinkedHashSet<String> uniqueAdminIds = new LinkedHashSet<String>();
        ArrayList<String> adminNames = new ArrayList<String>();
        for (int i = admins.size() - 1; i >= 0; --i) {
            Participant user = admins.get(i);
            if (uniqueAdminIds.contains(user.getId())) continue;
            adminNames.add(user.getDisplayName());
            uniqueAdminIds.add(user.getId());
        }
        this.conversationTitleText.setText((CharSequence)NameUtils.getFormattedAdmins(adminNames, (Context)this.getActivity()));
    }

    protected int getInputViewVisibility() {
        return this.composer.getVisibility();
    }

    @Subscribe
    public void inboxCallback(InboxEvent event) {
        int newUnreadCount = this.filterCurrentConversation(event.getResponse().getTotalUnreadCount(), event.getResponse().getConversations());
        this.updateUnreadCount(newUnreadCount);
    }

    @Subscribe
    public void previewServiceCallback(UnreadConversationsEvent event) {
        int newUnreadCount = this.filterCurrentConversation(event.getResponse().getTotalUnreadCount(), event.getResponse().getConversations());
        this.updateUnreadCount(newUnreadCount);
    }

    private int filterCurrentConversation(int newUnreadCount, List<Conversation> conversations) {
        for (Conversation c : conversations) {
            if (!c.getId().equals(this.conversationId) || c.getRead().booleanValue()) continue;
            --newUnreadCount;
            break;
        }
        return newUnreadCount;
    }

    private boolean hasPoweredBy(List<Part> parts) {
        for (Part part : parts) {
            if (!part.getMessageStyle().equals("intercom_powered_by")) continue;
            return true;
        }
        return false;
    }

    private void addPoweredBy(boolean shouldAnimate) {
        if (!this.conversationParts.isEmpty()) {
            Part poweredBy = new Part();
            poweredBy.setEntranceAnimation(shouldAnimate);
            poweredBy.setMessageStyle("intercom_powered_by");
            poweredBy.setCreatedAt(((Part)this.conversationParts.get(0)).getCreatedAt() + 1L);
            this.conversationParts.add(1, poweredBy);
        }
    }

    private void updateTimeStampScheduler() {
        this.timestampUpdateFuture = Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ConversationFragment.this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ConversationFragment.this.adapter.notifyDataSetChanged();
                    }
                });
            }
        }, 0L, 1L, TimeUnit.MINUTES);
    }

    private Participant getParticipant() {
        String intercomId = Bridge.getIdentityStore().getIntercomId();
        Participant user = this.conversation.getParticipant(intercomId);
        if (user instanceof Participant.NullParticipant) {
            user = new Participant.Builder().withId(intercomId).build();
        }
        return user;
    }

    @Subscribe
    public void newComment(NewCommentEvent event) {
        if (event.getConversationId().equals(this.conversationId) && event.getUserId().equals(Bridge.getIdentityStore().getIntercomId())) {
            if (Bridge.getIdentityStore().getAppConfig().isRealTime()) {
                Bridge.getApi().getConversation(this.conversationId);
                Bridge.getPoller().resetConversationPoll();
            } else {
                Bridge.getPoller().throttledConversationPoll(this.conversationId);
            }
        }
    }

    @Subscribe
    public void adminIsTyping(AdminIsTypingEvent event) {
        if (this.conversationId.equals(event.getConversationId())) {
            Bridge.getPoller().resetConversationPoll();
            if (!this.currentTypers.contains(event.getAdminId())) {
                Part isTypingPart = new Part();
                Participant participant = this.conversation.getParticipant(event.getAdminId());
                if (participant instanceof Participant.NullParticipant) {
                    participant = new Participant.Builder().withId(event.getAdminId()).withName(event.getAdminName()).withAvatar(new Avatar.Builder().withImageUrl(event.getAdminAvatarUrl())).withType("admin").build();
                }
                isTypingPart.setParticipant(participant);
                isTypingPart.setMessageStyle("admin_is_typing_style");
                isTypingPart.setId(UUID.randomUUID().toString());
                isTypingPart.setEntranceAnimation(true);
                LinearLayout contentLayout = (LinearLayout)View.inflate((Context)this.getActivity().getApplicationContext(), (int)R.layout.intercomsdk_blocks_admin_layout, null);
                AdminIsTypingView adminIsTypingView = new AdminIsTypingView(this.getActivity().getApplicationContext(), event.getAdminId(), this.conversationId, isTypingPart.getId());
                contentLayout.addView((View)adminIsTypingView);
                isTypingPart.setLayout(contentLayout);
                int index = this.conversationParts.isEmpty() ? 0 : this.conversationParts.size();
                this.conversationParts.add(index, isTypingPart);
                this.adapter.notifyDataSetChanged();
                this.currentTypers.add(event.getAdminId());
                if (this.conversationList.isAtBottom()) {
                    this.conversationList.smoothScrollToPosition(this.conversationList.getBottom());
                }
            }
        }
    }

    @Subscribe
    public void adminIsntTyping(AdminTypingEndedEvent event) {
        int position = this.positionOfTempPart(this.conversationParts.size() - 1, event.getPartId());
        if (position >= 0) {
            this.currentTypers.remove(event.getAdminId());
            this.conversationParts.remove(position);
            this.adapter.notifyDataSetChanged();
        }
    }

    @Subscribe
    public void sendMessage(SendingEvent event) {
        if (event.isAttachment()) {
            this.attachmentTapped();
        } else {
            this.sendTapped();
        }
    }

    private class LoadFileTask
    extends AsyncTask<Object, Void, AttachmentData> {
        private LoadFileTask() {
        }

        protected AttachmentData doInBackground(Object ... params) {
            return new AttachmentData((Uri)params[0], (String)params[1], ConversationFragment.this.getActivity());
        }

        protected void onPostExecute(AttachmentData data) {
            UploadProgressListener listener;
            String id2 = data.getId();
            if (id2.isEmpty()) {
                Part message = ConversationFragment.this.createAttachmentBlock(data.getFileName(), data.getPath(), data.getMimeType(), data.getImageWidth(), data.getImageHeight(), data.getUri());
                ConversationFragment.this.spool.playReplySendingSound();
                id2 = message.getId();
                listener = (UploadProgressListener)message.getLayout().getChildAt(0);
            } else {
                int i = ConversationFragment.this.positionOfTempPart(ConversationFragment.this.conversationParts.size() - 1, id2);
                listener = i >= 0 ? (UploadProgressListener)((Part)ConversationFragment.this.conversationParts.get(i)).getLayout().getChildAt(0) : new UploadProgressListener(){

                    @Override
                    public void uploadNotice(byte percentUploaded) {
                    }
                };
            }
            Bridge.getApi().uploadFile(data.getFile(), data.getFileName(), data.getSize(), data.getMimeType(), data.getImageWidth(), data.getImageHeight(), ConversationFragment.this.conversationParts.size() - 1, id2, listener, (Context)ConversationFragment.this.getActivity());
        }
    }
}

