/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.squareup.okhttp;

import io.intercom.com.squareup.okhttp.MediaType;
import io.intercom.com.squareup.okhttp.internal.Util;
import io.intercom.okio.Buffer;
import io.intercom.okio.BufferedSource;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public abstract class ResponseBody
implements Closeable {
    private Reader reader;

    public abstract MediaType contentType();

    public abstract long contentLength() throws IOException;

    public final InputStream byteStream() throws IOException {
        return this.source().inputStream();
    }

    public abstract BufferedSource source() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] bytes() throws IOException {
        byte[] bytes;
        long contentLength = this.contentLength();
        if (contentLength > Integer.MAX_VALUE) {
            throw new IOException("Cannot buffer entire body for content length: " + contentLength);
        }
        BufferedSource source = this.source();
        try {
            bytes = source.readByteArray();
        }
        finally {
            Util.closeQuietly(source);
        }
        if (contentLength != -1L && contentLength != (long)bytes.length) {
            throw new IOException("Content-Length and stream length disagree");
        }
        return bytes;
    }

    public final Reader charStream() throws IOException {
        Reader r = this.reader;
        return r != null ? r : (this.reader = new InputStreamReader(this.byteStream(), this.charset()));
    }

    public final String string() throws IOException {
        return new String(this.bytes(), this.charset().name());
    }

    private Charset charset() {
        MediaType contentType = this.contentType();
        return contentType != null ? contentType.charset(Util.UTF_8) : Util.UTF_8;
    }

    @Override
    public void close() throws IOException {
        this.source().close();
    }

    public static ResponseBody create(MediaType contentType, String content) {
        Charset charset = Util.UTF_8;
        if (contentType != null && (charset = contentType.charset()) == null) {
            charset = Util.UTF_8;
            contentType = MediaType.parse(contentType + "; charset=utf-8");
        }
        Buffer buffer = new Buffer().writeString(content, charset);
        return ResponseBody.create(contentType, buffer.size(), buffer);
    }

    public static ResponseBody create(MediaType contentType, byte[] content) {
        Buffer buffer = new Buffer().write(content);
        return ResponseBody.create(contentType, content.length, buffer);
    }

    public static ResponseBody create(final MediaType contentType, final long contentLength, final BufferedSource content) {
        if (content == null) {
            throw new NullPointerException("source == null");
        }
        return new ResponseBody(){

            @Override
            public MediaType contentType() {
                return contentType;
            }

            @Override
            public long contentLength() {
                return contentLength;
            }

            @Override
            public BufferedSource source() {
                return content;
            }
        };
    }
}

