/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.squareup.okhttp;

import io.intercom.com.squareup.okhttp.HttpUrl;
import io.intercom.com.squareup.okhttp.MediaType;
import io.intercom.com.squareup.okhttp.RequestBody;
import io.intercom.okio.Buffer;

public final class FormEncodingBuilder {
    private static final MediaType CONTENT_TYPE = MediaType.parse("application/x-www-form-urlencoded");
    private final Buffer content = new Buffer();

    public FormEncodingBuilder add(String name, String value) {
        if (this.content.size() > 0L) {
            this.content.writeByte(38);
        }
        HttpUrl.canonicalize(this.content, name, 0, name.length(), " \"'<>#&=", false, true);
        this.content.writeByte(61);
        HttpUrl.canonicalize(this.content, value, 0, value.length(), " \"'<>#&=", false, true);
        return this;
    }

    public FormEncodingBuilder addEncoded(String name, String value) {
        if (this.content.size() > 0L) {
            this.content.writeByte(38);
        }
        HttpUrl.canonicalize(this.content, name, 0, name.length(), " \"'<>#&=", true, true);
        this.content.writeByte(61);
        HttpUrl.canonicalize(this.content, value, 0, value.length(), " \"'<>#&=", true, true);
        return this;
    }

    public RequestBody build() {
        if (this.content.size() == 0L) {
            throw new IllegalStateException("Form encoded body must have at least one part.");
        }
        return RequestBody.create(CONTENT_TYPE, this.content.snapshot());
    }
}

