/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.animation.AnimatorInflater;
import android.animation.ObjectAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.ScreenUtils;
import io.intercom.android.sdk.utilities.TimeUtils;
import io.intercom.android.sdk.views.AdminIsTypingView;
import java.util.List;
import java.util.concurrent.TimeUnit;

@TargetApi(value=14)
public class ConversationAdapter
extends ArrayAdapter<Part> {
    private static final int USER_MESSAGE = 0;
    private static final int ADMIN_MESSAGE = 1;
    private static final int ADMIN_MESSAGE_FIRST = 2;
    private static final int ANNOUNCEMENT_TYPE = 3;
    private static final int POWERED_BY = 4;
    private static final int WELCOME = 5;
    private static final int ALT_USER_MESSAGE = 6;
    private static final int ADMIN_IS_TYPING = 7;
    private static final int MAX_TYPE = 8;
    private static final int UPLOAD_RIGHT_PADDING_DP = 13;
    private static final int UPLOAD_LEFT_PADDING_DP = 14;

    public ConversationAdapter(Context context, int layoutResourceId, List<Part> conversationParts) {
        super(context, layoutResourceId, conversationParts);
    }

    public View getBlockView(int position, View row, ViewGroup parent) {
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        if (this.isWithinBounds(position)) {
            int type = this.getItemViewType(position);
            Part conversationPart = (Part)this.getItem(position);
            if (type == 4) {
                row = inflater.inflate(R.layout.intercomsdk_row_poweredby, parent, false);
                this.checkForEntranceAnimation(row, type, conversationPart);
            } else if (type == 5) {
                row = inflater.inflate(R.layout.intercomsdk_row_welcome, parent, false);
                this.setUpWelcomeRow(row, conversationPart);
            } else {
                boolean shouldConcatenate = this.shouldConcatenate(conversationPart, position);
                conversationPart.setShowCreatedAt(conversationPart.showCreatedAt() && !shouldConcatenate);
                ConversationHolder holder = new ConversationHolder();
                if (row == null || !(row.getTag() instanceof ConversationHolder)) {
                    row = this.setUpRow(inflater, parent, type, shouldConcatenate);
                    holder.time = (TextView)row.findViewById(R.id.rowTime);
                    holder.networkAvatar = (ImageView)row.findViewById(R.id.avatarView);
                    holder.cellLayout = (LinearLayout)row.findViewById(R.id.cellLayout);
                    holder.blocks = conversationPart.getLayout();
                    if (holder.blocks.getParent() != null) {
                        ((LinearLayout)holder.blocks.getParent()).removeView((View)holder.blocks);
                    }
                    holder.cellLayout.addView((View)holder.blocks, 0);
                    row.setFocusable(false);
                    row.setTag((Object)holder);
                } else {
                    holder = (ConversationHolder)row.getTag();
                }
                this.setUpHolderBlocks(holder, type, row, conversationPart, shouldConcatenate);
                this.setupHolderBackground(holder, type, conversationPart, position, shouldConcatenate);
                this.checkForEntranceAnimation(holder, type, conversationPart);
            }
        }
        if (row == null) {
            row = inflater.inflate(R.layout.intercomsdk_row_welcome, parent, false);
        }
        return row;
    }

    public View getView(int position, View row, ViewGroup parent) {
        return this.getBlockView(position, row, parent);
    }

    public int getViewTypeCount() {
        return 8;
    }

    public int getItemViewType(int position) {
        int type = 0;
        if (this.isWithinBounds(position)) {
            Part conversationPart = (Part)this.getItem(position);
            if ("intercom_powered_by".equals(conversationPart.getMessageStyle())) {
                return 4;
            }
            if ("intercom_welcome_message".equals(conversationPart.getMessageStyle())) {
                return 5;
            }
            if ("admin_is_typing_style".equals(conversationPart.getMessageStyle())) {
                return 7;
            }
            Participant user = conversationPart.getParticipant();
            if ("admin".equals(user.getType())) {
                type = "announcement".equals(conversationPart.getMessageStyle()) || "small-announcement".equals(conversationPart.getMessageStyle()) ? 3 : (conversationPart.isFirstChatPart() ? 2 : 1);
            } else if (!user.getId().equals(Bridge.getIdentityStore().getIntercomId())) {
                type = 6;
            }
        }
        return type;
    }

    public boolean isEnabled(int position) {
        if (this.isWithinBounds(position)) {
            Part conversationPart = (Part)this.getItem(position);
            return Part.MessageState.FAILED == conversationPart.getMessageState() || Part.MessageState.UPLOAD_FAILED == conversationPart.getMessageState() || "intercom_powered_by".equals(conversationPart.getMessageStyle());
        }
        return false;
    }

    private boolean shouldConcatenate(Part conversationPart, int position) {
        Part nextPart;
        long diff;
        boolean concatenate = false;
        if (position + 1 < this.getCount() && (diff = Math.abs((nextPart = (Part)this.getItem(position + 1)).getCreatedAt() - conversationPart.getCreatedAt())) < TimeUnit.MINUTES.toSeconds(1L) && conversationPart.getParticipantId().equals(nextPart.getParticipantId()) && nextPart.getCreatedAt() != 0L) {
            concatenate = true;
        }
        return concatenate;
    }

    private View setUpRow(LayoutInflater inflater, ViewGroup parent, int type, boolean isConcat) {
        View row = type == 1 || type == 6 || type == 7 ? inflater.inflate(R.layout.intercomsdk_row_admin_part, parent, false) : (type == 2 ? inflater.inflate(R.layout.intercomsdk_row_admin_part_first, parent, false) : (type == 3 ? inflater.inflate(R.layout.intercomsdk_row_big_announcement, parent, false) : (isConcat ? inflater.inflate(R.layout.intercomsdk_row_user_part_concat, parent, false) : inflater.inflate(R.layout.intercomsdk_row_user_part, parent, false))));
        return row;
    }

    private void setUpHolderBlocks(ConversationHolder holder, int type, View row, Part conversationPart, boolean shouldConcatenate) {
        holder.cellLayout.setVisibility(0);
        holder.blocks = conversationPart.getLayout();
        if (holder.blocks.getParent() != null) {
            ((LinearLayout)holder.blocks.getParent()).removeView((View)holder.blocks);
        }
        if (holder.cellLayout.getChildCount() > 0) {
            holder.cellLayout.removeAllViews();
        }
        holder.cellLayout.addView((View)holder.blocks, 0);
        this.setUpRowFocusRules(type, holder, row, conversationPart);
        this.setUpRowTime(type, holder, conversationPart, shouldConcatenate);
    }

    private void setUpRowFocusRules(int type, ConversationHolder holder, View row, Part conversationPart) {
        holder.blocks.setAlpha(1.0f);
        if (Part.MessageState.FAILED == conversationPart.getMessageState() || Part.MessageState.UPLOAD_FAILED == conversationPart.getMessageState()) {
            ((ViewGroup)row).setDescendantFocusability(393216);
            holder.blocks.setAlpha(0.5f);
        } else if (Part.MessageState.SENDING == conversationPart.getMessageState()) {
            ((ViewGroup)row).setDescendantFocusability(393216);
        } else {
            ((ViewGroup)row).setDescendantFocusability(262144);
        }
    }

    private void setUpRowTime(int type, ConversationHolder holder, Part conversationPart, boolean shouldConcatenate) {
        if (holder.time != null) {
            if (conversationPart.showCreatedAt()) {
                holder.time.setVisibility(0);
                holder.time.setPadding(0, 0, 0, ScreenUtils.convertDpToPixel(10.0f, this.getContext()));
                if (Part.MessageState.SENDING == conversationPart.getMessageState()) {
                    holder.time.setText((CharSequence)conversationPart.getFooter());
                    holder.time.setTextColor(this.getContext().getResources().getColor(R.color.intercomsdk_light_grey_colour));
                } else if (Part.MessageState.FAILED == conversationPart.getMessageState() || Part.MessageState.UPLOAD_FAILED == conversationPart.getMessageState()) {
                    holder.time.setText((CharSequence)conversationPart.getFooter());
                    holder.time.setTextColor(this.getContext().getResources().getColor(R.color.intercomsdk_red));
                } else {
                    this.displayDelivered(holder, conversationPart);
                    holder.time.setTextColor(this.getContext().getResources().getColor(R.color.intercomsdk_light_grey_colour));
                }
            } else if (!(shouldConcatenate || type != 3 && type != 2)) {
                holder.time.setVisibility(4);
                holder.time.setHeight(ScreenUtils.convertDpToPixel(10.0f, this.getContext()));
            } else {
                holder.time.setVisibility(8);
            }
        }
    }

    private void setupHolderBackground(ConversationHolder holder, int type, Part conversationPart, int position, boolean shouldConcatenate) {
        int pLeft = holder.blocks.getPaddingLeft();
        int pRight = holder.blocks.getPaddingRight();
        int pTop = holder.blocks.getPaddingTop();
        int pBottom = holder.blocks.getPaddingBottom();
        if (conversationPart.isImageOnly()) {
            holder.blocks.setBackgroundResource(0);
            pLeft = 0;
            pTop = 0;
            pBottom = 0;
            if (conversationPart.isAdmin()) {
                if (!shouldConcatenate) {
                    this.showAvatar(holder, position, conversationPart.getParticipant());
                }
                pLeft = 14;
            } else {
                pRight = 13;
            }
        } else if ((type == 0 || Part.MessageState.SENDING == conversationPart.getMessageState() || Part.MessageState.FAILED == conversationPart.getMessageState() || Part.MessageState.UPLOAD_FAILED == conversationPart.getMessageState()) && shouldConcatenate) {
            BackgroundUtils.setBackground((View)holder.blocks, this.getContext().getResources().getDrawable(R.drawable.intercomsdk_chat_bubble_right_aligned_notail));
            this.setCellRowColor(holder);
        } else if (type == 1 && shouldConcatenate) {
            BackgroundUtils.setBackground((View)holder.blocks, this.getContext().getResources().getDrawable(R.drawable.intercomsdk_chat_bubble_left_aligned_notail));
            holder.networkAvatar.setVisibility(4);
        } else {
            if (type == 2) {
                BackgroundUtils.setBackground((View)holder.blocks, this.getContext().getResources().getDrawable(R.drawable.intercomsdk_chat_bubble_left_aligned));
            }
            if ("admin".equals(conversationPart.getParticipant().getType()) || type == 6) {
                this.showAvatar(holder, position, conversationPart.getParticipant());
            } else {
                this.setCellRowColor(holder);
            }
        }
        holder.blocks.setPadding(pLeft, pTop, pRight, pBottom);
    }

    private void checkForEntranceAnimation(ConversationHolder holder, int type, Part part) {
        if (part.hasEntranceAnimation()) {
            if (type == 7) {
                part.setEntranceAnimation(false);
                holder.networkAvatar.setAlpha(0.0f);
                holder.networkAvatar.setScaleX(0.5f);
                holder.networkAvatar.setScaleY(0.5f);
                holder.networkAvatar.animate().alpha(1.0f).scaleX(1.0f).scaleY(1.0f).setDuration(300L).setStartDelay(100L).start();
                holder.cellLayout.setAlpha(0.0f);
                holder.cellLayout.setScaleX(0.5f);
                holder.cellLayout.setScaleY(0.5f);
                holder.cellLayout.animate().alpha(1.0f).scaleX(1.0f).scaleY(1.0f).setDuration(300L).setStartDelay(150L).start();
                ((AdminIsTypingView)holder.blocks.getChildAt(0)).beginAnimation();
            } else if (Part.MessageState.SENDING == part.getMessageState()) {
                part.setEntranceAnimation(false);
                holder.cellLayout.setAlpha(0.0f);
                holder.cellLayout.setTranslationY(holder.cellLayout.getTranslationY() + 100.0f);
                holder.time.setAlpha(0.0f);
                holder.time.setTranslationY(holder.time.getTranslationY() + 100.0f);
                holder.cellLayout.animate().setStartDelay(100L).alpha(1.0f).translationYBy(-100.0f).start();
                holder.time.animate().setStartDelay(100L).alpha(1.0f).translationYBy(-100.0f).start();
            }
        }
    }

    private void checkForEntranceAnimation(View view, int type, Part conversationPart) {
        if (conversationPart.hasEntranceAnimation() && type == 4) {
            ObjectAnimator animationSet = (ObjectAnimator)AnimatorInflater.loadAnimator((Context)this.getContext(), (int)R.animator.intercomsdk_fade_in_row);
            animationSet.setTarget((Object)view);
            animationSet.start();
            conversationPart.setEntranceAnimation(false);
        }
    }

    private void displayDelivered(ConversationHolder holder, Part conversationPart) {
        if (conversationPart.isDisplayDelivered()) {
            holder.time.setText((CharSequence)this.getContext().getString(R.string.intercomsdk_delivered));
        } else {
            holder.time.setText((CharSequence)new TimeUtils().getFormattedTime(conversationPart.getCreatedAt(), this.getContext()));
        }
    }

    private void setUpWelcomeRow(View row, Part conversationPart) {
        LinearLayout cellLayout = (LinearLayout)row.findViewById(R.id.cellLayout);
        LinearLayout blocks = conversationPart.getLayout();
        if (blocks.getParent() != null) {
            ((LinearLayout)blocks.getParent()).removeView((View)blocks);
        }
        cellLayout.addView((View)blocks, 0);
        row.setFocusable(false);
    }

    private void setCellRowColor(ConversationHolder holder) {
        Drawable bg = holder.blocks.getBackground();
        PorterDuffColorFilter filter = new PorterDuffColorFilter(Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor()), PorterDuff.Mode.MULTIPLY);
        bg.setColorFilter((ColorFilter)filter);
        BackgroundUtils.setBackground((View)holder.blocks, bg);
    }

    private void showAvatar(ConversationHolder holder, int position, Participant user) {
        if (holder.networkAvatar != null) {
            holder.networkAvatar.setTag((Object)position);
            holder.networkAvatar.setVisibility(0);
            AvatarUtils.createAvatar(user.isAdmin(), user.getAvatar(), holder.networkAvatar, this.getContext());
        }
    }

    private boolean isWithinBounds(int position) {
        return position >= 0 && position < this.getCount();
    }

    static class ConversationHolder {
        TextView time;
        ImageView networkAvatar;
        LinearLayout cellLayout;
        LinearLayout blocks;

        ConversationHolder() {
        }
    }
}

