/*
 * Copyright 2016 xyzxqs (xyzxqs@gmail.com)
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.github.xyzxqs.libs.xtask;


import java.util.concurrent.Executor;

import io.github.xyzxqs.libs.xtask.func.Action;
import io.github.xyzxqs.libs.xtask.func.Consumer;
import io.github.xyzxqs.libs.xtask.func.Supplier;


/**
 * @author xyzxqs (xyzxqs@gmail.com)
 */

public interface Worker<T> extends Cancellable {

    Worker<T> supplyAsync(Supplier<T> function);

    Worker<T> onResult(Consumer<Result<T>> consumer);

    Worker<T> ifCanceled(Action action);

    void execute();

    void execute(Executor exec);

    interface Factory {
        <U> Worker<U> createWorker();
    }
}
