/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.catalog.GetDeclaredMethodsFunction;
import io.github.toolfactory.jvm.function.catalog.ThrowExceptionFunction;
import io.github.toolfactory.jvm.function.template.TriFunction;
import io.github.toolfactory.jvm.util.ObjectProvider;
import io.github.toolfactory.jvm.util.Strings;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;

public interface GetDeclaredMethodFunction
extends TriFunction<Class<?>, String, Class<?>[], Method> {

    public static class ForJava7
    implements GetDeclaredMethodFunction {
        protected GetDeclaredMethodsFunction getDeclaredMethodsFunction;
        protected ThrowExceptionFunction throwExceptionFunction;

        public ForJava7(Map<Object, Object> context) {
            ObjectProvider functionProvider = ObjectProvider.get(context);
            this.getDeclaredMethodsFunction = functionProvider.getOrBuildObject(GetDeclaredMethodsFunction.class, context);
            this.throwExceptionFunction = functionProvider.getOrBuildObject(ThrowExceptionFunction.class, context);
        }

        @Override
        public Method apply(Class<?> cls, String name, Class<?>[] paramTypes) {
            try {
                if (paramTypes == null) {
                    paramTypes = new Class[]{};
                }
                for (Method method : (Method[])this.getDeclaredMethodsFunction.apply(cls)) {
                    if (!method.getName().equals(name) || paramTypes.length != method.getParameterTypes().length) continue;
                    Method toRet = method;
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        if (parameterTypes[i].equals(paramTypes[i])) continue;
                        toRet = null;
                        break;
                    }
                    if (toRet == null) continue;
                    return toRet;
                }
            }
            catch (Throwable exc) {
                return (Method)this.throwExceptionFunction.apply(exc, new Object[0]);
            }
            ArrayList<String> classNames = new ArrayList<String>();
            for (Class<?> paramType : paramTypes) {
                classNames.add(paramType.getName());
            }
            return (Method)this.throwExceptionFunction.apply(new NoSuchMethodException(Strings.compile("Method {}({}) not found in the class {}", name, Strings.join(", ", classNames), cls.getName())), new Object[0]);
        }
    }
}

