/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm;

import io.github.toolfactory.jvm.Info;
import java.lang.reflect.Method;

public class InfoImpl
implements Info {
    private final String osArch = System.getProperty("os.arch");
    private boolean is64Bit;
    private boolean is64BitHotspot;
    private boolean is32Bit;
    private boolean compressedRefsEnabled;
    private int version;

    public InfoImpl() {
        this.init();
    }

    public static InfoImpl getInstance() {
        return Holder.getWithinInstance();
    }

    public static InfoImpl create() {
        return new InfoImpl();
    }

    private void init() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int separatorIdx = version.indexOf(".");
            if (separatorIdx != -1) {
                version = version.substring(0, separatorIdx);
            } else {
                separatorIdx = version.indexOf("-");
                if (separatorIdx != -1) {
                    version = version.substring(0, separatorIdx);
                }
            }
        }
        this.version = Integer.parseInt(version);
        boolean is64Bit = false;
        boolean is32Bit = false;
        String x = System.getProperty("sun.arch.data.model");
        if (x != null) {
            is64Bit = x.contains("64");
            is32Bit = x.contains("32");
        } else {
            is64Bit = this.osArch != null && this.osArch.contains("64");
        }
        boolean compressedOops = false;
        boolean is64BitHotspot = false;
        if (is64Bit) {
            try {
                Class<?> beanClazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
                Object hotSpotBean = Class.forName("java.lang.management.ManagementFactory").getMethod("getPlatformMXBean", Class.class).invoke(null, beanClazz);
                if (hotSpotBean != null) {
                    is64BitHotspot = true;
                    Method getVMOptionMethod = beanClazz.getMethod("getVMOption", String.class);
                    try {
                        Object vmOption = getVMOptionMethod.invoke(hotSpotBean, "UseCompressedOops");
                        compressedOops = Boolean.parseBoolean(vmOption.getClass().getMethod("getValue", new Class[0]).invoke(vmOption, new Object[0]).toString());
                    }
                    catch (ReflectiveOperationException | RuntimeException e) {
                        is64BitHotspot = false;
                    }
                }
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                is64BitHotspot = false;
            }
        }
        this.is64Bit = is64Bit;
        this.is64BitHotspot = is64BitHotspot;
        this.is32Bit = is32Bit;
        this.compressedRefsEnabled = compressedOops;
    }

    @Override
    public boolean isCompressedOopsOffOn64BitHotspot() {
        return this.is64BitHotspot && !this.compressedRefsEnabled;
    }

    @Override
    public boolean isCompressedOopsOffOn64Bit() {
        return this.is64Bit && !this.compressedRefsEnabled;
    }

    @Override
    public boolean is32Bit() {
        return this.is32Bit;
    }

    @Override
    public boolean is64Bit() {
        return this.is64Bit;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    private static class Holder {
        private static final InfoImpl INSTANCE = InfoImpl.create();

        private Holder() {
        }

        private static InfoImpl getWithinInstance() {
            return INSTANCE;
        }
    }
}

