/*
 * Decompiled with CFR 0.152.
 */
package io.github.surpsg.offlins.sources.filter;

import io.github.surpsg.offlins.sources.filter.SourceFilter;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.pattern.PatternMatcher;
import org.gradle.api.internal.file.pattern.PatternMatcherFactory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J!\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0010\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f*\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/github/surpsg/offlins/sources/filter/AntSourceExcludeFilter;", "Lio/github/surpsg/offlins/sources/filter/SourceFilter;", "patterns", "", "", "<init>", "(Ljava/util/List;)V", "matcher", "Lorg/gradle/api/internal/file/pattern/PatternMatcher;", "filter", "Lorg/gradle/api/file/FileCollection;", "input", "matchFile", "", "segments", "", "isFile", "([Ljava/lang/String;Z)Z", "filterCollectionFiles", "originSources", "obtainSegments", "Ljava/io/File;", "(Ljava/io/File;)[Ljava/lang/String;", "Companion", "offlins-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nAntSourceExcludeFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AntSourceExcludeFilter.kt\nio/github/surpsg/offlins/sources/filter/AntSourceExcludeFilter\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,50:1\n37#2,2:51\n*S KotlinDebug\n*F\n+ 1 AntSourceExcludeFilter.kt\nio/github/surpsg/offlins/sources/filter/AntSourceExcludeFilter\n*L\n43#1:51,2\n*E\n"})
public final class AntSourceExcludeFilter
implements SourceFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> patterns;
    @NotNull
    private final PatternMatcher matcher;
    @NotNull
    private static final Logger log;

    public AntSourceExcludeFilter(@NotNull List<String> patterns) {
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        this.patterns = patterns;
        PatternMatcher patternMatcher = PatternMatcherFactory.getPatternsMatcher((boolean)true, (boolean)false, (Iterable)this.patterns);
        Intrinsics.checkNotNullExpressionValue((Object)patternMatcher, (String)"getPatternsMatcher(...)");
        this.matcher = patternMatcher;
    }

    @Override
    @NotNull
    public FileCollection filter(@NotNull FileCollection input) {
        FileCollection fileCollection;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (this.patterns.isEmpty()) {
            fileCollection = input;
        } else {
            log.info("Applied exclude patterns {} to classes", this.patterns);
            fileCollection = this.filterCollectionFiles(input);
        }
        return fileCollection;
    }

    public final boolean matchFile(@NotNull String[] segments, boolean isFile) {
        Intrinsics.checkNotNullParameter((Object)segments, (String)"segments");
        return !this.matcher.test(segments, isFile);
    }

    private final FileCollection filterCollectionFiles(FileCollection originSources) {
        FileCollection fileCollection = originSources.getAsFileTree().filter(arg_0 -> AntSourceExcludeFilter.filterCollectionFiles$lambda$1(arg_0 -> AntSourceExcludeFilter.filterCollectionFiles$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"filter(...)");
        return fileCollection;
    }

    private final String[] obtainSegments(File $this$obtainSegments) {
        Path path = $this$obtainSegments.toPath().toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
        Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)path), AntSourceExcludeFilter::obtainSegments$lambda$2));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    private static final boolean filterCollectionFiles$lambda$0(AntSourceExcludeFilter this$0, File file) {
        Intrinsics.checkNotNull((Object)file);
        String[] segments = this$0.obtainSegments(file);
        return this$0.matchFile(segments, file.isFile());
    }

    private static final boolean filterCollectionFiles$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String obtainSegments$lambda$2(Path it) {
        return ((Object)it).toString();
    }

    static {
        Logger logger = LoggerFactory.getLogger(AntSourceExcludeFilter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/github/surpsg/offlins/sources/filter/AntSourceExcludeFilter$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "offlins-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

