/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilderFactory;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.IndexDiffFilter;
import org.eclipse.jgit.treewalk.filter.SkipWorkTreeFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class IndexDiff {
    private static final int TREE = 0;
    private static final int INDEX = 1;
    private static final int WORKDIR = 2;
    private final Repository repository;
    private final AnyObjectId tree;
    private TreeFilter filter;
    private final WorkingTreeIterator initialWorkingTreeIterator;
    private Set<String> added;
    private Set<String> changed;
    private Set<String> removed;
    private Set<String> missing;
    private Set<String> missingSubmodules;
    private Set<String> modified;
    private Set<String> untracked;
    private Map<String, StageState> conflicts;
    private Set<String> ignored;
    private Set<String> assumeUnchanged;
    private DirCache dirCache;
    private IndexDiffFilter indexDiffFilter;
    private Map<String, IndexDiff> submoduleIndexDiffs;
    private SubmoduleWalk.IgnoreSubmoduleMode ignoreSubmoduleMode;
    private Map<FileMode, Set<String>> fileModes;
    private WorkingTreeIteratorFactory wTreeIt;

    public IndexDiff(Repository repository, String revstr, WorkingTreeIterator workingTreeIterator) throws IOException {
        this(repository, repository.resolve(revstr), workingTreeIterator);
    }

    public IndexDiff(Repository repository, ObjectId objectId, WorkingTreeIterator workingTreeIterator) throws IOException {
        block10: {
            this.filter = null;
            this.added = new HashSet<String>();
            this.changed = new HashSet<String>();
            this.removed = new HashSet<String>();
            this.missing = new HashSet<String>();
            this.missingSubmodules = new HashSet<String>();
            this.modified = new HashSet<String>();
            this.untracked = new HashSet<String>();
            this.conflicts = new HashMap<String, StageState>();
            this.submoduleIndexDiffs = new HashMap<String, IndexDiff>();
            this.ignoreSubmoduleMode = null;
            this.fileModes = new HashMap<FileMode, Set<String>>();
            this.wTreeIt = FileTreeIterator::new;
            this.repository = repository;
            if (objectId != null) {
                Throwable throwable = null;
                Object var5_6 = null;
                try (RevWalk rw = new RevWalk(repository);){
                    this.tree = rw.parseTree(objectId);
                    break block10;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.tree = null;
        }
        this.initialWorkingTreeIterator = workingTreeIterator;
    }

    public void setIgnoreSubmoduleMode(SubmoduleWalk.IgnoreSubmoduleMode mode) {
        this.ignoreSubmoduleMode = mode;
    }

    public void setWorkingTreeItFactory(WorkingTreeIteratorFactory wTreeIt) {
        this.wTreeIt = wTreeIt;
    }

    public void setFilter(TreeFilter filter) {
        this.filter = filter;
    }

    public boolean diff() throws IOException {
        return this.diff(null);
    }

    public boolean diff(RepositoryBuilderFactory factory) throws IOException {
        return this.diff(null, 0, 0, "", factory);
    }

    public boolean diff(ProgressMonitor monitor, int estWorkTreeSize, int estIndexSize, String title) throws IOException {
        return this.diff(monitor, estWorkTreeSize, estIndexSize, title, null);
    }

    public boolean diff(ProgressMonitor monitor, int estWorkTreeSize, int estIndexSize, String title, RepositoryBuilderFactory factory) throws IOException {
        this.dirCache = this.repository.readDirCache();
        Throwable throwable = null;
        Object var7_9 = null;
        try (TreeWalk treeWalk = new TreeWalk(this.repository);){
            treeWalk.setOperationType(TreeWalk.OperationType.CHECKIN_OP);
            treeWalk.setRecursive(true);
            if (this.tree != null) {
                treeWalk.addTree(this.tree);
            } else {
                treeWalk.addTree(new EmptyTreeIterator());
            }
            treeWalk.addTree(new DirCacheIterator(this.dirCache));
            treeWalk.addTree(this.initialWorkingTreeIterator);
            this.initialWorkingTreeIterator.setDirCacheIterator(treeWalk, 1);
            ArrayList<TreeFilter> filters = new ArrayList<TreeFilter>(4);
            if (monitor != null) {
                if (estIndexSize == 0) {
                    estIndexSize = this.dirCache.getEntryCount();
                }
                int total = Math.max(estIndexSize * 10 / 9, estWorkTreeSize * 10 / 9);
                monitor.beginTask(title, total);
                filters.add(new ProgressReportingFilter(monitor, total));
            }
            if (this.filter != null) {
                filters.add(this.filter);
            }
            filters.add(new SkipWorkTreeFilter(1));
            this.indexDiffFilter = new IndexDiffFilter(1, 2);
            filters.add(this.indexDiffFilter);
            treeWalk.setFilter(AndTreeFilter.create(filters));
            this.fileModes.clear();
            while (treeWalk.next()) {
                String path2;
                int stage;
                DirCacheEntry dirCacheEntry;
                AbstractTreeIterator treeIterator = treeWalk.getTree(0, AbstractTreeIterator.class);
                DirCacheIterator dirCacheIterator = treeWalk.getTree(1, DirCacheIterator.class);
                WorkingTreeIterator workingTreeIterator = treeWalk.getTree(2, WorkingTreeIterator.class);
                if (dirCacheIterator != null && (dirCacheEntry = dirCacheIterator.getDirCacheEntry()) != null && (stage = dirCacheEntry.getStage()) > 0) {
                    String path3 = treeWalk.getPathString();
                    this.addConflict(path3, stage);
                    continue;
                }
                if (treeIterator != null) {
                    if (dirCacheIterator != null) {
                        if (!(treeIterator.idEqual(dirCacheIterator) && treeIterator.getEntryRawMode() == dirCacheIterator.getEntryRawMode() || this.isEntryGitLink(treeIterator) && this.isEntryGitLink(dirCacheIterator) && this.ignoreSubmoduleMode == SubmoduleWalk.IgnoreSubmoduleMode.ALL)) {
                            this.changed.add(treeWalk.getPathString());
                        }
                    } else {
                        if (!this.isEntryGitLink(treeIterator) || this.ignoreSubmoduleMode != SubmoduleWalk.IgnoreSubmoduleMode.ALL) {
                            this.removed.add(treeWalk.getPathString());
                        }
                        if (workingTreeIterator != null) {
                            this.untracked.add(treeWalk.getPathString());
                        }
                    }
                } else if (dirCacheIterator != null) {
                    if (!this.isEntryGitLink(dirCacheIterator) || this.ignoreSubmoduleMode != SubmoduleWalk.IgnoreSubmoduleMode.ALL) {
                        this.added.add(treeWalk.getPathString());
                    }
                } else if (workingTreeIterator != null && !workingTreeIterator.isEntryIgnored()) {
                    this.untracked.add(treeWalk.getPathString());
                }
                if (dirCacheIterator != null) {
                    if (workingTreeIterator == null) {
                        boolean isGitLink = this.isEntryGitLink(dirCacheIterator);
                        if (!isGitLink || this.ignoreSubmoduleMode != SubmoduleWalk.IgnoreSubmoduleMode.ALL) {
                            String path4 = treeWalk.getPathString();
                            this.missing.add(path4);
                            if (isGitLink) {
                                this.missingSubmodules.add(path4);
                            }
                        }
                    } else if (workingTreeIterator.isModified(dirCacheIterator.getDirCacheEntry(), true, treeWalk.getObjectReader()) && (!this.isEntryGitLink(dirCacheIterator) || !this.isEntryGitLink(workingTreeIterator) || this.ignoreSubmoduleMode != SubmoduleWalk.IgnoreSubmoduleMode.ALL && this.ignoreSubmoduleMode != SubmoduleWalk.IgnoreSubmoduleMode.DIRTY)) {
                        this.modified.add(treeWalk.getPathString());
                    }
                }
                if ((path2 = treeWalk.getPathString()) == null) continue;
                int i = 0;
                while (i < treeWalk.getTreeCount()) {
                    this.recordFileMode(path2, treeWalk.getFileMode(i));
                    ++i;
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (this.ignoreSubmoduleMode != SubmoduleWalk.IgnoreSubmoduleMode.ALL) {
            throwable = null;
            var7_9 = null;
            try (SubmoduleWalk smw = new SubmoduleWalk(this.repository);){
                smw.setTree(new DirCacheIterator(this.dirCache));
                smw.setBuilderFactory(factory);
                while (smw.next()) {
                    SubmoduleWalk.IgnoreSubmoduleMode localIgnoreSubmoduleMode = this.ignoreSubmoduleMode;
                    try {
                        if (localIgnoreSubmoduleMode == null) {
                            localIgnoreSubmoduleMode = smw.getModulesIgnore();
                        }
                        if (SubmoduleWalk.IgnoreSubmoduleMode.ALL.equals((Object)localIgnoreSubmoduleMode)) {
                            continue;
                        }
                    }
                    catch (ConfigInvalidException e) {
                        throw new IOException(MessageFormat.format(JGitText.get().invalidIgnoreParamSubmodule, smw.getPath()), e);
                    }
                    Throwable throwable3 = null;
                    Object var11_19 = null;
                    try (Repository subRepo = smw.getRepository();){
                        File dir;
                        File gitDir;
                        String subRepoPath = smw.getPath();
                        if (subRepo != null) {
                            ObjectId subHead = subRepo.resolve("HEAD");
                            if (subHead != null && !subHead.equals(smw.getObjectId())) {
                                this.modified.add(subRepoPath);
                                this.recordFileMode(subRepoPath, FileMode.GITLINK);
                                continue;
                            }
                            if (localIgnoreSubmoduleMode == SubmoduleWalk.IgnoreSubmoduleMode.DIRTY) continue;
                            IndexDiff smid = this.submoduleIndexDiffs.get(smw.getPath());
                            if (smid == null) {
                                smid = new IndexDiff(subRepo, smw.getObjectId(), this.wTreeIt.getWorkingTreeIterator(subRepo));
                                this.submoduleIndexDiffs.put(subRepoPath, smid);
                            }
                            if (!smid.diff(factory) || localIgnoreSubmoduleMode == SubmoduleWalk.IgnoreSubmoduleMode.UNTRACKED && smid.getAdded().isEmpty() && smid.getChanged().isEmpty() && smid.getConflicting().isEmpty() && smid.getMissing().isEmpty() && smid.getModified().isEmpty() && smid.getRemoved().isEmpty()) continue;
                            this.modified.add(subRepoPath);
                            this.recordFileMode(subRepoPath, FileMode.GITLINK);
                            continue;
                        }
                        if (!this.missingSubmodules.remove(subRepoPath) || (gitDir = new File(new File(this.repository.getDirectory(), "modules"), subRepoPath)).isDirectory() || !(dir = SubmoduleWalk.getSubmoduleDirectory(this.repository, subRepoPath)).isDirectory() || this.hasFiles(dir)) continue;
                        this.missing.remove(subRepoPath);
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        if (monitor != null) {
            monitor.endTask();
        }
        this.ignored = this.indexDiffFilter.getIgnoredPaths();
        return !this.added.isEmpty() || !this.changed.isEmpty() || !this.removed.isEmpty() || !this.missing.isEmpty() || !this.modified.isEmpty() || !this.untracked.isEmpty();
    }

    private boolean hasFiles(File directory) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DirectoryStream<Path> dir = Files.newDirectoryStream(directory.toPath());){
                return dir.iterator().hasNext();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | DirectoryIteratorException e) {
            return false;
        }
    }

    private void recordFileMode(String path2, FileMode mode) {
        Set<String> values2 = this.fileModes.get(mode);
        if (path2 != null) {
            if (values2 == null) {
                values2 = new HashSet<String>();
                this.fileModes.put(mode, values2);
            }
            values2.add(path2);
        }
    }

    private boolean isEntryGitLink(AbstractTreeIterator ti) {
        return ti != null && ti.getEntryRawMode() == FileMode.GITLINK.getBits();
    }

    private void addConflict(String path2, int stage) {
        StageState existingStageStates = this.conflicts.get(path2);
        byte stageMask = 0;
        if (existingStageStates != null) {
            stageMask = (byte)(stageMask | (byte)existingStageStates.getStageMask());
        }
        int shifts = stage - 1;
        stageMask = (byte)(stageMask | (byte)(1 << shifts));
        StageState stageState = StageState.fromMask(stageMask);
        this.conflicts.put(path2, stageState);
    }

    public Set<String> getAdded() {
        return this.added;
    }

    public Set<String> getChanged() {
        return this.changed;
    }

    public Set<String> getRemoved() {
        return this.removed;
    }

    public Set<String> getMissing() {
        return this.missing;
    }

    public Set<String> getModified() {
        return this.modified;
    }

    public Set<String> getUntracked() {
        return this.untracked;
    }

    public Set<String> getConflicting() {
        return this.conflicts.keySet();
    }

    public Map<String, StageState> getConflictingStageStates() {
        return this.conflicts;
    }

    public Set<String> getIgnoredNotInIndex() {
        return this.ignored;
    }

    public Set<String> getAssumeUnchanged() {
        if (this.assumeUnchanged == null) {
            HashSet<String> unchanged = new HashSet<String>();
            int i = 0;
            while (i < this.dirCache.getEntryCount()) {
                if (this.dirCache.getEntry(i).isAssumeValid()) {
                    unchanged.add(this.dirCache.getEntry(i).getPathString());
                }
                ++i;
            }
            this.assumeUnchanged = unchanged;
        }
        return this.assumeUnchanged;
    }

    public Set<String> getUntrackedFolders() {
        return this.indexDiffFilter == null ? Collections.emptySet() : new HashSet<String>(this.indexDiffFilter.getUntrackedFolders());
    }

    public FileMode getIndexMode(String path2) {
        DirCacheEntry entry = this.dirCache.getEntry(path2);
        return entry != null ? entry.getFileMode() : FileMode.MISSING;
    }

    public Set<String> getPathsWithIndexMode(FileMode mode) {
        Set<String> paths = this.fileModes.get(mode);
        if (paths == null) {
            paths = new HashSet<String>();
        }
        return paths;
    }

    private static final class ProgressReportingFilter
    extends TreeFilter {
        private final ProgressMonitor monitor;
        private int count = 0;
        private int stepSize;
        private final int total;

        private ProgressReportingFilter(ProgressMonitor monitor, int total) {
            this.monitor = monitor;
            this.total = total;
            this.stepSize = total / 100;
            if (this.stepSize == 0) {
                this.stepSize = 1000;
            }
        }

        @Override
        public boolean shouldBeRecursive() {
            return false;
        }

        @Override
        public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            ++this.count;
            if (this.count % this.stepSize == 0) {
                if (this.count <= this.total) {
                    this.monitor.update(this.stepSize);
                }
                if (this.monitor.isCancelled()) {
                    throw StopWalkException.INSTANCE;
                }
            }
            return true;
        }

        @Override
        public TreeFilter clone() {
            throw new IllegalStateException("Do not clone this kind of filter: " + this.getClass().getName());
        }
    }

    public static enum StageState {
        BOTH_DELETED(1),
        ADDED_BY_US(2),
        DELETED_BY_THEM(3),
        ADDED_BY_THEM(4),
        DELETED_BY_US(5),
        BOTH_ADDED(6),
        BOTH_MODIFIED(7);

        private final int stageMask;

        private StageState(int stageMask) {
            this.stageMask = stageMask;
        }

        int getStageMask() {
            return this.stageMask;
        }

        public boolean hasBase() {
            return (this.stageMask & 1) != 0;
        }

        public boolean hasOurs() {
            return (this.stageMask & 2) != 0;
        }

        public boolean hasTheirs() {
            return (this.stageMask & 4) != 0;
        }

        static StageState fromMask(int stageMask) {
            switch (stageMask) {
                case 1: {
                    return BOTH_DELETED;
                }
                case 2: {
                    return ADDED_BY_US;
                }
                case 3: {
                    return DELETED_BY_THEM;
                }
                case 4: {
                    return ADDED_BY_THEM;
                }
                case 5: {
                    return DELETED_BY_US;
                }
                case 6: {
                    return BOTH_ADDED;
                }
                case 7: {
                    return BOTH_MODIFIED;
                }
            }
            return null;
        }
    }

    public static interface WorkingTreeIteratorFactory {
        public WorkingTreeIterator getWorkingTreeIterator(Repository var1);
    }
}

