/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.locators;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.gradle.plugin.commons.AndroidVariantCompilationKit;
import kotlinx.kover.gradle.plugin.commons.JvmCompilationKit;
import kotlinx.kover.gradle.plugin.commons.KotlinPluginType;
import kotlinx.kover.gradle.plugin.commons.KoverCriticalException;
import kotlinx.kover.gradle.plugin.commons.KoverIllegalConfigException;
import kotlinx.kover.gradle.plugin.locators.CompilationsListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\b\u0010\u000e\u001a\u00020\nH\u0002J\u0006\u0010\u000f\u001a\u00020\nJ\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lkotlinx/kover/gradle/plugin/locators/CompilationsListenerWrapper;", "", "listener", "Lkotlinx/kover/gradle/plugin/locators/CompilationsListener;", "(Lkotlinx/kover/gradle/plugin/locators/CompilationsListener;)V", "finalized", "", "pluginType", "Lkotlinx/kover/gradle/plugin/commons/KotlinPluginType;", "android", "", "compilations", "", "Lkotlinx/kover/gradle/plugin/commons/AndroidVariantCompilationKit;", "checkNotFinalized", "finalize", "finalizeIfNoKotlinPlugin", "jvm", "compilation", "Lkotlinx/kover/gradle/plugin/commons/JvmCompilationKit;", "onApplyPlugin", "type", "kover-gradle-plugin"})
public final class CompilationsListenerWrapper {
    @NotNull
    private final CompilationsListener listener;
    @Nullable
    private volatile KotlinPluginType pluginType;
    private volatile boolean finalized;

    public CompilationsListenerWrapper(@NotNull CompilationsListener listener2) {
        Intrinsics.checkNotNullParameter(listener2, "listener");
        this.listener = listener2;
    }

    public final void onApplyPlugin(@NotNull KotlinPluginType type) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        if (this.pluginType != null) {
            KotlinPluginType kotlinPluginType = this.pluginType;
            throw new KoverIllegalConfigException("Kover can't work in a project where several different Kotlin plugins are applied.\nDetected plugins " + (kotlinPluginType != null ? kotlinPluginType.name() : null) + " and " + type.name() + ", remove one of them");
        }
        this.pluginType = type;
    }

    public final void jvm(@NotNull JvmCompilationKit compilation) {
        Intrinsics.checkNotNullParameter(compilation, "compilation");
        this.checkNotFinalized();
        this.listener.onJvmCompilation(compilation);
    }

    public final void android(@NotNull List<AndroidVariantCompilationKit> compilations2) {
        Intrinsics.checkNotNullParameter(compilations2, "compilations");
        this.checkNotFinalized();
        this.listener.onAndroidCompilations(compilations2);
    }

    public final void finalizeIfNoKotlinPlugin() {
        if (this.pluginType == null) {
            this.finalize();
        }
    }

    public final void finalize() {
        this.checkNotFinalized();
        this.finalized = true;
        this.listener.onFinalize();
    }

    private final void checkNotFinalized() {
        if (this.finalized) {
            throw new KoverCriticalException("Listener is finalized", null, 2, null);
        }
    }
}

